/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.block.BlockColossalBloodChest;
import org.cyclops.evilcraft.blockentity.BlockEntityColossalBloodChest;
import org.cyclops.evilcraft.core.algorithm.Wrapper;

public class BlockReinforcedUndeadPlank
extends Block
implements CubeDetector.IDetectionListener {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public BlockReinforcedUndeadPlank(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public RenderShape m_7514_(BlockState blockState) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false)) != false ? RenderShape.ENTITYBLOCK_ANIMATED : super.m_7514_(blockState);
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockReader, BlockPos blockPos) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public boolean shouldDisplayFluidOverlay(BlockState blockState, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        if (!world.captureBlockSnapshots) {
            BlockColossalBloodChest.triggerDetector((LevelReader)world, pos, true);
        }
    }

    public void m_6807_(BlockState blockStateNew, Level world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.m_6807_(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!world.captureBlockSnapshots && blockStateNew.m_60734_() != blockStateOld.m_60734_() && !((Boolean)blockStateNew.m_61143_((Property)ACTIVE)).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((LevelReader)world, blockPos, true);
        }
    }

    public void m_6786_(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        super.m_6786_(worldIn, pos, state);
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)state, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((LevelReader)worldIn, pos, false);
        }
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)state, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((LevelReader)world, pos, false);
        }
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        this.m_7592_(world, pos, explosion);
    }

    public void onDetect(LevelReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.m_8055_(location).m_60734_();
        if (block == this) {
            boolean change = (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)world.m_8055_(location), (Property)ACTIVE, (Comparable)Boolean.valueOf(false)) == false;
            ((Level)world).m_7731_(location, (BlockState)world.m_8055_(location).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(valid)), 2);
            if (change) {
                BlockEntityColossalBloodChest.detectStructure((Level)world, location, size, valid, originCorner);
            }
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult p_225533_6_) {
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            final Wrapper tileLocationWrapper = new Wrapper();
            BlockEntityColossalBloodChest.getCubeDetector().detect((LevelReader)world, blockPos, null, new CubeDetector.IValidationAction(){

                public Component onValidate(BlockPos location, BlockState blockState) {
                    if (blockState.m_60734_() instanceof BlockColossalBloodChest) {
                        tileLocationWrapper.set(location);
                    }
                    return null;
                }
            }, false);
            BlockPos tileLocation = (BlockPos)tileLocationWrapper.get();
            if (tileLocation != null) {
                return world.m_8055_(tileLocation).m_60734_().m_6227_(world.m_8055_(tileLocation), world, tileLocation, player, hand, p_225533_6_);
            }
            return super.m_6227_(blockState, world, blockPos, player, hand, p_225533_6_);
        }
        BlockColossalBloodChest.addPlayerChatError(world, blockPos, player, hand);
        return InteractionResult.FAIL;
    }
}

