/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.magmator;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import owmii.powah.EnvHandler;
import owmii.powah.Powah;
import owmii.powah.block.Tier;
import owmii.powah.block.magmator.MagmatorTile;
import owmii.powah.config.v2.types.GeneratorConfig;
import owmii.powah.inventory.MagmatorContainer;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.block.AbstractGeneratorBlock;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.logistics.inventory.AbstractContainer;

public class MagmatorBlock
extends AbstractGeneratorBlock<MagmatorBlock> {
    public MagmatorBlock(BlockBehaviour.Properties properties, Tier variant) {
        super(properties, variant);
        this.setDefaultState();
    }

    @Override
    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable ResourceKey<CreativeModeTab> group) {
        return super.getBlockItem(properties.m_41487_(1), (ResourceKey)group);
    }

    @Override
    public GeneratorConfig getConfig() {
        return Powah.config().generators.magmators;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MagmatorTile(pos, state, (Tier)this.variant);
    }

    @Override
    @Nullable
    public <T extends AbstractTileEntity> AbstractContainer getContainer(int id, Inventory inventory, AbstractTileEntity te, BlockHitResult result) {
        if (te instanceof MagmatorTile) {
            return new MagmatorContainer(id, inventory, (MagmatorTile)te);
        }
        return null;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        MagmatorTile magmator;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof MagmatorTile && EnvHandler.INSTANCE.interactWithTank(player, hand, (magmator = (MagmatorTile)tile).getTank())) {
            magmator.sync();
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, result);
    }

    @Override
    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.HORIZONTAL;
    }

    @Override
    protected boolean isPlacerFacing() {
        return true;
    }

    @Override
    protected boolean hasLitProp() {
        return true;
    }
}

