/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox;

import commoble.hyperbox.dimension.HyperboxChunkGenerator;
import commoble.hyperbox.dimension.HyperboxDimension;
import commoble.hyperbox.dimension.HyperboxRegionFileStorage;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.dimension.DimensionType;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class MixinCallbacks {
    public static int modifyChunkManagerViewDistance(Supplier<ServerLevel> levelSupplier, int viewDistanceIn) {
        ServerLevel level = levelSupplier.get();
        MinecraftServer server = level.m_7654_();
        DimensionType hyperboxDimensionType = HyperboxDimension.getDimensionType(server);
        return hyperboxDimensionType == level.m_6042_() ? 2 : viewDistanceIn;
    }

    public static void onIOWorkerConstruction(Path path, boolean sync, Consumer<RegionFileStorage> cacheConsumer) {
        String s = path.toString();
        if (s.contains("dimensions/hyperbox") || s.contains("dimensions\\hyperbox")) {
            cacheConsumer.accept(new HyperboxRegionFileStorage(path, sync));
        }
    }

    public static void onServerWorldPlaySound(ServerLevel serverLevel, @Nullable Player ignoredPlayer, double x, double y, double z, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed, CallbackInfo info) {
        MinecraftServer server = serverLevel.m_7654_();
        List players = server.m_6846_().m_11314_();
        int playerCount = players.size();
        for (int i = 0; i < playerCount; ++i) {
            double radius;
            DimensionType hyperboxDimensionType;
            ServerLevel playerLevel;
            ServerPlayer serverPlayer = (ServerPlayer)players.get(i);
            if (serverPlayer == null || serverPlayer == ignoredPlayer || (playerLevel = serverPlayer.m_284548_()) == null || (hyperboxDimensionType = HyperboxDimension.getDimensionType(server)) != playerLevel.m_6042_()) continue;
            HyperboxDimension.IterationResult result = HyperboxDimension.getHyperboxIterationDepth(server, serverLevel, playerLevel);
            int iterations = result.iterations();
            BlockPos pos = result.parentPos();
            if (iterations < 0 || pos == null) continue;
            double dx = x - (double)pos.m_123341_();
            double dy = y - (double)pos.m_123342_();
            double dz = z - (double)pos.m_123343_();
            double d = radius = volume > 1.0f ? (double)volume * 16.0 : 16.0;
            if (!(dx * dx + dy * dy + dz * dz < radius * radius)) continue;
            double soundMultiplier = Math.pow(0.5, iterations);
            float scaledVolume = (float)(soundMultiplier * (double)volume * 0.5);
            float scaledPitch = (float)(soundMultiplier * (double)pitch);
            double packetX = (double)HyperboxChunkGenerator.CENTER.m_123341_() + dx;
            double packetY = (double)HyperboxChunkGenerator.CENTER.m_123342_() + dy;
            double packetZ = (double)HyperboxChunkGenerator.CENTER.m_123343_() + dz;
            ClientboundSoundPacket packet = new ClientboundSoundPacket(sound, category, packetX, packetY, packetZ, scaledVolume, scaledPitch, seed);
            serverPlayer.f_8906_.m_9829_((Packet)packet);
        }
    }
}

