/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.block.entity;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.blockentity.powersink.IExternalPowerSink;
import gripe._90.arseng.block.entity.IAdvancedSourceTile;
import gripe._90.arseng.definition.ArsEngBlocks;
import gripe._90.arseng.definition.ArsEngCapabilities;
import gripe._90.arseng.me.misc.SourceEnergyAdaptor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceAcceptorBlockEntity
extends AENetworkBlockEntity
implements IExternalPowerSink {
    private LazyOptional<IAdvancedSourceTile> sourceTileOptional;

    public SourceAcceptorBlockEntity(BlockPos pos, BlockState state) {
        super(ArsEngBlocks.SOURCE_ACCEPTOR_ENTITY, pos, state);
        this.getMainNode().setIdlePowerUsage(0.0);
    }

    public void onLoad() {
        super.onLoad();
        this.sourceTileOptional = LazyOptional.of(() -> new SourceEnergyAdaptor(this, (IActionHost)this));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return ArsEngCapabilities.SOURCE_TILE.orEmpty(cap, this.sourceTileOptional);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.sourceTileOptional.invalidate();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    protected double getFunnelPowerDemand(double maxRequired) {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null ? grid.getEnergyService().getEnergyDemand(maxRequired) : 0.0;
    }

    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null ? grid.getEnergyService().injectPower(power, mode) : 0.0;
    }

    public final double getExternalPowerDemand(PowerUnits externalUnit, double maxPowerRequired) {
        return PowerUnits.AE.convertTo(externalUnit, Math.max(0.0, this.getFunnelPowerDemand(externalUnit.convertTo(PowerUnits.AE, maxPowerRequired))));
    }

    public final double injectExternalPower(PowerUnits input, double amt, Actionable mode) {
        return PowerUnits.AE.convertTo(input, this.funnelPowerIntoStorage(input.convertTo(PowerUnits.AE, amt), mode));
    }

    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    public double injectAEPower(double amt, Actionable mode) {
        return 0.0;
    }

    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier multiplier) {
        return 0.0;
    }

    public double getAEMaxPower() {
        return 0.0;
    }

    public double getAECurrentPower() {
        return 0.0;
    }

    public boolean isAEPublicPowerStorage() {
        return false;
    }
}

