/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.harvestwithease.handler;

import com.mojang.logging.LogUtils;
import crystalspider.harvestwithease.api.HarvestWithEaseAPI;
import crystalspider.harvestwithease.config.ModConfig;
import java.util.NoSuchElementException;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="harvestwithease", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class BreakEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void handle(BlockEvent.BreakEvent event) {
        try {
            LevelAccessor world = event.getLevel();
            BlockState blockState = event.getState();
            Block block = blockState.m_60734_();
            if (!world.m_5776_() && ModConfig.getGrantedExp() > 0 && HarvestWithEaseAPI.isCrop(block) && HarvestWithEaseAPI.isMature(blockState)) {
                block.m_49805_((ServerLevel)world, event.getPos(), ModConfig.getGrantedExp().intValue());
            }
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException e) {
            BlockPos pos = event.getPos();
            LOGGER.debug("Exception generated by block at [" + pos.m_123344_() + "]");
            LOGGER.debug("This is a non blocking error, but can result in incorrect behavior for mod harvestwithease");
            LOGGER.debug("Most probably the cause of this issue was that a non-crop ID was added in the configuration and its age property could not be retrieved, see stack trace for more details", (Throwable)e);
        }
    }
}

