/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.common.inventory.attachment;

import cofh.core.common.inventory.ContainerMenuCoFH;
import cofh.core.common.network.packet.client.ContainerGuiPacket;
import cofh.core.util.filter.BaseFluidFilter;
import cofh.core.util.filter.IFilterOptions;
import cofh.lib.common.inventory.SlotFalseCopy;
import cofh.lib.common.inventory.wrapper.InvWrapperFluids;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.attachment.FluidFilterAttachment;
import cofh.thermal.dynamics.common.inventory.attachment.AttachmentMenu;
import cofh.thermal.dynamics.common.network.packet.server.AttachmentConfigPacket;
import cofh.thermal.dynamics.init.registries.TDynContainers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class FluidFilterAttachmentMenu
extends AttachmentMenu
implements IFilterOptions {
    public final FluidFilterAttachment attachment;
    protected BaseFluidFilter filter;
    protected InvWrapperFluids filterInventory;

    public FluidFilterAttachmentMenu(int id, Level world, BlockPos pos, Direction side, Inventory inventory, Player player) {
        super((MenuType)TDynContainers.FLUID_FILTER_ATTACHMENT_CONTAINER.get(), id, world, pos, side, inventory, player);
        IDuct duct;
        Object object = this.hostTile;
        if (object instanceof IDuct && (object = (duct = (IDuct)object).getAttachment(side)) instanceof FluidFilterAttachment) {
            FluidFilterAttachment expectedAttachment;
            this.attachment = expectedAttachment = (FluidFilterAttachment)object;
            this.filter = (BaseFluidFilter)this.attachment.getFilter();
        } else {
            this.attachment = null;
        }
        this.allowSwap = false;
        if (this.filter != null) {
            int slots = this.filter.size();
            this.filterInventory = new InvWrapperFluids((AbstractContainerMenu)this, this.filter.getFluids(), slots);
            int rows = MathHelper.clamp((int)(slots / 3), (int)1, (int)3);
            int rowSize = slots / rows;
            int xOffset = 62 - 9 * rowSize;
            int yOffset = 44 - 9 * rows;
            for (int i = 0; i < this.filter.size(); ++i) {
                this.m_38897_((Slot)new SlotFalseCopy((Container)this.filterInventory, i, xOffset + i % rowSize * 18, yOffset + i / rowSize * 18));
            }
        }
        this.bindPlayerInventory(inventory);
    }

    public int getFilterSize() {
        return this.filter.size();
    }

    public List<FluidStack> getFilterStacks() {
        return this.filterInventory.getStacks();
    }

    protected int getMergeableSlotCount() {
        return this.filterInventory.m_6643_();
    }

    public void m_38946_() {
        super.m_38946_();
        ContainerGuiPacket.sendToClient((ContainerMenuCoFH)this, (Player)this.player);
    }

    public void m_6877_(Player playerIn) {
        this.filter.setFluids(this.filterInventory.getStacks());
        super.m_6877_(playerIn);
    }

    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        int size = this.filter.getFluids().size();
        buffer.writeByte(size);
        for (int i = 0; i < size; ++i) {
            buffer.writeFluidStack(this.getFilterStacks().get(i));
        }
        return buffer;
    }

    public void handleGuiPacket(FriendlyByteBuf buffer) {
        int size = buffer.readByte();
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>(size);
        for (int i = 0; i < size; ++i) {
            fluidStacks.add(buffer.readFluidStack());
        }
        this.filterInventory.readFromSource(fluidStacks);
    }

    public boolean getAllowList() {
        return this.filter.getAllowList();
    }

    public boolean setAllowList(boolean allowList) {
        boolean ret = this.filter.setAllowList(allowList);
        AttachmentConfigPacket.sendToServer(this.attachment);
        return ret;
    }

    public boolean getCheckNBT() {
        return this.filter.getCheckNBT();
    }

    public boolean setCheckNBT(boolean checkNBT) {
        boolean ret = this.filter.setCheckNBT(checkNBT);
        AttachmentConfigPacket.sendToServer(this.attachment);
        return ret;
    }
}

