/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.TierSortingRegistry;
import net.silentchaos512.gear.api.util.IGearComponentInstance;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.utils.Color;

public class TierHelper {
    private static Map<Tier, Color> TEXT_COLORS = new HashMap<Tier, Color>();

    public static Tier getHighestTier(Collection<? extends IGearComponentInstance<?>> components) {
        Tier max = TierHelper.weakestTier();
        for (IGearComponentInstance<?> comp : components) {
            Tier tier = comp.getHarvestTier();
            if (TierSortingRegistry.getTiersLowerThan((Tier)tier).size() <= TierSortingRegistry.getTiersLowerThan((Tier)max).size()) continue;
            max = tier;
        }
        return max;
    }

    public static Tier weakestTier() {
        List sortedTiers = TierSortingRegistry.getSortedTiers();
        if (sortedTiers.size() > 0) {
            return (Tier)sortedTiers.get(0);
        }
        return Tiers.WOOD;
    }

    public static Tier getHigher(Tier a, Tier b) {
        return TierSortingRegistry.getTiersLowerThan((Tier)a).size() > TierSortingRegistry.getTiersLowerThan((Tier)b).size() ? a : b;
    }

    public static Color getTextColor(Tier tier) {
        return TEXT_COLORS.getOrDefault(tier, Color.WHITE);
    }

    public static MutableComponent getTranslatedName(Tier tier) {
        ResourceLocation name = TierSortingRegistry.getName((Tier)tier);
        if (name == null) {
            return Component.m_237113_((String)"null");
        }
        return Component.m_237115_((String)("harvestTier." + name.m_135827_() + "." + name.m_135815_()));
    }

    public static MutableComponent getTranslatedNameWithColor(Tier tier) {
        MutableComponent text = TierHelper.getTranslatedName(tier);
        Color color = TierHelper.getTextColor(tier);
        return TextUtil.withColor(text, color);
    }

    static {
        TEXT_COLORS.put((Tier)Tiers.WOOD, new Color(9004839));
        TEXT_COLORS.put((Tier)Tiers.STONE, new Color(0x9A9A9A));
        TEXT_COLORS.put((Tier)Tiers.IRON, new Color(0xD8D8D8));
        TEXT_COLORS.put((Tier)Tiers.DIAMOND, new Color(3402699));
        TEXT_COLORS.put((Tier)Tiers.GOLD, new Color(16646000));
        TEXT_COLORS.put((Tier)Tiers.NETHERITE, new Color(8813446));
    }
}

