/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.command.MaterialsCommand;
import net.silentchaos512.gear.command.TraitsCommand;

public class ClientOutputCommandPacket {
    private final Type type;
    private final boolean includeChildren;

    public ClientOutputCommandPacket(Type type, boolean includeChildren) {
        this.type = type;
        this.includeChildren = includeChildren;
    }

    public static ClientOutputCommandPacket decode(FriendlyByteBuf buffer) {
        Type type = (Type)buffer.m_130066_(Type.class);
        boolean includeChildren = buffer.readBoolean();
        return new ClientOutputCommandPacket(type, includeChildren);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.type);
        buffer.writeBoolean(this.includeChildren);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        switch (this.type) {
            case MATERIALS: {
                MaterialsCommand.runDumpClient(this.includeChildren);
                break;
            }
            case TRAITS: {
                TraitsCommand.runDumpMdClient();
                break;
            }
            default: {
                SilentGear.LOGGER.error("Unknown ClientOutputCommandPacket.Type: {}", (Object)this.type);
            }
        }
        context.get().setPacketHandled(true);
    }

    public static enum Type {
        MATERIALS,
        TRAITS;

    }
}

