/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifier;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.gear.material.modifier.ChargedMaterialModifier;
import net.silentchaos512.gear.gear.material.modifier.GradeMaterialModifier;
import net.silentchaos512.gear.gear.material.modifier.StarchargedMaterialModifier;
import net.silentchaos512.gear.util.Const;

public class MaterialModifiers {
    private static final Map<ResourceLocation, IMaterialModifierType<?>> MODIFIERS = new LinkedHashMap();
    public static final GradeMaterialModifier.Type GRADE = new GradeMaterialModifier.Type();
    public static final ChargedMaterialModifier.Type<StarchargedMaterialModifier> STARCHARGED = new ChargedMaterialModifier.Type<StarchargedMaterialModifier>(StarchargedMaterialModifier::new, "SG_Starcharged");

    public static void registerType(ResourceLocation id, IMaterialModifierType<?> type) {
        if (MODIFIERS.containsKey(id)) {
            throw new IllegalArgumentException("Already have material modifier with ID " + id);
        }
        MODIFIERS.put(id, type);
        SilentGear.LOGGER.info("Registered material modifier {}", (Object)id);
    }

    @Nullable
    public static IMaterialModifierType<?> getType(ResourceLocation typeName) {
        return MODIFIERS.get(typeName);
    }

    public static Collection<IMaterialModifierType<?>> getTypes() {
        return MODIFIERS.values();
    }

    public static Collection<IMaterialModifier> readFromMaterial(IMaterialInstance material) {
        ArrayList<IMaterialModifier> ret = new ArrayList<IMaterialModifier>();
        for (IMaterialModifierType<?> type : MODIFIERS.values()) {
            Object modifier = type.read(material);
            if (modifier == null) continue;
            ret.add((IMaterialModifier)modifier);
        }
        return ret;
    }

    public static Collection<IMaterialModifier> readFromJson(JsonArray array) {
        ArrayList ret = Lists.newArrayList();
        for (JsonElement je : array) {
            JsonObject jo = je.getAsJsonObject();
            ResourceLocation typeName = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jo, (String)"type"));
            IMaterialModifierType<?> type = MaterialModifiers.getType(typeName);
            if (type == null) {
                throw new JsonSyntaxException("Unknown material modifier type: " + typeName);
            }
            ret.add(type.deserialize(jo));
        }
        return ret;
    }

    public static IMaterialModifier readFromNetwork(FriendlyByteBuf buf) {
        ResourceLocation typeName = buf.m_130281_();
        IMaterialModifierType<?> type = MaterialModifiers.getType(typeName);
        if (type == null) {
            throw new IllegalStateException("Unknown material modifier type: " + typeName);
        }
        return type.readFromNetwork(buf);
    }

    public static <T extends IMaterialModifier> void writeToNetwork(T modifier, FriendlyByteBuf buf) {
        IMaterialModifierType<?> type = modifier.getType();
        buf.m_130085_(type.getId());
        type.writeToNetwork(modifier, buf);
    }

    @Nullable
    public static IMaterialModifier readNbt(CompoundTag tag) {
        ResourceLocation id = ResourceLocation.m_135820_((String)tag.m_128461_("ID"));
        if (id == null) {
            return null;
        }
        IMaterialModifierType<?> type = MaterialModifiers.getType(id);
        if (type == null) {
            return null;
        }
        return type.read(tag);
    }

    @Nullable
    public static <T extends IMaterialModifier> CompoundTag writeNbt(T modifier) {
        IMaterialModifierType<?> type = modifier.getType();
        CompoundTag tag = new CompoundTag();
        type.write(modifier, tag);
        if (!tag.m_128456_()) {
            tag.m_128359_("ID", type.getId().toString());
            return tag;
        }
        return null;
    }

    public static <T extends IMaterialModifier> void writeToItem(T modifier, ItemStack stack) {
        IMaterialModifierType<?> type = modifier.getType();
        type.write(modifier, stack);
    }

    static {
        MaterialModifiers.registerType(Const.GRADE, GRADE);
        MaterialModifiers.registerType(Const.STARCHARGED, STARCHARGED);
    }
}

