/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.enchantment.IStatModifierEnchantment;
import net.silentchaos512.gear.api.event.GetMaterialStatsEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifier;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ChargedProperties;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.material.MaterialModifiers;
import net.silentchaos512.gear.gear.part.RepairContext;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.util.InventoryUtils;

public final class MaterialInstance
implements IMaterialInstance {
    private static final Map<ResourceLocation, MaterialInstance> QUICK_CACHE = new HashMap<ResourceLocation, MaterialInstance>();
    private final IMaterial material;
    @Deprecated
    private final MaterialGrade grade;
    private final ItemStack item;
    private ImmutableList<IMaterialModifier> modifiers = ImmutableList.of();

    private MaterialInstance(IMaterial material) {
        this(material, MaterialGrade.NONE, material.getDisplayItem(PartType.MAIN, 0));
    }

    private MaterialInstance(IMaterial material, MaterialGrade grade) {
        this(material, grade, material.getDisplayItem(PartType.MAIN, 0));
    }

    private MaterialInstance(IMaterial material, ItemStack craftingItem) {
        this(material, MaterialGrade.NONE, craftingItem);
    }

    private MaterialInstance(IMaterial material, MaterialGrade grade, ItemStack craftingItem) {
        this.material = material;
        this.grade = grade;
        this.item = craftingItem.m_41777_();
        if (!this.item.m_41619_()) {
            this.item.m_41764_(1);
        }
    }

    public static MaterialInstance of(IMaterial material) {
        return QUICK_CACHE.computeIfAbsent(material.getId(), id -> new MaterialInstance(material));
    }

    public static MaterialInstance of(IMaterial material, MaterialGrade grade) {
        return new MaterialInstance(material, grade);
    }

    public static MaterialInstance of(IMaterial material, ItemStack craftingItem) {
        return new MaterialInstance(material, MaterialGrade.fromStack(craftingItem), craftingItem);
    }

    public static MaterialInstance of(IMaterial material, MaterialGrade grade, ItemStack craftingItem) {
        return new MaterialInstance(material, grade, craftingItem);
    }

    public static IMaterialInstance of(DataResource<IMaterial> material, ItemStack craftingItem) {
        if (material.isPresent()) {
            return MaterialInstance.of(material.get(), craftingItem);
        }
        return LazyMaterialInstance.of(material, MaterialGrade.fromStack(craftingItem));
    }

    @Nullable
    public static MaterialInstance from(ItemStack stack) {
        IMaterial material = MaterialManager.from(stack);
        if (material != null) {
            return MaterialInstance.of(material, stack);
        }
        return null;
    }

    @Override
    public ResourceLocation getId() {
        return this.material.getId();
    }

    @Override
    @Nonnull
    public IMaterial get() {
        return this.material;
    }

    @Override
    public MaterialGrade getGrade() {
        return this.grade;
    }

    @Override
    public Collection<IMaterialModifier> getModifiers() {
        if (this.modifiers.isEmpty()) {
            this.modifiers = ImmutableList.copyOf(MaterialModifiers.readFromMaterial(this));
        }
        return this.modifiers;
    }

    @Override
    public MaterialList getMaterials() {
        return this.material.getMaterials(this);
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public Collection<IMaterialCategory> getCategories() {
        return this.material.getCategories(this);
    }

    @Override
    public Ingredient getIngredient() {
        return this.material.getIngredient();
    }

    @Override
    public int getTier(PartType partType) {
        return this.material.getTier(this, partType);
    }

    @Override
    public Collection<StatInstance> getStatModifiers(PartType partType, StatGearKey key, ItemStack gear) {
        List<StatInstance> mods = new ArrayList<StatInstance>(this.material.getStatModifiers(this, partType, key, gear));
        ItemStat stat = ItemStats.get(key.getStat());
        if (stat == null) {
            SilentGear.LOGGER.warn("Unknown item stat: {}", (Object)key.getStat().getStatId());
            SilentGear.LOGGER.catching((Throwable)new NullPointerException());
            return mods;
        }
        for (IMaterialModifier materialModifier : this.getModifiers()) {
            mods = materialModifier.modifyStats(this, partType, key, mods);
        }
        GetMaterialStatsEvent event = new GetMaterialStatsEvent(this, stat, partType, mods);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getModifiers();
    }

    @Deprecated
    private void getEnchantmentModifiedStats(List<StatInstance> mods, StatGearKey key) {
        if (key.getStat() == ItemStats.CHARGING_VALUE) {
            return;
        }
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)this.item).entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer level = (Integer)entry.getValue();
            if (!(enchantment instanceof IStatModifierEnchantment)) continue;
            IStatModifierEnchantment statModifierEnchantment = (IStatModifierEnchantment)enchantment;
            ChargedProperties charge = new ChargedProperties(level, this.getChargeability());
            for (int i = 0; i < mods.size(); ++i) {
                StatInstance mod = mods.get(i);
                StatInstance newMod = statModifierEnchantment.modifyStat(key, mod, charge);
                if (newMod == null) continue;
                mods.remove(i);
                mods.add(i, newMod);
            }
        }
    }

    private float getChargeability() {
        return this.getStat(PartType.MAIN, ItemStats.CHARGING_VALUE);
    }

    @Override
    public float getStat(PartType partType, StatGearKey key, ItemStack gear) {
        ItemStat stat = ItemStats.get(key.getStat());
        if (stat == null) {
            return key.getStat().getDefaultValue();
        }
        return stat.compute(stat.getDefaultValue(), this.getStatModifiers(partType, key));
    }

    @Override
    public Collection<TraitInstance> getTraits(PartGearKey partKey, ItemStack gear) {
        return this.material.getTraits(this, partKey, gear);
    }

    public boolean canRepair(ItemStack gear) {
        return this.material.allowedInPart(this, PartType.MAIN) && GearData.getTier(gear) <= this.getTier(PartType.MAIN);
    }

    public int getRepairValue(ItemStack gear) {
        return this.getRepairValue(gear, RepairContext.Type.QUICK);
    }

    public int getRepairValue(ItemStack gear, RepairContext.Type type) {
        if (this.canRepair(gear)) {
            float durability = this.getStat(PartType.MAIN, GearHelper.getDurabilityStat(gear));
            float repairValueMulti = this.getStat(PartType.MAIN, ItemStats.REPAIR_VALUE);
            float itemRepairModifier = GearHelper.getRepairModifier(gear);
            float typeBonus = 1.0f + type.getBonusEfficiency();
            return Math.round(durability * repairValueMulti * itemRepairModifier * typeBonus) + 1;
        }
        return 0;
    }

    @Nullable
    public static MaterialInstance read(CompoundTag nbt) {
        ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_128461_("ID"));
        IMaterial material = MaterialManager.get(id);
        if (material == null) {
            return null;
        }
        ItemStack stack = MaterialInstance.readOrGetDefaultItem(material, nbt);
        return MaterialInstance.of(material, stack);
    }

    private static ItemStack readOrGetDefaultItem(IMaterial material, CompoundTag nbt) {
        ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Item"));
        if (stack.m_41619_()) {
            ItemStack defaultItem = MaterialInstance.getDefaultItem(material);
            MaterialInstance.readModifiers(nbt, defaultItem);
            return defaultItem;
        }
        return stack;
    }

    private static void readModifiers(CompoundTag nbt, ItemStack defaultItem) {
        if (!nbt.m_128441_("Modifiers")) {
            return;
        }
        ListTag list = nbt.m_128437_("Modifiers", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag compoundTag = list.m_128728_(i);
            IMaterialModifier mod = MaterialModifiers.readNbt(compoundTag);
            if (mod == null) continue;
            MaterialModifiers.writeToItem(mod, defaultItem);
        }
    }

    private static ItemStack getDefaultItem(IMaterial material) {
        ItemStack[] array = material.getIngredient().m_43908_();
        if (array.length > 0) {
            return array[0].m_41777_();
        }
        return ItemStack.f_41583_;
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        nbt.m_128359_("ID", this.material.getId().toString());
        nbt.m_128365_("Item", (Tag)this.item.m_41739_(new CompoundTag()));
        return nbt;
    }

    public int getPrimaryColor(GearType gearType, PartType partType) {
        IMaterialDisplay model = this.getDisplayProperties();
        MaterialLayer layer = model.getLayerList(gearType, partType, (IMaterialInstance)this).getFirstLayer();
        if (layer != null) {
            return layer.getColor();
        }
        return 0xFFFFFF;
    }

    @Override
    public Component getDisplayName(PartType partType, ItemStack gear) {
        return this.material.getDisplayName(this, partType, gear);
    }

    @Override
    public IMaterialDisplay getDisplayProperties() {
        return this.material.getDisplayProperties(this);
    }

    @Override
    public String getModelKey() {
        return this.material.getModelKey(this);
    }

    @Override
    public int getNameColor(PartType partType, GearType gearType) {
        return this.material.getNameColor(this, partType, gearType);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.material.getId());
        buffer.m_130068_((Enum)this.grade);
    }

    @Nullable
    public static MaterialInstance readShorthand(String str) {
        if (str.contains("#")) {
            String[] parts = str.split("#");
            ResourceLocation id = SilentGear.getIdWithDefaultNamespace(parts[0]);
            IMaterial material = MaterialManager.get(id);
            if (material != null) {
                MaterialGrade grade = MaterialGrade.fromString(parts[1]);
                return new MaterialInstance(material, grade);
            }
            return null;
        }
        ResourceLocation id = SilentGear.getIdWithDefaultNamespace(str);
        IMaterial material = MaterialManager.get(id);
        if (material != null) {
            return new MaterialInstance(material);
        }
        return null;
    }

    @Deprecated
    public static String writeShorthand(IMaterialInstance material) {
        String id = SilentGear.shortenId(material.getId());
        if (material.getGrade() != MaterialGrade.NONE) {
            return id + "#" + material.getGrade();
        }
        return id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaterialInstance that = (MaterialInstance)o;
        return this.material.equals(that.material) && this.grade == that.grade && InventoryUtils.canItemsStack((ItemStack)this.item, (ItemStack)that.item);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.material, this.grade, this.item});
    }
}

