/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.IMaterialSerializer;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.SplitItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.client.material.DefaultMaterialDisplay;
import net.silentchaos512.gear.client.material.GearDisplayManager;
import net.silentchaos512.gear.client.material.MaterialDisplay;
import net.silentchaos512.gear.gear.material.MaterialCategories;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.material.MaterialModifiers;
import net.silentchaos512.gear.network.SyncMaterialCraftingItemsPacket;
import net.silentchaos512.gear.util.ModResourceLocation;
import net.silentchaos512.gear.util.TierHelper;
import net.silentchaos512.utils.Color;

public abstract class AbstractMaterial
implements IMaterial {
    protected final ResourceLocation materialId;
    @Nullable
    ResourceLocation parent;
    protected final String packName;
    protected final Collection<IMaterialCategory> categories = new ArrayList<IMaterialCategory>();
    protected boolean visible = true;
    protected boolean canSalvage = true;
    protected boolean simple = true;
    protected int tier = -1;
    protected Tier harvestTier = Tiers.IRON;
    protected Ingredient ingredient = Ingredient.f_43901_;
    protected final Map<PartType, Ingredient> partSubstitutes = new HashMap<PartType, Ingredient>();
    protected final Map<PartType, StatModifierMap> stats = new LinkedHashMap<PartType, StatModifierMap>();
    protected final Map<PartType, List<TraitInstance>> traits = new LinkedHashMap<PartType, List<TraitInstance>>();
    protected final List<String> blacklistedGearTypes = new ArrayList<String>();
    protected Component displayName;
    @Nullable
    protected Component namePrefix = null;
    protected IMaterialDisplay displayProperties = DefaultMaterialDisplay.INSTANCE;

    protected AbstractMaterial(ResourceLocation materialId, String packName) {
        this.materialId = materialId;
        this.packName = packName;
    }

    @Override
    public String getPackName() {
        return this.packName;
    }

    @Override
    public ResourceLocation getId() {
        return this.materialId;
    }

    @Override
    @Nullable
    public IMaterial getParent() {
        if (this.parent != null) {
            return MaterialManager.get(this.parent);
        }
        return null;
    }

    @Override
    public Collection<IMaterialCategory> getCategories(IMaterialInstance material) {
        if (this.categories.isEmpty() && this.getParent() != null) {
            return this.getParent().getCategories(material);
        }
        return new HashSet<IMaterialCategory>(this.categories);
    }

    @Override
    public int getTier(IMaterialInstance material, PartType partType) {
        if (this.tier < 0 && this.getParent() != null) {
            return this.getParent().getTier(material, partType);
        }
        return this.tier;
    }

    @Override
    public Tier getHarvestTier(IMaterialInstance material) {
        IMaterial parent;
        if (this.parent != null && (parent = this.getParent()) != null) {
            return TierHelper.getHigher(this.harvestTier, MaterialInstance.of(parent).getHarvestTier());
        }
        return this.harvestTier;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public Optional<Ingredient> getPartSubstitute(PartType partType) {
        return Optional.ofNullable(this.partSubstitutes.get(partType));
    }

    @Override
    public boolean hasPartSubstitutes() {
        return !this.partSubstitutes.isEmpty();
    }

    @Override
    public boolean canSalvage() {
        return this.canSalvage;
    }

    @Override
    public IMaterialInstance onSalvage(IMaterialInstance material) {
        return AbstractMaterial.removeEnhancements(material);
    }

    public static IMaterialInstance removeEnhancements(IMaterialInstance material) {
        ItemStack stack = material.getItem().m_41777_();
        for (IMaterialModifierType<?> modifierType : MaterialModifiers.getTypes()) {
            modifierType.removeModifier(stack);
        }
        EnchantmentHelper.m_44865_(Collections.emptyMap(), (ItemStack)stack);
        IMaterial iMaterial = (IMaterial)material.get();
        if (iMaterial != null) {
            return MaterialInstance.of(iMaterial, stack);
        }
        return material;
    }

    @Override
    public boolean isSimple() {
        return this.simple;
    }

    @Override
    public Set<PartType> getPartTypes(IMaterialInstance material) {
        return Sets.union(this.stats.keySet(), this.getParentOptional().map(m -> new LinkedHashSet<PartType>(m.getPartTypes(material))).orElse(Collections.emptySet()));
    }

    @Override
    public boolean allowedInPart(IMaterialInstance material, PartType partType) {
        return this.getPartTypes(material).contains(partType);
    }

    @Override
    public Collection<StatInstance> getStatModifiers(IMaterialInstance material, PartType partType, StatGearKey key, ItemStack gear) {
        ArrayList<StatInstance> ret = new ArrayList<StatInstance>(this.stats.getOrDefault(partType, StatModifierMap.EMPTY_STAT_MAP).get(key));
        if (ret.isEmpty() && this.getParent() != null) {
            ret.addAll(this.getParent().getStatModifiers(material, partType, key, gear));
        }
        return ret;
    }

    @Override
    public Collection<StatGearKey> getStatKeys(IMaterialInstance material, PartType type) {
        StatModifierMap map = this.stats.getOrDefault(type, StatModifierMap.EMPTY_STAT_MAP);
        if (map.isEmpty() && this.getParent() != null) {
            return this.getParent().getStatKeys(material, type);
        }
        return map.keySet();
    }

    @Override
    public Collection<TraitInstance> getTraits(IMaterialInstance material, PartGearKey partKey, ItemStack gear) {
        ArrayList<TraitInstance> ret = new ArrayList<TraitInstance>(this.traits.getOrDefault(partKey.getPartType(), Collections.emptyList()));
        if (ret.isEmpty() && this.getParent() != null) {
            ret.addAll(this.getParent().getTraits(material, partKey, gear));
        }
        return ret;
    }

    @Override
    public boolean isCraftingAllowed(IMaterialInstance material, PartType partType, GearType gearType, @Nullable Container inventory) {
        if (this.isGearTypeBlacklisted(gearType) || !this.allowedInPart(material, partType)) {
            return false;
        }
        if (this.stats.containsKey(partType) || this.getParent() != null && this.getParent().isCraftingAllowed(material, partType, gearType, inventory)) {
            if (partType == PartType.MAIN) {
                ItemStat stat = gearType.getDurabilityStat();
                StatGearKey key = StatGearKey.of(stat, gearType);
                return !this.getStatModifiers(material, partType, key).isEmpty() && this.getStatUnclamped(material, partType, key, ItemStack.f_41583_) > 0.0f;
            }
            return true;
        }
        return false;
    }

    private boolean isGearTypeBlacklisted(GearType gearType) {
        for (String s : this.blacklistedGearTypes) {
            if (!gearType.matches(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Component getDisplayName(@Nullable IMaterialInstance material, PartType type, ItemStack gear) {
        return this.displayName.m_6881_();
    }

    @Override
    @Nullable
    public Component getDisplayNamePrefix(ItemStack gear, PartType partType) {
        return this.namePrefix != null ? this.namePrefix.m_6881_() : null;
    }

    @Override
    public int getNameColor(IMaterialInstance material, PartType partType, GearType gearType) {
        IMaterialDisplay model = material.getDisplayProperties();
        int color = model.getLayerColor(gearType, partType, material, 0);
        return Color.blend((int)color, (int)0xFFFFFF, (float)0.25f) & 0xFFFFFF;
    }

    @Override
    public IMaterialDisplay getDisplayProperties(IMaterialInstance material) {
        IMaterialDisplay override = GearDisplayManager.get(material);
        if (override != null) {
            return override;
        }
        return this.displayProperties;
    }

    @Override
    public boolean isVisible(PartType partType) {
        return this.visible;
    }

    @Override
    public void updateIngredient(SyncMaterialCraftingItemsPacket msg) {
        if (msg.isValid()) {
            msg.getIngredient(this.materialId).ifPresent(ing -> {
                this.ingredient = ing;
            });
            this.partSubstitutes.clear();
            msg.getPartSubstitutes(this.materialId).forEach(this.partSubstitutes::put);
        }
    }

    public String toString() {
        return "AbstractMaterial{id=" + this.materialId + "}";
    }

    public static class Serializer<T extends AbstractMaterial>
    implements IMaterialSerializer<T> {
        static final int PACK_NAME_MAX_LENGTH = 32;
        private final ResourceLocation name;
        private final BiFunction<ResourceLocation, String, T> factory;

        public Serializer(ResourceLocation name, BiFunction<ResourceLocation, String, T> factory) {
            this.name = name;
            this.factory = factory;
        }

        @Override
        public T deserialize(ResourceLocation id, String packName, JsonObject json) {
            AbstractMaterial ret = (AbstractMaterial)this.factory.apply(id, packName);
            if (json.has("parent")) {
                ret.parent = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"parent"));
            }
            this.deserializeHarvestTier(json, ret);
            this.deserializeStats(json, ret);
            this.deserializeTraits(json, ret);
            this.deserializeCraftingItems(json, ret);
            this.deserializeNames(json, ret);
            this.deserializeDisplayProperties(json, ret);
            this.deserializeAvailability(json, ret);
            return (T)ret;
        }

        void deserializeHarvestTier(JsonObject json, T ret) {
            if (((AbstractMaterial)ret).parent != null && !json.has("harvest_tier")) {
                ((AbstractMaterial)ret).harvestTier = Tiers.WOOD;
                return;
            }
            if (!json.has("harvest_tier")) {
                this.hackyDeserializeHarvestTierFromOutdatedFile(json, ret);
                return;
            }
            String harvestTierStr = GsonHelper.m_13906_((JsonObject)json, (String)"harvest_tier");
            ResourceLocation harvestTierName = new ResourceLocation(harvestTierStr);
            Tier harvestTier = TierSortingRegistry.byName((ResourceLocation)harvestTierName);
            if (harvestTier == null) {
                throw new JsonSyntaxException("Unknown harvest tier: " + harvestTierName);
            }
            ((AbstractMaterial)ret).harvestTier = harvestTier;
        }

        @Deprecated
        void hackyDeserializeHarvestTierFromOutdatedFile(JsonObject json, T ret) {
            boolean tierAssigned = false;
            JsonElement elementStats = json.get("stats");
            if (elementStats != null && elementStats.isJsonObject()) {
                for (Map.Entry entry : elementStats.getAsJsonObject().entrySet()) {
                    ResourceLocation partTypeName = SilentGear.getIdWithDefaultNamespace((String)entry.getKey());
                    if (partTypeName == null) continue;
                    JsonObject statsList = ((JsonElement)entry.getValue()).getAsJsonObject();
                    if (statsList.has("harvest_level")) {
                        ((AbstractMaterial)ret).harvestTier = this.hackyGuessHarvestTier(statsList.get("harvest_level"));
                        tierAssigned = true;
                        break;
                    }
                    if (!statsList.has("silentgear:harvest_level")) continue;
                    ((AbstractMaterial)ret).harvestTier = this.hackyGuessHarvestTier(statsList.get("silentgear:harvest_level"));
                    tierAssigned = true;
                    break;
                }
            }
            if (!tierAssigned) {
                ((AbstractMaterial)ret).harvestTier = Tiers.WOOD;
            }
            SilentGear.LOGGER.warn("Material has no harvest tier, guessing it as \"{}\"", (Object)TierSortingRegistry.getName((Tier)((AbstractMaterial)ret).harvestTier));
        }

        @Deprecated
        Tier hackyGuessHarvestTier(JsonElement json) {
            StatInstance statInstance = StatInstance.read(StatGearKey.of(ItemStats.DURABILITY, GearType.ALL), json);
            int harvestLevel = Math.round(statInstance.getValue());
            return switch (harvestLevel) {
                case 0 -> Tiers.WOOD;
                case 1 -> Tiers.STONE;
                case 2 -> Tiers.IRON;
                case 3 -> Tiers.DIAMOND;
                default -> Tiers.NETHERITE;
            };
        }

        void deserializeStats(JsonObject json, T ret) {
            JsonElement elementStats = json.get("stats");
            if (elementStats != null && elementStats.isJsonObject()) {
                for (Map.Entry entry : elementStats.getAsJsonObject().entrySet()) {
                    ResourceLocation partTypeName = SilentGear.getIdWithDefaultNamespace((String)entry.getKey());
                    if (partTypeName == null) continue;
                    PartType partType = PartType.get(partTypeName);
                    StatModifierMap statMods = StatModifierMap.deserialize((JsonElement)entry.getValue());
                    ((AbstractMaterial)ret).stats.put(partType, statMods);
                }
            }
            this.sanitizeStats(ret);
        }

        private void sanitizeStats(T ret) {
            for (PartType partType : ((AbstractMaterial)ret).stats.keySet()) {
                StatModifierMap statMap = ((AbstractMaterial)ret).stats.get(partType);
                for (IItemStat iItemStat : ItemStats.allStatsOrdered()) {
                    if (!(iItemStat instanceof SplitItemStat)) continue;
                    Serializer.sanitizeSplitStat((SplitItemStat)iItemStat, statMap);
                }
            }
        }

        private static void sanitizeSplitStat(SplitItemStat stat, StatModifierMap statMap) {
            StatGearKey all = StatGearKey.of(stat, GearType.ALL);
            for (GearType type : stat.getSplitTypes()) {
                StatGearKey key = StatGearKey.of(stat, type);
                if (statMap.containsKey(key)) continue;
                Collection<StatInstance> mods = statMap.get(all);
                for (StatInstance mod : mods) {
                    statMap.put(key, Serializer.getSplitStatMod(stat, key, mod));
                }
            }
        }

        @Nonnull
        private static StatInstance getSplitStatMod(SplitItemStat stat, StatGearKey key, StatInstance mod) {
            if (mod.getOp() == StatInstance.Operation.AVG) {
                float value = stat.compute(stat.getBaseValue(), true, key.getGearType(), mod.getKey().getGearType(), Collections.singleton(mod));
                return StatInstance.of(value, mod.getOp(), key);
            }
            return StatInstance.of(mod.getValue(), mod.getOp(), key);
        }

        private void deserializeAvailability(JsonObject json, T ret) {
            ((AbstractMaterial)ret).simple = GsonHelper.m_13855_((JsonObject)json, (String)"simple", (boolean)true);
            JsonElement elementAvailability = json.get("availability");
            if (elementAvailability != null && elementAvailability.isJsonObject()) {
                JsonObject obj = elementAvailability.getAsJsonObject();
                this.deserializeCategories(obj.get("categories"), ret);
                ((AbstractMaterial)ret).tier = GsonHelper.m_13824_((JsonObject)obj, (String)"tier", (int)((AbstractMaterial)ret).tier);
                ((AbstractMaterial)ret).visible = GsonHelper.m_13855_((JsonObject)obj, (String)"visible", (boolean)((AbstractMaterial)ret).visible);
                ((AbstractMaterial)ret).canSalvage = GsonHelper.m_13855_((JsonObject)obj, (String)"can_salvage", (boolean)((AbstractMaterial)ret).canSalvage);
                JsonArray blacklist = GsonHelper.m_13832_((JsonObject)obj, (String)"gear_blacklist", null);
                if (blacklist != null) {
                    ((AbstractMaterial)ret).blacklistedGearTypes.clear();
                    blacklist.forEach(e -> ret.blacklistedGearTypes.add(e.getAsString()));
                } else if (((AbstractMaterial)ret).simple && ((AbstractMaterial)ret).parent == null) {
                    throw new JsonSyntaxException("Expected 'availability' to be an object");
                }
            }
        }

        private void deserializeCategories(@Nullable JsonElement json, T material) {
            if (json != null) {
                if (json.isJsonArray()) {
                    JsonArray array = json.getAsJsonArray();
                    for (JsonElement elem : array) {
                        ((AbstractMaterial)material).categories.add(MaterialCategories.get(elem.getAsString()));
                    }
                } else if (json.isJsonPrimitive()) {
                    ((AbstractMaterial)material).categories.add(MaterialCategories.get(json.getAsString()));
                } else {
                    throw new JsonSyntaxException("Expected 'categories' to be array or string");
                }
            }
        }

        private void deserializeTraits(JsonObject json, T ret) {
            JsonElement elementTraits = json.get("traits");
            if (elementTraits != null && elementTraits.isJsonObject()) {
                for (Map.Entry entry : elementTraits.getAsJsonObject().entrySet()) {
                    PartType partType = PartType.get(Objects.requireNonNull(SilentGear.getIdWithDefaultNamespace((String)entry.getKey())));
                    if (partType == null) continue;
                    ArrayList list = new ArrayList();
                    ((JsonElement)entry.getValue()).getAsJsonArray().forEach(e -> list.add(TraitInstance.deserialize(e.getAsJsonObject())));
                    ((AbstractMaterial)ret).traits.put(partType, list);
                }
            }
        }

        private void deserializeCraftingItems(JsonObject json, T ret) {
            JsonElement craftingItems = json.get("crafting_items");
            if (craftingItems != null && craftingItems.isJsonObject()) {
                JsonElement subs;
                JsonElement main = craftingItems.getAsJsonObject().get("main");
                if (main != null) {
                    ((AbstractMaterial)ret).ingredient = Ingredient.m_43917_((JsonElement)main);
                }
                if ((subs = craftingItems.getAsJsonObject().get("subs")) != null && subs.isJsonObject()) {
                    JsonObject jo = subs.getAsJsonObject();
                    HashMap map = new HashMap();
                    jo.entrySet().forEach(entry -> {
                        PartType partType = PartType.get(new ModResourceLocation((String)entry.getKey()));
                        Ingredient ingredient = Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue()));
                        map.put(partType, ingredient);
                    });
                    ((AbstractMaterial)ret).partSubstitutes.putAll(map);
                }
            } else {
                throw new JsonSyntaxException("Expected 'crafting_items' to be an object");
            }
        }

        private void deserializeNames(JsonObject json, T ret) {
            JsonElement elementName = json.get("name");
            if (elementName == null || !elementName.isJsonObject()) {
                throw new JsonSyntaxException("Expected 'name' element");
            }
            ((AbstractMaterial)ret).displayName = Serializer.deserializeText(elementName);
            JsonElement elementNamePrefix = json.get("name_prefix");
            if (elementNamePrefix != null) {
                ((AbstractMaterial)ret).namePrefix = Serializer.deserializeText(elementNamePrefix);
            }
        }

        private static Component deserializeText(JsonElement json) {
            return (Component)Objects.requireNonNull(Component.Serializer.m_130691_((JsonElement)json));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void deserializeDisplayProperties(JsonObject json, T ret) {
            JsonElement element = json.get("model");
            if (element != null) {
                if (!element.isJsonObject()) throw new JsonSyntaxException("Expected 'model' to be an object");
                ((AbstractMaterial)ret).displayProperties = MaterialDisplay.deserialize(this.name, element.getAsJsonObject());
                return;
            } else {
                SilentGear.LOGGER.warn("Material '{}' has no model in the data file. This may be an outdated data pack or mod.", (Object)((AbstractMaterial)ret).materialId);
            }
        }

        @Override
        public T read(ResourceLocation id, FriendlyByteBuf buffer) {
            AbstractMaterial material = (AbstractMaterial)this.factory.apply(id, buffer.m_130136_(32));
            this.readBasics(buffer, material);
            this.readCraftingItems(buffer, material);
            this.readDisplayProperties(buffer, material);
            this.readRestrictions(buffer, material);
            this.readStats(buffer, material);
            this.readTraits(buffer, material);
            return (T)material;
        }

        private void readBasics(FriendlyByteBuf buffer, T material) {
            if (buffer.readBoolean()) {
                ((AbstractMaterial)material).parent = buffer.m_130281_();
            }
            ((AbstractMaterial)material).harvestTier = TierSortingRegistry.byName((ResourceLocation)buffer.m_130281_());
            ((AbstractMaterial)material).tier = buffer.readByte();
            ((AbstractMaterial)material).visible = buffer.readBoolean();
            ((AbstractMaterial)material).canSalvage = buffer.readBoolean();
            ((AbstractMaterial)material).simple = buffer.readBoolean();
            ((AbstractMaterial)material).displayName = buffer.m_130238_();
            if (buffer.readBoolean()) {
                ((AbstractMaterial)material).namePrefix = buffer.m_130238_();
            }
        }

        private Ingredient tempReadIngredientFix(FriendlyByteBuf buffer) {
            if (buffer.readBoolean()) {
                buffer.m_130242_();
                return CraftingHelper.getIngredient((ResourceLocation)buffer.m_130281_(), (FriendlyByteBuf)buffer);
            }
            return Ingredient.m_43940_((FriendlyByteBuf)buffer);
        }

        private void tempWriteIngredientFix(FriendlyByteBuf buffer, Ingredient ingredient) {
            boolean custom = ingredient.getSerializer() != VanillaIngredientSerializer.INSTANCE;
            buffer.writeBoolean(custom);
            CraftingHelper.write((FriendlyByteBuf)buffer, (Ingredient)ingredient);
        }

        private void readCraftingItems(FriendlyByteBuf buffer, T material) {
            ((AbstractMaterial)material).ingredient = this.tempReadIngredientFix(buffer);
            int subCount = buffer.readByte();
            for (int i = 0; i < subCount; ++i) {
                PartType partType = PartType.get(buffer.m_130281_());
                Ingredient ingredient = this.tempReadIngredientFix(buffer);
                ((AbstractMaterial)material).partSubstitutes.put(partType, ingredient);
            }
        }

        private void readDisplayProperties(FriendlyByteBuf buf, T material) {
            if (buf.readBoolean()) {
                ((AbstractMaterial)material).displayProperties = MaterialDisplay.fromNetwork(((AbstractMaterial)material).materialId, buf);
            }
        }

        private void readRestrictions(FriendlyByteBuf buffer, T material) {
            int categoryCount = buffer.readByte();
            for (int i = 0; i < categoryCount; ++i) {
                ((AbstractMaterial)material).categories.add(MaterialCategories.get(buffer.m_130277_()));
            }
            ((AbstractMaterial)material).blacklistedGearTypes.clear();
            int blacklistSize = buffer.readByte();
            for (int i = 0; i < blacklistSize; ++i) {
                ((AbstractMaterial)material).blacklistedGearTypes.add(buffer.m_130277_());
            }
        }

        private void readStats(FriendlyByteBuf buffer, T material) {
            ((AbstractMaterial)material).stats.clear();
            int typeCount = buffer.readByte();
            for (int i = 0; i < typeCount; ++i) {
                PartType partType = PartType.get(buffer.m_130281_());
                int statCount = buffer.readByte();
                StatModifierMap map = new StatModifierMap();
                for (int j = 0; j < statCount; ++j) {
                    StatGearKey key = StatGearKey.read(buffer);
                    StatInstance mod = StatInstance.read(key, buffer);
                    map.put(key, mod);
                }
                ((AbstractMaterial)material).stats.put(partType, map);
            }
        }

        private void readTraits(FriendlyByteBuf buffer, T material) {
            ((AbstractMaterial)material).traits.clear();
            int typeCount = buffer.readByte();
            for (int i = 0; i < typeCount; ++i) {
                PartType partType = PartType.get(buffer.m_130281_());
                int traitCount = buffer.readByte();
                ArrayList<TraitInstance> list = new ArrayList<TraitInstance>();
                for (int j = 0; j < traitCount; ++j) {
                    list.add(TraitInstance.read(buffer));
                }
                ((AbstractMaterial)material).traits.put(partType, list);
            }
        }

        @Override
        public void write(FriendlyByteBuf buffer, T material) {
            buffer.m_130072_(((AbstractMaterial)material).packName.substring(0, Math.min(32, ((AbstractMaterial)material).packName.length())), 32);
            this.writeBasics(buffer, material);
            this.writeCraftingItems(buffer, material);
            this.writeDisplayProperties(buffer, material);
            this.writeRestrictions(buffer, material);
            this.writeStats(buffer, material);
            this.writeTraits(buffer, material);
        }

        private void writeBasics(FriendlyByteBuf buffer, T material) {
            buffer.writeBoolean(((AbstractMaterial)material).parent != null);
            if (((AbstractMaterial)material).parent != null) {
                buffer.m_130085_(((AbstractMaterial)material).parent);
            }
            buffer.m_130085_(TierSortingRegistry.getName((Tier)((AbstractMaterial)material).harvestTier));
            buffer.writeByte(((AbstractMaterial)material).tier);
            buffer.writeBoolean(((AbstractMaterial)material).visible);
            buffer.writeBoolean(((AbstractMaterial)material).canSalvage);
            buffer.writeBoolean(((AbstractMaterial)material).simple);
            buffer.m_130083_(((AbstractMaterial)material).displayName);
            buffer.writeBoolean(((AbstractMaterial)material).namePrefix != null);
            if (((AbstractMaterial)material).namePrefix != null) {
                buffer.m_130083_(((AbstractMaterial)material).namePrefix);
            }
        }

        private void writeCraftingItems(FriendlyByteBuf buffer, T material) {
            this.tempWriteIngredientFix(buffer, ((AbstractMaterial)material).ingredient);
            buffer.writeByte(((AbstractMaterial)material).partSubstitutes.size());
            ((AbstractMaterial)material).partSubstitutes.forEach((type, ing) -> {
                buffer.m_130085_(type.getName());
                this.tempWriteIngredientFix(buffer, (Ingredient)ing);
            });
        }

        private void writeDisplayProperties(FriendlyByteBuf buf, T material) {
            boolean canWrite = ((AbstractMaterial)material).displayProperties instanceof MaterialDisplay;
            buf.writeBoolean(canWrite);
            if (canWrite) {
                ((MaterialDisplay)((AbstractMaterial)material).displayProperties).toNetwork(buf);
            }
        }

        private void writeRestrictions(FriendlyByteBuf buffer, T material) {
            buffer.writeByte(((AbstractMaterial)material).categories.size());
            ((AbstractMaterial)material).categories.forEach(cat -> buffer.m_130070_(cat.getName()));
            buffer.writeByte(((AbstractMaterial)material).blacklistedGearTypes.size());
            ((AbstractMaterial)material).blacklistedGearTypes.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
        }

        private void writeStats(FriendlyByteBuf buffer, T material) {
            buffer.writeByte(((AbstractMaterial)material).stats.size());
            ((AbstractMaterial)material).stats.forEach((partType, map) -> {
                buffer.m_130085_(partType.getName());
                buffer.writeByte(map.size());
                map.forEach((key, mod) -> {
                    buffer.m_130070_(key.toString());
                    mod.write(buffer);
                });
            });
        }

        private void writeTraits(FriendlyByteBuf buffer, T material) {
            buffer.writeByte(((AbstractMaterial)material).traits.size());
            ((AbstractMaterial)material).traits.forEach((partType, list) -> {
                buffer.m_130085_(partType.getName());
                buffer.writeByte(list.size());
                list.forEach(trait -> trait.write(buffer));
            });
        }

        @Override
        public ResourceLocation getName() {
            return this.name;
        }
    }
}

