/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.PlayerUtils;

public final class StatsCommand {
    private StatsCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgear_stats").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"info").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> StatsCommand.runInfo((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91474_((CommandContext)ctx, (String)"player"))))).executes(ctx -> StatsCommand.runInfo((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(Commands.m_82127_((String)"lock").executes(StatsCommand::runLockStats))).then(Commands.m_82127_((String)"recalculate").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> StatsCommand.runRecalculate((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91477_((CommandContext)ctx, (String)"players"))))));
    }

    private static int runInfo(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        if (!GearHelper.isGear(stack)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)TextUtil.translate("command", "invalidItemType", stack.m_41786_()));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> TextUtil.translate("command", "stats.info.header", player.m_7755_(), stack.m_41786_()).m_130940_(ChatFormatting.BOLD), true);
        ICoreItem item = (ICoreItem)stack.m_41720_();
        PartDataList parts = GearData.getConstructionParts(stack);
        StatModifierMap stats = GearData.getStatModifiers(stack, item, parts);
        for (ItemStat stat : ItemStats.allStatsOrderedExcluding(item.getExcludedStats(stack))) {
            StatGearKey key = StatGearKey.of(stat, item.getGearType());
            Collection<StatInstance> mods = stats.get(key);
            if (mods.isEmpty()) continue;
            MutableComponent name = TextUtil.withColor(stat.getDisplayName(), stat.getNameColor());
            MutableComponent modsText = StatModifierMap.formatText(mods, stat, 5, true);
            float statValue = stat.compute(0.0f, true, item.getGearType(), mods);
            MutableComponent valueText = TextUtil.withColor(StatInstance.of(statValue, StatInstance.Operation.AVG, key).getFormattedText(stat, 5, false), ChatFormatting.YELLOW);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> StatsCommand.lambda$runInfo$5((Component)name, (Component)modsText, (Component)valueText), true);
            for (PartData part : parts) {
                Collection<StatInstance> partMods = part.getStatModifiers(key, stack);
                if (partMods.isEmpty()) continue;
                Component partName = part.getDisplayName(stack);
                MutableComponent partModsText = StatModifierMap.formatText(partMods, stat, 5, true);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> StatsCommand.lambda$runInfo$6(partName, (Component)partModsText), true);
            }
        }
        return 1;
    }

    private static int runLockStats(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer playerMP = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack stack = playerMP.m_21205_();
        if (GearHelper.isGear(stack)) {
            boolean locked = !GearData.hasLockedStats(stack);
            GearData.setLockedStats(stack, locked);
            String translationKey = "command.silentgear.lock_stats." + (locked ? "locked" : "unlocked");
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)translationKey, (Object[])new Object[]{stack.m_41786_()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.silentgear.lock_stats.invalid"));
        }
        return 1;
    }

    private static int runRecalculate(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            for (ItemStack stack : PlayerUtils.getNonEmptyStacks((Player)player)) {
                if (!GearHelper.isGear(stack)) continue;
                GearData.recalculateStats(stack, (Player)player);
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.silentgear.recalculate", (Object[])new Object[]{player.m_6302_()}), true);
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$runInfo$6(Component partName, Component partModsText) {
        return TextUtil.translate("command", "stats.info.formatPart", partName, partModsText);
    }

    private static /* synthetic */ Component lambda$runInfo$5(Component name, Component modsText, Component valueText) {
        return TextUtil.translate("command", "stats.info.format", name, modsText, valueText);
    }
}

