/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.util.IGearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.gear.trait.TraitSerializers;
import net.silentchaos512.gear.util.TextUtil;

public interface ITraitInstance {
    public ResourceLocation getTraitId();

    @Nullable
    public ITrait getTrait();

    public int getLevel();

    public Collection<ITraitCondition> getConditions();

    default public boolean conditionsMatch(PartGearKey key, ItemStack gear, List<? extends IGearComponentInstance<?>> components) {
        ITrait trait = this.getTrait();
        if (trait == null) {
            return true;
        }
        for (ITraitCondition condition : this.getConditions()) {
            if (condition.matches(trait, key, gear, components)) continue;
            return false;
        }
        return true;
    }

    default public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getTraitId().toString());
        json.addProperty("level", (Number)this.getLevel());
        Collection<ITraitCondition> conditions = this.getConditions();
        if (!conditions.isEmpty()) {
            JsonArray array = new JsonArray();
            for (ITraitCondition condition : conditions) {
                array.add((JsonElement)TraitSerializers.serializeCondition(condition));
            }
            json.add("conditions", (JsonElement)array);
        }
        return json;
    }

    default public MutableComponent getConditionsText() {
        return this.getConditions().stream().map(ITraitCondition::getDisplayText).reduce((t1, t2) -> t1.m_7220_((Component)TextUtil.translate("trait.condition", "and")).m_7220_((Component)t2)).orElseGet(() -> Component.m_237113_((String)""));
    }
}

