/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.recipe;

import cofh.lib.common.fluid.FluidIngredient;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrthomas20121.thermal_extra.ThermalExtra;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeSerializers;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class ColdFuel
extends ThermalFuel {
    public ColdFuel(ResourceLocation recipeId, int energy, @Nullable List<Ingredient> inputItems, @Nullable List<FluidIngredient> inputFluids) {
        super(recipeId, energy, inputItems, inputFluids);
        int minEnergy = 1000;
        int maxEnergy = 20000000;
        if (this.energy < minEnergy || this.energy > maxEnergy) {
            ThermalExtra.LOGGER.warn("Energy value for " + recipeId + " was out of allowable range and has been clamped between + " + minEnergy + " and " + maxEnergy + ".");
            this.energy = MathHelper.clamp((int)this.energy, (int)minEnergy, (int)maxEnergy);
        }
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ThermalExtraRecipeSerializers.COLD_FUEL_SERIALIZER.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ThermalExtraRecipeTypes.COLD_FUEL.get();
    }
}

