/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.block.entity;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.lib.client.sounds.ConditionalSoundInstance;
import cofh.lib.common.fluid.FluidStorageCoFH;
import cofh.lib.common.inventory.ItemStorageCoFH;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.core.init.registries.TCoreSounds;
import cofh.thermal.lib.common.block.entity.DeviceBlockEntity;
import cofh.thermal.lib.util.ThermalAugmentRules;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrthomas20121.thermal_extra.init.ThermalExtraBlockEntities;
import mrthomas20121.thermal_extra.inventory.device.DeviceLavaGenMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DeviceLavaGenBlockEntity
extends DeviceBlockEntity
implements ITickableTile.IServerTickable {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "Fluid", "Filter"});
    protected static final int GENERATION_RATE = 10;
    protected static final int GENERATION_RATE_NETHER = 40;
    protected static final Supplier<FluidStack> LAVA = () -> new FluidStack((Fluid)Fluids.f_76195_, 0);
    protected ItemStorageCoFH fillSlot = new ItemStorageCoFH(1, FluidHelper::hasFluidHandlerCap);
    protected FluidStorageCoFH tank = new FluidStorageCoFH(4000, e -> false).setEmptyFluid(LAVA).setEnabled(() -> this.isActive);
    protected boolean cached;
    protected boolean valid;

    public DeviceLavaGenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ThermalExtraBlockEntities.LAVA_GEN.get(), pos, state);
        this.inventory.addSlot(this.fillSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.tank, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalCoreConfig.deviceAugments);
        this.initHandlers();
        this.renderFluid = new FluidStack((Fluid)Fluids.f_76195_, 1000);
    }

    protected void updateValidity() {
        BlockPos[] cardinals;
        if (this.f_58857_ == null || !this.f_58857_.isAreaLoaded(this.f_58858_, 1)) {
            return;
        }
        int adjLavaSource = 0;
        this.valid = false;
        for (BlockPos adj : cardinals = new BlockPos[]{this.f_58858_.m_122012_(), this.f_58858_.m_122019_(), this.f_58858_.m_122024_(), this.f_58858_.m_122029_()}) {
            FluidState state = this.f_58857_.m_6425_(adj);
            if (!state.m_76152_().equals(Fluids.f_76195_)) continue;
            ++adjLavaSource;
        }
        if (adjLavaSource > 1) {
            this.valid = true;
        } else {
            this.tank.clear();
        }
        this.cached = true;
    }

    protected void updateActiveState() {
        if (!this.cached) {
            this.updateValidity();
        }
        boolean curActive = this.isActive;
        this.isActive = this.redstoneControl.getState() && this.isValid();
        this.updateActiveState(curActive);
    }

    protected boolean isValid() {
        return this.valid;
    }

    protected void fillFluid() {
        if (!this.fillSlot.isEmpty()) {
            this.fillSlot.getItemStack().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).ifPresent(c -> {
                this.tank.drain(c.fill(new FluidStack(this.tank.getFluidStack(), (int)(1000.0f * this.baseMod)), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                this.fillSlot.setItemStack(c.getContainer());
            });
        }
    }

    public void tickServer() {
        this.updateActiveState();
        if (this.isActive) {
            int rate = 10;
            if (this.f_58857_ != null && this.f_58857_.m_220362_().equals(BuiltinDimensionTypes.f_223539_)) {
                rate = 40;
            }
            this.tank.modify((int)((float)rate * this.baseMod));
            this.fillFluid();
        }
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DeviceLavaGenMenu(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    protected Object getSound() {
        return new ConditionalSoundInstance((SoundEvent)TCoreSounds.SOUND_DEVICE_WATER_GEN.get(), SoundSource.AMBIENT, (BlockEntity)this, () -> !this.f_58859_ && this.isActive);
    }

    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }
}

