/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.inventory.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.inventory.client.GuiMGUButton;
import mob_grinding_utils.inventory.client.MGUScreen;
import mob_grinding_utils.inventory.server.ContainerXPSolidifier;
import mob_grinding_utils.network.MessageSolidifier;
import mob_grinding_utils.tile.TileEntityXPSolidifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;

public class GuiXPSolidifier
extends MGUScreen<ContainerXPSolidifier> {
    protected final ContainerXPSolidifier container;
    private final TileEntityXPSolidifier tile;

    public GuiXPSolidifier(ContainerXPSolidifier screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn, new ResourceLocation("mob_grinding_utils:textures/gui/solidifier_gui.png"));
        this.container = screenContainer;
        this.tile = this.container.tile;
        this.f_97727_ = 186;
        this.f_97726_ = 176;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 62, this.f_97736_ + 72, GuiMGUButton.Size.SOLIDIFIER, 0, (Component)Component.m_237113_((String)"Push"), button -> MobGrindingUtils.NETWORK_WRAPPER.sendToServer((Object)new MessageSolidifier(0, this.tile.m_58899_()))));
        this.m_142416_((GuiEventListener)new GuiMGUButton(this.f_97735_ + 148, this.f_97736_ + 8, GuiMGUButton.Size.SOLIDIFIER_ON, 0, (Component)Component.m_237113_((String)""), button -> MobGrindingUtils.NETWORK_WRAPPER.sendToServer((Object)new MessageSolidifier(1, this.tile.m_58899_()))));
    }

    @Override
    protected void m_280003_(@Nonnull GuiGraphics gg, int x, int y) {
        gg.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"block.mob_grinding_utils.xpsolidifier"), 7, 6, 0x404040, false);
        gg.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"container.inventory"), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        gg.drawString(this.f_96547_, this.tile.isOn ? "On" : "Off", 158.0f - (float)this.f_96547_.m_92895_(this.tile.isOn ? "On" : "Off") / 2.0f, 12.0f, 0xE0E0E0, true);
    }

    @Override
    protected void m_7286_(@Nonnull GuiGraphics gg, float partialTicks, int mouseX, int mouseY) {
        boolean zLevel = false;
        gg.m_280218_(this.TEX, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        gg.drawString(this.f_96547_, this.tile.outputDirection.m_7912_(), (float)(this.f_97735_ + 124) - (float)this.f_96547_.m_92895_(this.tile.outputDirection.m_7912_()) / 2.0f, (float)(this.f_97736_ + 76), 5285857, false);
        int fluid = this.tile.getScaledFluid(70);
        IClientFluidTypeExtensions fluidExtensions = IClientFluidTypeExtensions.of((Fluid)this.tile.tank.getFluid().getFluid());
        if (fluid >= 1) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidExtensions.getStillTexture());
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buffer = tessellator.m_85915_();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buffer.m_5483_((double)(this.f_97735_ + 8), (double)(this.f_97736_ + 88), (double)zLevel).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
            buffer.m_5483_((double)(this.f_97735_ + 20), (double)(this.f_97736_ + 88), (double)zLevel).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
            buffer.m_5483_((double)(this.f_97735_ + 20), (double)(this.f_97736_ + 88 - fluid), (double)zLevel).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
            buffer.m_5483_((double)(this.f_97735_ + 8), (double)(this.f_97736_ + 88 - fluid), (double)zLevel).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
            tessellator.m_85914_();
        }
        gg.m_280218_(this.TEX, this.f_97735_ + 7, this.f_97736_ + 17, 178, 0, 6, 71);
        gg.m_280218_(this.TEX, this.f_97735_ + 91, this.f_97736_ + 36, 178, 73, this.tile.getProgressScaled(24), 17);
    }

    protected void m_280072_(@Nonnull GuiGraphics gg, int x, int y) {
        super.m_280072_(gg, x, y);
        int xOffSet = (this.f_96543_ - this.f_97726_) / 2;
        int yOffSet = (this.f_96544_ - this.f_97727_) / 2;
        if (x > xOffSet + 8 && x < xOffSet + 20 && y > yOffSet + 20 && y < yOffSet + 88) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(this.tile.tank.getFluid().getDisplayName());
            tooltip.add(Component.m_237113_((String)(this.tile.tank.getFluidAmount() + "/" + this.tile.tank.getCapacity())));
            gg.m_280666_(this.f_96547_, tooltip, x, y);
        }
    }
}

