/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils.memoization;

import com.gregtechceu.gtceu.utils.memoization.ConcurrentWeakIdentityHashMap;
import com.gregtechceu.gtceu.utils.memoization.MemoizedBlockSupplier;
import com.gregtechceu.gtceu.utils.memoization.MemoizedSupplier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.tuple.Triple;

public class GTMemoizer {
    public static <T> MemoizedSupplier<T> memoize(Supplier<T> delegate) {
        return new MemoizedSupplier<T>(delegate);
    }

    public static <T extends Block> MemoizedBlockSupplier<T> memoizeBlockSupplier(Supplier<T> delegate) {
        return new MemoizedBlockSupplier<T>(delegate);
    }

    public static <T, R> Function<T, R> memoizeFunctionWeakIdent(final Function<T, R> memoFunction) {
        return new Function<T, R>(){
            private final Map<T, R> cache = new ConcurrentWeakIdentityHashMap();

            @Override
            public R apply(T key) {
                return this.cache.computeIfAbsent(key, memoFunction);
            }

            public String toString() {
                return "memoizeFunctionWeakIdent/1[function=" + String.valueOf(memoFunction) + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T, U, V, R> TriFunction<T, U, V, R> memoize(final TriFunction<T, U, V, R> memoTriFunction) {
        return new TriFunction<T, U, V, R>(){
            private final Map<Triple<T, U, V>, R> cache = new ConcurrentHashMap();

            public R apply(T key1, U key2, V key3) {
                return this.cache.computeIfAbsent(Triple.of(key1, key2, key3), cacheKey -> memoTriFunction.apply(cacheKey.getLeft(), cacheKey.getMiddle(), cacheKey.getRight()));
            }

            public String toString() {
                return "memoize/3[function=" + String.valueOf(memoTriFunction) + ", size=" + this.cache.size() + "]";
            }
        };
    }
}

