/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class EntityDamageUtil {
    public static void applyTemperatureDamage(@NotNull LivingEntity entity, int temperature, float multiplier, int maximum) {
        if (temperature > 320) {
            int damage = (int)(multiplier * (float)(temperature - 300) / 50.0f);
            if (maximum > 0) {
                damage = Math.min(maximum, damage);
            }
            EntityDamageUtil.applyHeatDamage(entity, damage);
        } else if (temperature < 260) {
            int damage = (int)(multiplier * (float)(273 - temperature) / 25.0f);
            if (maximum > 0) {
                damage = Math.min(maximum, damage);
            }
            EntityDamageUtil.applyFrostDamage(entity, damage);
        }
    }

    public static void applyHeatDamage(@NotNull LivingEntity entity, int damage) {
        if (damage <= 0) {
            return;
        }
        if (!entity.m_6084_()) {
            return;
        }
        if (entity.m_6095_().m_204039_(CustomTags.HEAT_IMMUNE)) {
            return;
        }
        if (entity.m_21124_(MobEffects.f_19607_) != null) {
            return;
        }
        entity.m_6469_(GTDamageTypes.HEAT.source((LevelAccessor)entity.m_9236_()), (float)damage);
    }

    public static void applyFrostDamage(@NotNull LivingEntity entity, int damage) {
        if (damage <= 0) {
            return;
        }
        if (!entity.m_6084_()) {
            return;
        }
        if (entity.m_6095_().m_204039_(EntityTypeTags.f_144294_)) {
            return;
        }
        ItemStack stack = entity.m_6844_(EquipmentSlot.FEET);
        if (!stack.m_41619_() && stack.getEnchantmentLevel(Enchantments.f_44974_) > 0) {
            stack.m_41622_(1, entity, ent -> ent.m_21166_(EquipmentSlot.FEET));
            return;
        }
        entity.m_6469_(entity.m_269291_().m_269109_(), (float)damage);
    }

    public static void applyChemicalDamage(@NotNull LivingEntity entity, int damage) {
        if (damage <= 0) {
            return;
        }
        if (!entity.m_6084_()) {
            return;
        }
        if (entity.m_6095_().m_204039_(CustomTags.CHEMICAL_IMMUNE)) {
            return;
        }
        entity.m_6469_(GTDamageTypes.CHEMICAL.source((LevelAccessor)entity.m_9236_()), (float)damage);
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, damage * 100, 1));
    }
}

