/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IEnergyInfoProvider;
import com.gregtechceu.gtceu.integration.top.element.ProgressElement;
import com.gregtechceu.gtceu.integration.top.provider.CapabilityInfoProvider;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElectricContainerInfoProvider
extends CapabilityInfoProvider<IEnergyInfoProvider> {
    public ResourceLocation getID() {
        return GTCEu.id("energy_container_provider");
    }

    @Override
    @Nullable
    protected IEnergyInfoProvider getCapability(Level level, BlockPos pos, @Nullable Direction side) {
        return GTCapabilityHelper.getEnergyInfoProvider(level, pos, side);
    }

    @Override
    protected void addProbeInfo(IEnergyInfoProvider capability, IProbeInfo probeInfo, Player player, BlockEntity blockEntity, IProbeHitData data) {
        IEnergyInfoProvider.EnergyInfo energyInfo = capability.getEnergyInfo();
        if (energyInfo.capacity().compareTo(BigInteger.ZERO) <= 0) {
            return;
        }
        BigInteger threshold = BigInteger.valueOf(1000000000000L);
        String energyStr = FormattingUtil.formatNumberOrSic(energyInfo.stored(), threshold);
        String maxEnergyStr = FormattingUtil.formatNumberOrSic(energyInfo.capacity(), threshold);
        float progress = this.getProgress(energyInfo.stored(), energyInfo.capacity());
        probeInfo.element((IElement)new ProgressElement(progress, (Component)Component.m_237110_((String)"gtceu.jade.energy_stored", (Object[])new Object[]{energyStr, maxEnergyStr}), probeInfo.defaultProgressStyle().filledColor(-1120768).alternateFilledColor(-1120768).borderColor(-11184811)));
    }

    protected float getProgress(long progress, long maxProgress) {
        return maxProgress == 0L ? 0.0f : (float)((double)progress / (double)maxProgress);
    }

    protected float getProgress(BigInteger progress, BigInteger maxProgress) {
        if (maxProgress.compareTo(BigInteger.ZERO) <= 0) {
            return 0.0f;
        }
        return new BigDecimal(progress).divide(new BigDecimal(maxProgress), MathContext.DECIMAL32).floatValue();
    }

    @Override
    protected boolean allowDisplaying(@NotNull IEnergyInfoProvider capability) {
        return !capability.isOneProbeHidden();
    }
}

