/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.journeymap;

import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.map.ButtonState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import journeymap.client.api.display.CustomToolBarBuilder;
import journeymap.client.api.display.IThemeButton;
import journeymap.client.api.display.IThemeToolBar;
import journeymap.client.api.display.ThemeButtonDisplay;
import journeymap.client.api.event.forge.FullscreenDisplayEvent;
import journeymap.client.io.ThemeLoader;
import journeymap.client.ui.theme.Theme;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;

public class JourneymapEventListener {
    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(JourneymapEventListener::onFullscreenAddonButton);
        bus.addListener(JourneymapEventListener::onFullscreenToolbarEvent);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static void onFullscreenAddonButton(FullscreenDisplayEvent.AddonButtonDisplayEvent event) {
        if (!ConfigHolder.INSTANCE.compat.minimap.toggle.journeyMapIntegration) {
            return;
        }
        if (ConfigHolder.INSTANCE.compat.minimap.direction != ConfigHolder.CompatibilityConfigs.MinimapCompatConfig.Direction.VERTICAL) {
            return;
        }
        ThemeButtonDisplay display = event.getThemeButtonDisplay();
        ArrayList<IThemeButton> buttons = new ArrayList<IThemeButton>(ButtonState.getAllButtons().size());
        for (ButtonState.Button state : ButtonState.getAllButtons()) {
            buttons.add(display.addThemeToggleButton("gtceu.button." + state.name, state.name, state.enabled, b -> {
                ButtonState.toggleButton(state);
                buttons.stream().filter(btn -> btn.getToggled() != false || btn == b).forEach(IThemeButton::toggle);
            }));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static void onFullscreenToolbarEvent(FullscreenDisplayEvent.CustomToolbarEvent event) {
        if (!ConfigHolder.INSTANCE.compat.minimap.toggle.journeyMapIntegration) {
            return;
        }
        if (ConfigHolder.INSTANCE.compat.minimap.direction == ConfigHolder.CompatibilityConfigs.MinimapCompatConfig.Direction.VERTICAL) {
            return;
        }
        CustomToolBarBuilder builder = event.getCustomToolBarBuilder();
        List<ButtonState.Button> allButtons = ButtonState.getAllButtons();
        IThemeButton[] buttons = new IThemeButton[allButtons.size()];
        for (int i = 0; i < allButtons.size(); ++i) {
            ButtonState.Button state = allButtons.get(i);
            buttons[i] = builder.getThemeToggleButton("gtceu.button." + state.name, state.name, b -> {
                ButtonState.toggleButton(state);
                Arrays.stream(buttons).filter(btn -> btn.getToggled() != false || btn == b).forEach(IThemeButton::toggle);
            });
            buttons[i].setToggled(Boolean.valueOf(state.enabled));
        }
        IThemeToolBar toolbar = builder.getNewToolbar(buttons);
        Theme theme = ThemeLoader.getCurrentTheme();
        Screen screen = event.getFullscreen().getScreen();
        Theme.Container.Toolbar toolbarTheme = theme.container.toolbar;
        Theme.Container.Toolbar.ToolbarSpec toolbarSpec = toolbarTheme.horizontal;
        int margin = toolbarSpec.margin;
        int padding = toolbarSpec.padding;
        int height = toolbarSpec.inner.height;
        toolbar.setLayoutHorizontal(margin, screen.f_96544_ - (height + margin), padding, true);
    }
}

