/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IParallelHatch;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class ParallelProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        int parallel;
        if (blockAccessor.getServerData().m_128441_("parallel") && (parallel = blockAccessor.getServerData().m_128451_("parallel")) > 1) {
            MutableComponent parallels = Component.m_237113_((String)FormattingUtil.formatNumbers(parallel)).m_130940_(ChatFormatting.DARK_PURPLE);
            Object key = "gtceu.multiblock.parallel";
            if (blockAccessor.getServerData().m_128471_("exact")) {
                key = (String)key + ".exact";
            }
            iTooltip.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{parallels}));
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof MetaMachineBlockEntity) {
            MetaMachineBlockEntity blockEntity2 = (MetaMachineBlockEntity)blockEntity;
            MetaMachine metaMachine = blockEntity2.getMetaMachine();
            if (metaMachine instanceof IParallelHatch) {
                IParallelHatch parallelHatch2 = (IParallelHatch)((Object)metaMachine);
                compoundTag.m_128405_("parallel", parallelHatch2.getCurrentParallel());
            } else {
                metaMachine = blockEntity2.getMetaMachine();
                if (metaMachine instanceof IMultiController) {
                    IRecipeLogicMachine rlm;
                    IMultiController controller = (IMultiController)((Object)metaMachine);
                    if (controller instanceof IRecipeLogicMachine && (rlm = (IRecipeLogicMachine)((Object)controller)).getRecipeLogic().isActive() && rlm.getRecipeLogic().getLastRecipe() != null) {
                        compoundTag.m_128405_("parallel", rlm.getRecipeLogic().getLastRecipe().parallels);
                        compoundTag.m_128379_("exact", true);
                    } else {
                        controller.getParallelHatch().ifPresent(parallelHatch -> compoundTag.m_128405_("parallel", parallelHatch.getCurrentParallel()));
                    }
                }
            }
        }
    }

    public ResourceLocation getUid() {
        return GTCEu.id("parallel_info");
    }
}

