/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.gui.widget.list;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.list.AEFluidDisplayWidget;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.list.AEItemDisplayWidget;
import com.gregtechceu.gtceu.integration.ae2.utils.KeyStorage;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AEListGridWidget
extends DraggableScrollableWidgetGroup {
    protected final KeyStorage list;
    private final int slotAmountY;
    private int slotRowsAmount;
    protected static final int ROW_CHANGE_ID = 2;
    protected static final int CONTENT_CHANGE_ID = 3;
    protected final Object2LongMap<AEKey> changeMap = new Object2LongOpenHashMap();
    protected final KeyStorage cached = new KeyStorage();
    protected final List<GenericStack> displayList = new ArrayList<GenericStack>();

    public AEListGridWidget(int x, int y, int slotsY, KeyStorage internalList) {
        super(x, y, 158, slotsY * 18);
        this.list = internalList;
        this.slotAmountY = slotsY;
    }

    public GenericStack getAt(int index) {
        return index >= 0 && index < this.displayList.size() ? this.displayList.get(index) : null;
    }

    private void addSlotRows(int amount) {
        for (int i = 0; i < amount; ++i) {
            int widgetAmount = this.widgets.size();
            Widget widget = this.createDisplayWidget(0, i * 18, widgetAmount);
            this.addWidget(widget);
        }
    }

    private void removeSlotRows(int amount) {
        for (int i = 0; i < amount; ++i) {
            Widget slotWidget = (Widget)this.widgets.remove(this.widgets.size() - 1);
            this.removeWidget(slotWidget);
        }
    }

    private void modifySlotRows(int delta) {
        if (delta > 0) {
            this.addSlotRows(delta);
        } else {
            this.removeSlotRows(delta);
        }
    }

    protected void writeListChange(FriendlyByteBuf buffer) {
        this.changeMap.clear();
        ObjectIterator cachedIt = this.cached.storage.object2LongEntrySet().iterator();
        while (cachedIt.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)cachedIt.next();
            AEKey cachedKey = (AEKey)entry.getKey();
            if (this.list.storage.containsKey((Object)cachedKey)) continue;
            this.changeMap.put((Object)cachedKey, -entry.getLongValue());
            cachedIt.remove();
        }
        for (Object2LongMap.Entry entry : this.list.storage.object2LongEntrySet()) {
            AEKey key = (AEKey)entry.getKey();
            long value = entry.getLongValue();
            long cacheValue = this.cached.storage.getOrDefault((Object)key, 0L);
            if (cacheValue == 0L) {
                this.changeMap.put((Object)key, value);
                this.cached.storage.put((Object)key, value);
                continue;
            }
            if (cacheValue == value) continue;
            this.changeMap.put((Object)key, value - cacheValue);
            this.cached.storage.put((Object)key, value);
        }
        buffer.m_130130_(this.changeMap.size());
        for (Object2LongMap.Entry entry : this.changeMap.object2LongEntrySet()) {
            ((AEKey)entry.getKey()).writeToPacket(buffer);
            buffer.m_130103_(entry.getLongValue());
        }
    }

    protected void readListChange(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            AEKey key = this.fromPacket(buffer);
            long delta = buffer.m_130258_();
            boolean found = false;
            ListIterator<GenericStack> li = this.displayList.listIterator();
            while (li.hasNext()) {
                GenericStack stack = li.next();
                if (!stack.what().equals(key)) continue;
                long newAmount = stack.amount() + delta;
                if (newAmount > 0L) {
                    li.set(new GenericStack(key, newAmount));
                } else {
                    li.remove();
                }
                found = true;
                break;
            }
            if (found) continue;
            this.displayList.add(new GenericStack(key, delta));
        }
    }

    protected abstract void toPacket(FriendlyByteBuf var1, AEKey var2);

    protected abstract AEKey fromPacket(FriendlyByteBuf var1);

    protected abstract Widget createDisplayWidget(int var1, int var2, int var3);

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.list == null) {
            return;
        }
        int slotRowsRequired = Math.max(this.slotAmountY, this.list.storage.size());
        if (this.slotRowsAmount != slotRowsRequired) {
            int slotsToAdd = slotRowsRequired - this.slotRowsAmount;
            this.slotRowsAmount = slotRowsRequired;
            this.writeUpdateInfo(2, buf -> buf.m_130130_(slotsToAdd));
            this.modifySlotRows(slotsToAdd);
        }
        this.writeUpdateInfo(3, this::writeListChange);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 2) {
            int slotsToAdd = buffer.m_130242_();
            this.modifySlotRows(slotsToAdd);
        }
        if (id == 3) {
            this.readListChange(buffer);
        }
    }

    public void writeInitialData(FriendlyByteBuf buffer) {
        super.writeInitialData(buffer);
        if (this.list == null) {
            return;
        }
        int slotRowsRequired = Math.max(this.slotAmountY, this.list.storage.size());
        int slotsToAdd = slotRowsRequired - this.slotRowsAmount;
        this.slotRowsAmount = slotRowsRequired;
        this.modifySlotRows(slotsToAdd);
        buffer.m_130130_(slotsToAdd);
        this.writeListChange(buffer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readInitialData(FriendlyByteBuf buffer) {
        super.readInitialData(buffer);
        if (this.list == null) {
            return;
        }
        this.modifySlotRows(buffer.m_130242_());
        this.readListChange(buffer);
    }

    public static class Fluid
    extends AEListGridWidget {
        public Fluid(int x, int y, int slotsY, KeyStorage internalList) {
            super(x, y, slotsY, internalList);
        }

        @Override
        protected void toPacket(FriendlyByteBuf buffer, AEKey key) {
            key.writeToPacket(buffer);
        }

        @Override
        protected AEKey fromPacket(FriendlyByteBuf buffer) {
            return AEFluidKey.fromPacket((FriendlyByteBuf)buffer);
        }

        @Override
        protected Widget createDisplayWidget(int x, int y, int index) {
            return new AEFluidDisplayWidget(x, y, this, index);
        }
    }

    public static class Item
    extends AEListGridWidget {
        public Item(int x, int y, int slotsY, KeyStorage internalList) {
            super(x, y, slotsY, internalList);
        }

        @Override
        protected void toPacket(FriendlyByteBuf buffer, AEKey key) {
            key.writeToPacket(buffer);
        }

        @Override
        protected AEKey fromPacket(FriendlyByteBuf buffer) {
            return AEItemKey.fromPacket((FriendlyByteBuf)buffer);
        }

        @Override
        protected Widget createDisplayWidget(int x, int y, int index) {
            return new AEItemDisplayWidget(x, y, this, index);
        }
    }
}

