/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins.client;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.MaterialBlock;
import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamMachine;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.common.blockentity.CableBlockEntity;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.List;
import java.util.SortedSet;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LevelRenderer.class}, priority=500)
public abstract class LevelRendererMixin {
    @Shadow
    @Final
    private Minecraft f_109461_;
    @Shadow
    @Final
    private Long2ObjectMap<SortedSet<BlockDestructionProgress>> f_109409_;
    @Shadow
    @Final
    private RenderBuffers f_109464_;
    @Shadow
    @Nullable
    private ClientLevel f_109465_;
    @Unique
    private final RandomSource gtceu$modelRandom = RandomSource.m_216327_();

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void renderLevel(PoseStack poseStack, float partialTick, long finishNanoTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f projectionMatrix, CallbackInfo ci) {
        HitResult hitResult;
        if (this.f_109461_.f_91074_ == null || this.f_109465_ == null) {
            return;
        }
        ItemStack mainHandItem = this.f_109461_.f_91074_.m_21205_();
        if (this.f_109461_.f_91074_.m_6144_() || !ToolHelper.hasBehaviorsTag(mainHandItem) || !((hitResult = this.f_109461_.f_91077_) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult hitResult2 = (BlockHitResult)hitResult;
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(mainHandItem);
        if (aoeDefinition.isZero()) {
            return;
        }
        BlockPos hitPos = hitResult2.m_82425_();
        BlockState hitState = this.f_109465_.m_8055_(hitPos);
        SortedSet progresses = (SortedSet)this.f_109409_.get(hitPos.m_121878_());
        if (progresses == null || progresses.isEmpty() || !mainHandItem.m_41735_(hitState)) {
            return;
        }
        BlockDestructionProgress progress = (BlockDestructionProgress)progresses.last();
        UseOnContext context = new UseOnContext((Player)this.f_109461_.f_91074_, InteractionHand.MAIN_HAND, hitResult2);
        List<BlockPos> positions = ToolHelper.getHarvestableBlocks(aoeDefinition, context);
        Vec3 camPos = camera.m_90583_();
        poseStack.m_85836_();
        poseStack.m_85837_(-camPos.m_7096_(), -camPos.m_7098_(), -camPos.m_7094_());
        for (BlockPos pos : positions) {
            poseStack.m_85836_();
            poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            PoseStack.Pose last = poseStack.m_85850_();
            SheetedDecalTextureGenerator breakProgressDecal = new SheetedDecalTextureGenerator(this.f_109464_.m_110108_().m_6299_((RenderType)ModelBakery.f_119229_.get(progress.m_139988_())), last.m_252922_(), last.m_252943_(), 1.0f);
            ModelData modelData = this.f_109465_.getModelDataManager().getAt(pos);
            this.f_109461_.m_91289_().renderBreakingTexture(this.f_109465_.m_8055_(pos), pos, (BlockAndTintGetter)this.f_109465_, poseStack, (VertexConsumer)breakProgressDecal, modelData != null ? modelData : ModelData.EMPTY);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    @Shadow
    private static void m_109782_(PoseStack poseStack, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        throw new AssertionError();
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderHitOutline(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;DDDLnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    private void gtceu$handleAOEOutline(LevelRenderer instance, PoseStack poseStack, VertexConsumer consumer, Entity entity, double camX, double camY, double camZ, BlockPos pos, BlockState state, Operation<Void> original) {
        HitResult hitResult;
        if (this.f_109461_.f_91074_ == null || this.f_109465_ == null) {
            return;
        }
        ItemStack mainHandItem = this.f_109461_.f_91074_.m_21205_();
        if (state.m_60795_() || this.f_109461_.f_91074_.m_6144_() || !this.f_109465_.m_46739_(pos) || !mainHandItem.m_41735_(state) || !ToolHelper.hasBehaviorsTag(mainHandItem) || !((hitResult = this.f_109461_.f_91077_) instanceof BlockHitResult)) {
            this.gtceu$renderContextAwareOutline(instance, poseStack, consumer, entity, camX, camY, camZ, pos, state, original);
            return;
        }
        BlockHitResult hitResult2 = (BlockHitResult)hitResult;
        UseOnContext context = new UseOnContext((Player)this.f_109461_.f_91074_, InteractionHand.MAIN_HAND, hitResult2);
        List<BlockPos> blocks = ToolHelper.getHarvestableBlocks(ToolHelper.getAoEDefinition(mainHandItem), context);
        blocks.sort((o1, o2) -> {
            if (this.f_109465_.m_8055_(o1).m_60734_() instanceof MaterialBlock) {
                if (this.f_109465_.m_8055_(o2).m_60734_() instanceof MaterialBlock) {
                    return 0;
                }
                return 1;
            }
            if (this.f_109465_.m_8055_(o2).m_60734_() instanceof MaterialBlock) {
                return -1;
            }
            return 0;
        });
        blocks.forEach(blockPos -> this.gtceu$renderContextAwareOutline(instance, poseStack, consumer, entity, camX, camY, camZ, (BlockPos)blockPos, this.f_109465_.m_8055_(blockPos), original));
    }

    @Unique
    private void gtceu$renderContextAwareOutline(LevelRenderer instance, PoseStack poseStack, VertexConsumer consumer, Entity entity, double camX, double camY, double camZ, BlockPos pos, BlockState state, Operation<Void> original) {
        assert (this.f_109465_ != null);
        ConfigHolder.RendererConfigs rendererCfg = ConfigHolder.INSTANCE.client.renderer;
        int rgb = 0;
        boolean doRenderColoredOutline = false;
        MaterialEntry materialEntry = this.gtceu$getTranslucentBlockMaterial(state, pos);
        if (!materialEntry.isEmpty()) {
            doRenderColoredOutline = true;
            rgb = materialEntry.material().getMaterialRGB();
        } else {
            Object steam;
            BlockEntity blockEntity = this.f_109465_.m_7702_(pos);
            if (blockEntity instanceof IMachineBlockEntity) {
                IMachineBlockEntity mbe = (IMachineBlockEntity)blockEntity;
                if (rendererCfg.coloredTieredMachineOutline) {
                    var22_18 = mbe.getMetaMachine();
                    if (var22_18 instanceof SteamMachine) {
                        steam = (SteamMachine)var22_18;
                        doRenderColoredOutline = true;
                        rgb = ((SteamMachine)steam).isHighPressure() ? 7959919 : 12291667;
                    } else {
                        var22_18 = mbe.getMetaMachine();
                        if (var22_18 instanceof ITieredMachine) {
                            ITieredMachine tiered = (ITieredMachine)((Object)var22_18);
                            doRenderColoredOutline = true;
                            rgb = GTValues.VCM[tiered.getTier()];
                        }
                    }
                }
            } else if (rendererCfg.coloredWireOutline && (steam = this.f_109465_.m_7702_(pos)) instanceof IPipeNode) {
                IPipeNode pipe = (IPipeNode)steam;
                doRenderColoredOutline = true;
                if (!pipe.getFrameMaterial().isNull()) {
                    rgb = pipe.getFrameMaterial().getMaterialRGB();
                } else if (pipe instanceof CableBlockEntity) {
                    CableBlockEntity cable = (CableBlockEntity)pipe;
                    rgb = GTValues.VCM[GTUtil.getTierByVoltage(((WireProperties)cable.getNodeData()).getVoltage())];
                } else {
                    var22_18 = state.m_60734_();
                    if (var22_18 instanceof MaterialPipeBlock) {
                        MaterialPipeBlock materialPipe = (MaterialPipeBlock)((Object)var22_18);
                        rgb = materialPipe.material.getMaterialRGB();
                    }
                }
            }
        }
        VoxelShape blockShape = state.m_60651_((BlockGetter)this.f_109465_, pos, CollisionContext.m_82750_((Entity)entity));
        if (doRenderColoredOutline) {
            float red = (float)FastColor.ARGB32.m_13665_((int)rgb) / 255.0f;
            float green = (float)FastColor.ARGB32.m_13667_((int)rgb) / 255.0f;
            float blue = (float)FastColor.ARGB32.m_13669_((int)rgb) / 255.0f;
            LevelRendererMixin.m_109782_(poseStack, consumer, blockShape, (double)pos.m_123341_() - camX, (double)pos.m_123342_() - camY, (double)pos.m_123343_() - camZ, red, green, blue, 1.0f);
            return;
        }
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (BlockPos o : GTUtil.NON_CORNER_NEIGHBOURS) {
            BlockPos.MutableBlockPos offset = mutable.m_175306_((Vec3i)pos, (Vec3i)o);
            if (this.gtceu$getTranslucentBlockMaterial(this.f_109465_.m_8055_((BlockPos)offset), (BlockPos)offset).isEmpty()) continue;
            LevelRendererMixin.m_109782_(poseStack, consumer, blockShape, (double)pos.m_123341_() - camX, (double)pos.m_123342_() - camY, (double)pos.m_123343_() - camZ, 0.0f, 0.0f, 0.0f, 1.0f);
            return;
        }
        original.call(new Object[]{instance, poseStack, consumer, entity, camX, camY, camZ, pos, state});
    }

    @Unique
    @NotNull
    private MaterialEntry gtceu$getTranslucentBlockMaterial(BlockState state, BlockPos pos) {
        assert (this.f_109465_ != null);
        if (!state.m_60804_((BlockGetter)this.f_109465_, pos) && !(state.m_60734_() instanceof MaterialBlock)) {
            return MaterialEntry.NULL_ENTRY;
        }
        BakedModel blockModel = this.f_109461_.m_91289_().m_110910_(state);
        ModelData modelData = this.f_109465_.getModelDataManager().getAt(pos);
        if (modelData == null) {
            modelData = ModelData.EMPTY;
        }
        modelData = blockModel.getModelData((BlockAndTintGetter)this.f_109465_, pos, state, modelData);
        this.gtceu$modelRandom.m_188584_(state.m_60726_(pos));
        if (blockModel.getRenderTypes(state, this.gtceu$modelRandom, modelData).contains(RenderType.m_110466_())) {
            return ChemicalHelper.getMaterialEntry((ItemLike)state.m_60734_());
        }
        return MaterialEntry.NULL_ENTRY;
    }
}

