/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.unification.material;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.registry.MaterialRegistry;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.unification.material.MaterialRegistryManager;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class MaterialRegistryImpl
extends MaterialRegistry {
    private static int networkIdCounter;
    private final int networkId = networkIdCounter++;
    private final String modid;
    private boolean isRegistryClosed = false;
    @NotNull
    private Material fallbackMaterial = GTMaterials.NULL;

    protected MaterialRegistryImpl(@NotNull String modid) {
        super(modid);
        this.modid = modid;
    }

    @Override
    public void register(Material material) {
        this.register(material.getName(), material);
    }

    @Override
    public <T extends Material> T register(@NotNull String key, @NotNull T value) {
        if (this.isRegistryClosed) {
            GTCEu.LOGGER.error("Materials cannot be registered in the PostMaterialEvent (or after)! Must be added in the MaterialEvent. Skipping material {}...", (Object)key);
            return null;
        }
        super.register(key, value);
        return value;
    }

    @Override
    @NotNull
    public Collection<Material> getAllMaterials() {
        return this.values();
    }

    @Override
    public void setFallbackMaterial(@NotNull Material material) {
        this.fallbackMaterial = material;
    }

    @Override
    @NotNull
    public Material getFallbackMaterial() {
        if (this.fallbackMaterial.isNull()) {
            this.fallbackMaterial = MaterialRegistryManager.getInstance().getDefaultFallback();
        }
        return this.fallbackMaterial;
    }

    @Override
    public int getNetworkId() {
        return this.networkId;
    }

    @Override
    @NotNull
    public String getModid() {
        return this.modid;
    }

    public void closeRegistry() {
        this.isRegistryClosed = true;
    }
}

