/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.cable;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.pipenet.PipeNetWalker;
import com.gregtechceu.gtceu.common.blockentity.CableBlockEntity;
import com.gregtechceu.gtceu.common.pipelike.cable.EnergyNet;
import com.gregtechceu.gtceu.common.pipelike.cable.EnergyRoutePath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyNetWalker
extends PipeNetWalker<CableBlockEntity, WireProperties, EnergyNet> {
    private final List<EnergyRoutePath> routes;
    private CableBlockEntity[] pipes = new CableBlockEntity[0];
    private int loss;

    @Nullable
    public static List<EnergyRoutePath> createNetData(EnergyNet pipeNet, BlockPos sourcePipe) {
        try {
            EnergyNetWalker walker = new EnergyNetWalker(pipeNet, sourcePipe, 1, new ArrayList<EnergyRoutePath>());
            walker.traversePipeNet();
            return walker.routes;
        }
        catch (Exception e) {
            GTCEu.LOGGER.error("error while create net data for energynet", (Throwable)e);
            return null;
        }
    }

    public EnergyNetWalker(EnergyNet pipeNet, BlockPos sourcePipe, int walkedBlocks, List<EnergyRoutePath> routes) {
        super(pipeNet, sourcePipe, walkedBlocks);
        this.routes = routes;
    }

    @Override
    @NotNull
    protected PipeNetWalker<CableBlockEntity, WireProperties, EnergyNet> createSubWalker(EnergyNet pipeNet, Direction facingToNextPos, BlockPos nextPos, int walkedBlocks) {
        EnergyNetWalker walker = new EnergyNetWalker(pipeNet, nextPos, walkedBlocks, this.routes);
        walker.loss = this.loss;
        walker.pipes = this.pipes;
        return walker;
    }

    @Override
    protected void checkPipe(CableBlockEntity pipeTile, BlockPos pos) {
        this.pipes = (CableBlockEntity[])ArrayUtils.add((Object[])this.pipes, (Object)pipeTile);
        this.loss += ((WireProperties)pipeTile.getNodeData()).getLossPerBlock();
    }

    @Override
    protected void checkNeighbour(CableBlockEntity pipeTile, BlockPos pipePos, Direction faceToNeighbour, @Nullable BlockEntity neighbourTile) {
        IEnergyContainer container;
        if (pipeTile != this.pipes[this.pipes.length - 1]) {
            throw new IllegalStateException("The current pipe is not the last added pipe. Something went seriously wrong!");
        }
        if (neighbourTile != null && (container = (IEnergyContainer)neighbourTile.getCapability(GTCapability.CAPABILITY_ENERGY_CONTAINER, faceToNeighbour.m_122424_()).resolve().orElse(null)) != null) {
            this.routes.add(new EnergyRoutePath(pipePos.m_7949_(), faceToNeighbour, this.pipes, this.getWalkedBlocks(), this.loss));
        }
    }

    @Override
    protected Class<CableBlockEntity> getBasePipeClass() {
        return CableBlockEntity.class;
    }
}

