/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait.customlogic;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public enum CannerLogic implements GTRecipeType.ICustomRecipeLogic
{
    INSTANCE;


    @Override
    @Nullable
    public GTRecipe createCustomRecipe(IRecipeCapabilityHolder holder) {
        IFluidHandlerItem fluidHandler;
        List<RecipeHandlerList> handlerLists = holder.getCapabilitiesForIO(IO.IN);
        if (handlerLists.isEmpty()) {
            return null;
        }
        ArrayList<RecipeHandlerList> distinct = new ArrayList<RecipeHandlerList>();
        ArrayList notDistinctItems = new ArrayList();
        ArrayList notDistinctFluids = new ArrayList();
        for (RecipeHandlerList handlerList : handlerLists) {
            if (handlerList.isDistinct()) {
                distinct.add(handlerList);
                continue;
            }
            notDistinctItems.addAll(handlerList.getCapability(ItemRecipeCapability.CAP));
            notDistinctFluids.addAll(handlerList.getCapability(FluidRecipeCapability.CAP));
        }
        if (distinct.isEmpty() && notDistinctItems.isEmpty() && notDistinctFluids.isEmpty()) {
            return null;
        }
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        ArrayList<Pair> validItems = new ArrayList<Pair>();
        ArrayList<FluidStack> validFluids = new ArrayList<FluidStack>();
        for (RecipeHandlerList rhl : distinct) {
            itemStacks.clear();
            fluidStacks.clear();
            if (!CannerLogic.collect(rhl, itemStacks, fluidStacks)) continue;
            for (ItemStack itemStack : itemStacks) {
                ItemStack single = itemStack.m_255036_(1);
                ItemStack copy = itemStack.m_255036_(1);
                IFluidHandlerItem fluidHandler2 = FluidUtil.getFluidHandler((ItemStack)copy).resolve().orElse(null);
                if (fluidHandler2 == null) continue;
                FluidStack fluid = fluidHandler2.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                if (!fluid.isEmpty()) {
                    return GTRecipeTypes.CANNER_RECIPES.recipeBuilder("drain_fluid").inputItems(single).outputItems(fluidHandler2.getContainer()).outputFluids(fluid).duration(Math.max(16, fluid.getAmount() / 64)).EUt(4L).buildRawRecipe();
                }
                for (FluidStack fluidStack : fluidStacks) {
                    FluidStack fluidCopy = fluidStack.copy();
                    int filled = fluidHandler2.fill(fluidCopy, IFluidHandler.FluidAction.EXECUTE);
                    if (filled == 0) continue;
                    fluidCopy.setAmount(filled);
                    return GTRecipeTypes.CANNER_RECIPES.recipeBuilder("fill_fluid").inputItems(single).inputFluids(fluidCopy).outputItems(fluidHandler2.getContainer()).duration(Math.max(16, filled / 64)).EUt(4L).buildRawRecipe();
                }
                validItems.add(Pair.of((Object)copy, (Object)fluidHandler2));
            }
            validFluids.addAll(fluidStacks);
        }
        itemStacks.clear();
        fluidStacks.clear();
        CannerLogic.collect(notDistinctItems, notDistinctFluids, itemStacks, fluidStacks);
        if (itemStacks.isEmpty() && validItems.isEmpty()) {
            return null;
        }
        fluidStacks.addAll(validFluids);
        for (ItemStack itemStack : itemStacks) {
            ItemStack single = itemStack.m_255036_(1);
            ItemStack copy = itemStack.m_255036_(1);
            fluidHandler = FluidUtil.getFluidHandler((ItemStack)copy).resolve().orElse(null);
            if (fluidHandler == null) continue;
            FluidStack fluid = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            if (!fluid.isEmpty()) {
                return GTRecipeTypes.CANNER_RECIPES.recipeBuilder("drain_fluid").inputItems(single).outputItems(fluidHandler.getContainer()).outputFluids(fluid).duration(Math.max(16, fluid.getAmount() / 64)).EUt(4L).buildRawRecipe();
            }
            for (FluidStack fluidStack : fluidStacks) {
                FluidStack fluidCopy = fluidStack.copy();
                int filled = fluidHandler.fill(fluidCopy, IFluidHandler.FluidAction.EXECUTE);
                if (filled == 0) continue;
                fluidCopy.setAmount(filled);
                return GTRecipeTypes.CANNER_RECIPES.recipeBuilder("fill_fluid").inputItems(single).inputFluids(fluidCopy).outputItems(fluidHandler.getContainer()).duration(Math.max(16, filled / 64)).EUt(4L).buildRawRecipe();
            }
        }
        if (fluidStacks.isEmpty()) {
            return null;
        }
        for (Pair pair : validItems) {
            ItemStack stack = (ItemStack)pair.getFirst();
            ItemStack single = stack.m_255036_(1);
            fluidHandler = (IFluidHandlerItem)pair.getSecond();
            for (FluidStack fluidStack : fluidStacks) {
                FluidStack fluidCopy = fluidStack.copy();
                int filled = fluidHandler.fill(fluidCopy, IFluidHandler.FluidAction.EXECUTE);
                if (filled == 0) continue;
                fluidCopy.setAmount(filled);
                return GTRecipeTypes.CANNER_RECIPES.recipeBuilder("fill_fluid").inputItems(single).inputFluids(fluidCopy).outputItems(fluidHandler.getContainer()).duration(Math.max(16, filled / 64)).EUt(4L).buildRawRecipe();
            }
        }
        return null;
    }

    private static boolean collect(RecipeHandlerList rhl, List<ItemStack> itemStacks, List<FluidStack> fluidStacks) {
        return CannerLogic.collect(rhl.getCapability(ItemRecipeCapability.CAP), rhl.getCapability(FluidRecipeCapability.CAP), itemStacks, fluidStacks);
    }

    private static boolean collect(List<IRecipeHandler<?>> itemHandlers, List<IRecipeHandler<?>> fluidHandlers, List<ItemStack> itemStacks, List<FluidStack> fluidStacks) {
        ItemStack stack;
        for (IRecipeHandler<?> handler : itemHandlers) {
            for (Object content : handler.getContents()) {
                if (!(content instanceof ItemStack) || (stack = (ItemStack)content).m_41619_()) continue;
                itemStacks.add(stack);
            }
        }
        for (IRecipeHandler<?> handler : fluidHandlers) {
            for (Object content : handler.getContents()) {
                if (!(content instanceof FluidStack) || (stack = (FluidStack)content).isEmpty()) continue;
                fluidStacks.add((FluidStack)stack);
            }
        }
        return !itemStacks.isEmpty() && !fluidStacks.isEmpty();
    }
}

