/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.IObjectHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.BlockableSlotWidget;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.component.IDataItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.SortedSet;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ObjectHolderMachine
extends MultiblockPartMachine
implements IObjectHolder,
IMachineLife {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ObjectHolderMachine.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private final ObjectHolderHandler heldItems = new ObjectHolderHandler(this);
    @Persisted
    @DescSynced
    private boolean isLocked;

    public ObjectHolderMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    @NotNull
    public ItemStack getHeldItem(boolean remove) {
        return this.getHeldItem(0, remove);
    }

    @Override
    public void setHeldItem(@NotNull ItemStack heldItem) {
        this.heldItems.setStackInSlot(0, heldItem);
    }

    @Override
    @NotNull
    public ItemStack getDataItem(boolean remove) {
        return this.getHeldItem(1, remove);
    }

    @Override
    public void setDataItem(@NotNull ItemStack dataItem) {
        this.heldItems.setStackInSlot(1, dataItem);
    }

    @Override
    @NotNull
    public NotifiableItemStackHandler getAsHandler() {
        return this.heldItems;
    }

    @NotNull
    private ItemStack getHeldItem(int slot, boolean remove) {
        ItemStack stackInSlot = this.heldItems.getStackInSlot(slot);
        if (remove && stackInSlot != ItemStack.f_41583_) {
            this.heldItems.setStackInSlot(slot, ItemStack.f_41583_);
        }
        return stackInSlot;
    }

    @Override
    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.heldItems.storage);
    }

    @Override
    public Widget createUIWidget() {
        return new WidgetGroup(new Position(0, 0)).addWidget((Widget)new ImageWidget(46, 15, 84, 60, (IGuiTexture)GuiTextures.PROGRESS_BAR_RESEARCH_STATION_BASE)).addWidget(new BlockableSlotWidget(this.heldItems, 0, 79, 36).setIsBlocked(this::isLocked).setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.RESEARCH_STATION_OVERLAY})).addWidget(new BlockableSlotWidget(this.heldItems, 1, 15, 36).setIsBlocked(this::isLocked).setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.DATA_ORB_OVERLAY}));
    }

    @Override
    public void setFrontFacing(Direction frontFacing) {
        super.setFrontFacing(frontFacing);
        SortedSet<IMultiController> controllers = this.getControllers();
        for (IMultiController controller : controllers) {
            if (controller == null || !controller.isFormed()) continue;
            controller.checkPatternWithLock();
        }
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Generated
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    @Generated
    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    private class ObjectHolderHandler
    extends NotifiableItemStackHandler {
        public ObjectHolderHandler(MetaMachine metaTileEntity) {
            super(metaTileEntity, 2, IO.IN, IO.BOTH, size -> new CustomItemStackHandler(size){

                public int getSlotLimit(int slot) {
                    return 1;
                }
            });
        }

        @Override
        public int getSlotLimit(int slot) {
            return 1;
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!ObjectHolderMachine.this.isLocked()) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        @Override
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (stack.m_41619_()) {
                return true;
            }
            boolean isDataItem = false;
            Item item = stack.m_41720_();
            if (item instanceof IComponentItem) {
                IComponentItem metaItem = (IComponentItem)item;
                for (IItemComponent behaviour : metaItem.getComponents()) {
                    if (!(behaviour instanceof IDataItem)) continue;
                    isDataItem = true;
                    break;
                }
            }
            if (slot == 0 && !isDataItem) {
                return true;
            }
            return slot == 1 && isDataItem;
        }
    }
}

