/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.blockentity.IPaintable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.CircuitFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IHasCircuitSlot;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDistinctPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemBusPartMachine
extends TieredIOPartMachine
implements IDistinctPart,
IMachineLife,
IHasCircuitSlot,
IPaintable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ItemBusPartMachine.class, TieredIOPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private final NotifiableItemStackHandler inventory;
    @Nullable
    protected TickableSubscription autoIOSubs;
    @Nullable
    protected ISubscription inventorySubs;
    private boolean hasCircuitSlot = true;
    @Persisted
    @DescSynced
    protected boolean circuitSlotEnabled;
    @Persisted
    protected final NotifiableItemStackHandler circuitInventory;
    @Persisted
    @DescSynced
    private boolean isDistinct = false;

    public ItemBusPartMachine(IMachineBlockEntity holder, int tier, IO io, Object ... args) {
        super(holder, tier, io);
        this.inventory = this.createInventory(args);
        this.circuitSlotEnabled = true;
        this.circuitInventory = this.createCircuitItemHandler(io).shouldSearchContent(false);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected int getInventorySize() {
        int sizeRoot = 1 + Math.min(9, this.getTier());
        return sizeRoot * sizeRoot;
    }

    protected NotifiableItemStackHandler createInventory(Object ... args) {
        return new NotifiableItemStackHandler(this, this.getInventorySize(), this.io);
    }

    protected NotifiableItemStackHandler createCircuitItemHandler(Object ... args) {
        IO io;
        Object object;
        if (args.length > 0 && (object = args[0]) instanceof IO && (io = (IO)object) == IO.IN) {
            return new NotifiableItemStackHandler(this, 1, IO.IN, IO.NONE).setFilter(IntCircuitBehaviour::isIntegratedCircuit);
        }
        this.hasCircuitSlot = false;
        this.setCircuitSlotEnabled(false);
        return new NotifiableItemStackHandler(this, 0, IO.NONE);
    }

    @Override
    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.getInventory().storage);
        if (!ConfigHolder.INSTANCE.machines.ghostCircuit) {
            this.clearInventory((IItemHandlerModifiable)this.circuitInventory.storage);
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateInventorySubscription));
        }
        this.getHandlerList().setDistinct(this.isDistinct);
        this.getHandlerList().setColor(this.getPaintingColor());
        this.inventorySubs = this.getInventory().addChangedListener(this::updateInventorySubscription);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.inventorySubs != null) {
            this.inventorySubs.unsubscribe();
            this.inventorySubs = null;
        }
    }

    @Override
    public void onPaintingColorChanged(int color) {
        this.getHandlerList().setColor(color, true);
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.isDistinct = this.io != IO.OUT && distinct;
        this.getHandlerList().setDistinctAndNotify(this.isDistinct);
    }

    @Override
    public void addedToController(IMultiController controller) {
        if (this.hasCircuitSlot && !controller.allowCircuitSlots()) {
            if (!ConfigHolder.INSTANCE.machines.ghostCircuit) {
                this.clearInventory((IItemHandlerModifiable)this.circuitInventory.storage);
            } else {
                this.circuitInventory.setStackInSlot(0, ItemStack.f_41583_);
            }
            this.setCircuitSlotEnabled(false);
        }
        super.addedToController(controller);
    }

    @Override
    public void removedFromController(IMultiController controller) {
        super.removedFromController(controller);
        if (!this.hasCircuitSlot) {
            return;
        }
        for (IMultiController c : this.controllers) {
            if (c.allowCircuitSlots()) continue;
            return;
        }
        this.setCircuitSlotEnabled(true);
    }

    @Override
    public int tintColor(int index) {
        if (index == 9) {
            return this.getRealColor();
        }
        return -1;
    }

    @Override
    public void loadCustomPersistedData(@NotNull CompoundTag tag) {
        CompoundTag invTag;
        super.loadCustomPersistedData(tag);
        if (tag.m_128441_("inventory") && (invTag = tag.m_128469_("inventory")).m_128441_("isDistinct")) {
            this.isDistinct = invTag.m_128471_("isDistinct");
        }
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateInventorySubscription();
    }

    @Override
    public void onRotated(Direction oldFacing, Direction newFacing) {
        super.onRotated(oldFacing, newFacing);
        this.updateInventorySubscription(newFacing);
    }

    protected void updateInventorySubscription() {
        this.updateInventorySubscription(this.getFrontFacing());
    }

    protected void updateInventorySubscription(Direction newFacing) {
        if (this.isWorkingEnabled() && (this.io.support(IO.OUT) && !this.getInventory().isEmpty() || this.io.support(IO.IN)) && GTTransferUtils.hasAdjacentItemHandler(this.getLevel(), this.getPos(), newFacing)) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    protected void autoIO() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isWorkingEnabled()) {
                if (this.io == IO.OUT) {
                    this.getInventory().exportToNearby(this.getFrontFacing());
                } else if (this.io == IO.IN) {
                    this.getInventory().importFromNearby(this.getFrontFacing());
                } else if (this.io == IO.BOTH) {
                    this.getInventory().importFromNearby(this.getFrontFacing());
                    this.getInventory().exportToNearby(this.getFrontFacing().m_122424_());
                }
            }
            this.updateInventorySubscription();
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        this.updateInventorySubscription();
    }

    @Override
    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        InteractionResult superResult = super.onScrewdriverClick(playerIn, hand, gridSide, hitResult);
        if (superResult != InteractionResult.PASS) {
            return superResult;
        }
        if (this.io == IO.BOTH) {
            return InteractionResult.PASS;
        }
        if (playerIn.m_6144_() && this.swapIO()) {
            return InteractionResult.m_19078_((boolean)playerIn.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean swapIO() {
        IMachineBlockEntity newHolder;
        MetaMachine metaMachine;
        BlockPos blockPos = this.getHolder().pos();
        MachineDefinition newDefinition = null;
        if (this.io == IO.IN) {
            newDefinition = GTMachines.ITEM_EXPORT_BUS[this.getTier()];
        } else if (this.io == IO.OUT) {
            newDefinition = GTMachines.ITEM_IMPORT_BUS[this.getTier()];
        }
        if (newDefinition == null) {
            return false;
        }
        BlockState newBlockState = newDefinition.getBlock().m_49966_();
        this.getLevel().m_46597_(blockPos, newBlockState);
        BlockEntity blockEntity = this.getLevel().m_7702_(blockPos);
        if (blockEntity instanceof IMachineBlockEntity && (metaMachine = (newHolder = (IMachineBlockEntity)blockEntity).getMetaMachine()) instanceof ItemBusPartMachine) {
            ItemBusPartMachine newMachine = (ItemBusPartMachine)metaMachine;
            newMachine.setFrontFacing(this.getFrontFacing());
            newMachine.setUpwardsFacing(this.getUpwardsFacing());
            newMachine.setPaintingColor(this.getPaintingColor());
        }
        return true;
    }

    @Override
    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        if (this.io == IO.IN) {
            IDistinctPart.super.attachConfigurators(configuratorPanel);
            if (this.hasCircuitSlot && this.isCircuitSlotEnabled()) {
                configuratorPanel.attachConfigurators(new CircuitFancyConfigurator(this.circuitInventory.storage));
            }
        } else {
            super.attachConfigurators(configuratorPanel);
        }
    }

    @Override
    public Widget createUIWidget() {
        int rowSize;
        int colSize = rowSize = (int)Math.sqrt(this.getInventorySize());
        if (this.getInventorySize() == 8) {
            rowSize = 4;
            colSize = 2;
        }
        WidgetGroup group = new WidgetGroup(0, 0, 18 * rowSize + 16, 18 * colSize + 16);
        WidgetGroup container = new WidgetGroup(4, 4, 18 * rowSize + 8, 18 * colSize + 8);
        int index = 0;
        for (int y = 0; y < colSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                container.addWidget((Widget)new SlotWidget((IItemHandlerModifiable)this.getInventory().storage, index++, 4 + x * 18, 4 + y * 18, true, this.io.support(IO.IN)).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT).setIngredientIO(this.io == IO.IN ? IngredientIO.INPUT : IngredientIO.OUTPUT));
            }
        }
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    @Generated
    public NotifiableItemStackHandler getInventory() {
        return this.inventory;
    }

    @Generated
    protected boolean isHasCircuitSlot() {
        return this.hasCircuitSlot;
    }

    @Override
    @Generated
    public boolean isCircuitSlotEnabled() {
        return this.circuitSlotEnabled;
    }

    @Generated
    public void setCircuitSlotEnabled(boolean circuitSlotEnabled) {
        this.circuitSlotEnabled = circuitSlotEnabled;
    }

    @Override
    @Generated
    public NotifiableItemStackHandler getCircuitInventory() {
        return this.circuitInventory;
    }

    @Override
    @Generated
    public boolean isDistinct() {
        return this.isDistinct;
    }
}

