/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ItemBusPartMachine;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DualHatchPartMachine
extends ItemBusPartMachine {
    public static final int INITIAL_TANK_CAPACITY = 16000;
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(DualHatchPartMachine.class, ItemBusPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    public final NotifiableFluidTank tank;
    @Nullable
    protected ISubscription tankSubs;
    private boolean hasFluidHandler;
    private boolean hasItemHandler;

    public DualHatchPartMachine(IMachineBlockEntity holder, int tier, IO io, Object ... args) {
        super(holder, tier, io, new Object[0]);
        this.tank = this.createTank(16000, (int)Math.sqrt(this.getInventorySize()), args);
    }

    public static int getTankCapacity(int initialCapacity, int tier) {
        return initialCapacity * (1 << tier - 6);
    }

    @Override
    public int getInventorySize() {
        return (int)Math.pow(this.getTier() - 4, 2.0);
    }

    protected NotifiableFluidTank createTank(int initialCapacity, int slots, Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, slots, DualHatchPartMachine.getTankCapacity(initialCapacity, this.getTier()), this.io);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.tankSubs = this.tank.addChangedListener(this::updateInventorySubscription);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.tankSubs != null) {
            this.tankSubs.unsubscribe();
            this.tankSubs = null;
        }
    }

    @Override
    protected void updateInventorySubscription() {
        boolean canOutput = this.io == IO.OUT && (!this.tank.isEmpty() || !this.getInventory().isEmpty());
        Level level = this.getLevel();
        if (level != null) {
            this.hasItemHandler = GTTransferUtils.hasAdjacentItemHandler(level, this.getPos(), this.getFrontFacing());
            this.hasFluidHandler = GTTransferUtils.hasAdjacentFluidHandler(level, this.getPos(), this.getFrontFacing());
        } else {
            this.hasItemHandler = false;
            this.hasFluidHandler = false;
        }
        if (this.isWorkingEnabled() && (canOutput || this.io == IO.IN) && (this.hasItemHandler || this.hasFluidHandler)) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    @Override
    protected void autoIO() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isWorkingEnabled()) {
                if (this.io == IO.OUT) {
                    if (this.hasItemHandler) {
                        this.getInventory().exportToNearby(this.getFrontFacing());
                    }
                    if (this.hasFluidHandler) {
                        this.tank.exportToNearby(this.getFrontFacing());
                    }
                } else if (this.io == IO.IN) {
                    if (this.hasItemHandler) {
                        this.getInventory().importFromNearby(this.getFrontFacing());
                    }
                    if (this.hasFluidHandler) {
                        this.tank.importFromNearby(this.getFrontFacing());
                    }
                }
            }
            this.updateInventorySubscription();
        }
    }

    @Override
    public boolean swapIO() {
        IMachineBlockEntity newHolder;
        MetaMachine metaMachine;
        BlockPos blockPos = this.getHolder().pos();
        MachineDefinition newDefinition = null;
        if (this.io == IO.IN) {
            newDefinition = GTMachines.DUAL_EXPORT_HATCH[this.getTier()];
        } else if (this.io == IO.OUT) {
            newDefinition = GTMachines.DUAL_IMPORT_HATCH[this.getTier()];
        }
        if (newDefinition == null) {
            return false;
        }
        BlockState newBlockState = newDefinition.getBlock().m_49966_();
        this.getLevel().m_46597_(blockPos, newBlockState);
        BlockEntity blockEntity = this.getLevel().m_7702_(blockPos);
        if (blockEntity instanceof IMachineBlockEntity && (metaMachine = (newHolder = (IMachineBlockEntity)blockEntity).getMetaMachine()) instanceof DualHatchPartMachine) {
            DualHatchPartMachine newMachine = (DualHatchPartMachine)metaMachine;
            newMachine.setFrontFacing(this.getFrontFacing());
            newMachine.setUpwardsFacing(this.getUpwardsFacing());
            for (int i = 0; i < this.tank.getTanks(); ++i) {
                newMachine.tank.setFluidInTank(i, this.tank.getFluidInTank(i));
            }
        }
        return true;
    }

    @Override
    public Widget createUIWidget() {
        int y;
        int slots = this.getInventorySize();
        int tanks = (int)Math.sqrt(slots);
        WidgetGroup group = new WidgetGroup(0, 0, 18 * (tanks + 1) + 16, 18 * tanks + 16);
        WidgetGroup container = new WidgetGroup(4, 4, 18 * (tanks + 1) + 8, 18 * tanks + 8);
        int index = 0;
        for (y = 0; y < tanks; ++y) {
            for (int x = 0; x < tanks; ++x) {
                container.addWidget((Widget)new SlotWidget((IItemHandlerModifiable)this.getInventory().storage, index++, 4 + x * 18, 4 + y * 18, true, this.io.support(IO.IN)).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT).setIngredientIO(this.io == IO.IN ? IngredientIO.INPUT : IngredientIO.OUTPUT));
            }
        }
        index = 0;
        for (y = 0; y < tanks; ++y) {
            container.addWidget((Widget)new TankWidget(this.tank.getStorages()[index++], 4 + tanks * 18, 4 + y * 18, true, this.io.support(IO.IN)).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT));
        }
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }
}

