/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IItemLifeCycle;
import com.gregtechceu.gtceu.api.item.component.IItemUIFactory;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Triplet;
import top.theillusivec4.curios.api.CuriosApi;

public class ItemMagnetBehavior
implements IInteractionItem,
IItemLifeCycle,
IAddInformation,
IItemUIFactory {
    public static final String FILTER_TAG = "MagnetFilter";
    public static final String FILTER_ORDINAL_TAG = "FilterOrdinal";
    private final int range;
    private final long energyDraw;

    public ItemMagnetBehavior(int range) {
        this.range = range;
        this.energyDraw = GTValues.V[range > 8 ? 3 : 1];
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public ModularUI createUI(HeldItemUIFactory.HeldItemHolder holder, Player entityPlayer) {
        ItemStack held = holder.getHeld();
        CompoundTag tag = held.m_41784_();
        Filter selected = Filter.get(tag.m_128451_(FILTER_ORDINAL_TAG));
        HashSet<Triplet> widgets = new HashSet<Triplet>();
        HashMap<Filter, ItemStack> stacks = new HashMap<Filter, ItemStack>();
        ModularUI ui = new ModularUI(176, 157, (IUIHolder)holder, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new EnumSelectorWidget(146, 5, 20, 20, (Enum[])Filter.values(), (Enum)selected, val -> this.updateSelection(tag, (Filter)val, (Collection<Triplet<Filter, Widget, Widget>>)widgets))).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT, 7, 75, true));
        for (Filter f : Filter.values()) {
            ItemStack stack = f.getFilter(held);
            stack.m_41751_(tag.m_128469_(FILTER_TAG).m_6426_());
            stacks.put(f, stack);
            LabelWidget description = new LabelWidget(5, 5, stack.m_41778_());
            WidgetGroup config = ItemFilter.loadFilter(stack).openConfigurator(48, 17);
            boolean visible = f == selected;
            description.setVisible(visible);
            config.setVisible(visible);
            widgets.add(new Triplet((Object)f, (Object)description, (Object)config));
            ui.widget((Widget)description);
            ui.widget((Widget)config);
        }
        ui.registerCloseListener(() -> {
            Filter selection = Filter.get(tag.m_128451_(FILTER_ORDINAL_TAG));
            tag.m_128365_(FILTER_TAG, (Tag)((ItemStack)stacks.get(selection)).m_41784_());
        });
        return ui;
    }

    private void updateSelection(CompoundTag tag, Filter filter, Collection<Triplet<Filter, Widget, Widget>> widgets) {
        tag.m_128405_(FILTER_ORDINAL_TAG, filter.ordinal());
        widgets.forEach(tri -> {
            boolean visible = tri.getA() == filter;
            ((Widget)tri.getB()).setVisible(visible);
            ((Widget)tri.getC()).setVisible(visible);
        });
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level world, @NotNull Player player, InteractionHand hand) {
        if (!player.m_9236_().f_46443_ && player.m_6144_()) {
            player.m_5661_((Component)Component.m_237115_((String)(ItemMagnetBehavior.toggleActive(player.m_21120_(hand)) ? "behavior.item_magnet.enabled" : "behavior.item_magnet.disabled")), true);
        } else {
            IItemUIFactory.super.use(item, world, player, hand);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    private static boolean isActive(ItemStack stack) {
        if (stack == ItemStack.f_41583_) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        if (tag.m_128441_("IsActive")) {
            return tag.m_128471_("IsActive");
        }
        return false;
    }

    private static boolean toggleActive(ItemStack stack) {
        boolean isActive = ItemMagnetBehavior.isActive(stack);
        stack.m_41784_().m_128379_("IsActive", !isActive);
        return !isActive;
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!entity.m_6144_() && entity.f_19797_ % 10 == 0 && ItemMagnetBehavior.isActive(stack) && entity instanceof Player) {
            Player player = (Player)entity;
            Level world = entity.m_9236_();
            if (!ItemMagnetBehavior.drainEnergy(true, stack, this.energyDraw)) {
                return;
            }
            List items = world.m_45976_(ItemEntity.class, new AABB(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_()).m_82377_((double)this.range, (double)this.range, (double)this.range));
            Predicate filter = null;
            boolean didMoveEntity = false;
            for (ItemEntity itemEntity : items) {
                Player closest;
                CompoundTag itemTag;
                if (itemEntity.m_213877_() || (itemTag = itemEntity.getPersistentData()).m_128441_("PreventRemoteMovement") || itemEntity.m_19749_() != null && itemEntity.m_19749_().equals((Object)entity) && itemEntity.m_32063_() || (closest = world.m_45930_((Entity)itemEntity, 4.0)) != null && closest != entity || world.f_46443_) continue;
                if (filter == null) {
                    filter = Filter.get(stack.m_41784_().m_128451_(FILTER_ORDINAL_TAG)).loadFilter(stack);
                }
                if (!filter.test(itemEntity.m_32055_())) continue;
                if (itemEntity.m_32063_()) {
                    itemEntity.m_32061_();
                }
                itemEntity.m_20334_(0.0, 0.0, 0.0);
                itemEntity.m_6034_(entity.m_20185_() - 0.2 + world.f_46441_.m_188500_() * 0.4, entity.m_20186_() - 0.6, entity.m_20189_() - 0.2 + world.f_46441_.m_188500_() * 0.4);
                didMoveEntity = true;
            }
            if (didMoveEntity) {
                world.m_6269_(null, entity, SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.5f * ((world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.7f + 2.0f));
            }
            List xp = world.m_45976_(ExperienceOrb.class, new AABB(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_()).m_82377_(4.0, 4.0, 4.0));
            for (ExperienceOrb orb : xp) {
                if (world.f_46443_ || orb.m_213877_() || player.f_36101_ != 0 || MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.PickupXp(player, orb))) continue;
                world.m_6269_(null, entity, SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.5f * ((world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.7f + 1.8f));
                player.m_7938_((Entity)orb, 1);
                player.m_6756_(orb.f_20770_);
                orb.m_146870_();
                didMoveEntity = true;
            }
            if (didMoveEntity) {
                ItemMagnetBehavior.drainEnergy(false, stack, this.energyDraw);
            }
        }
    }

    @SubscribeEvent
    public void onItemToss(@NotNull ItemTossEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.hasMagnet(event.getPlayer())) {
            event.getEntity().m_32010_(60);
        }
    }

    private boolean hasMagnet(@NotNull Player player) {
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stackInSlot = inventory.m_8020_(i);
            if (!ItemMagnetBehavior.isMagnet(stackInSlot) || !ItemMagnetBehavior.isActive(stackInSlot)) continue;
            return true;
        }
        if (!GTCEu.Mods.isCuriosLoaded()) {
            return false;
        }
        return CuriosUtils.hasMagnetCurios(player);
    }

    private static boolean isMagnet(@NotNull ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IComponentItem) {
            IComponentItem metaItem = (IComponentItem)item;
            for (IItemComponent behavior : metaItem.getComponents()) {
                if (!(behavior instanceof ItemMagnetBehavior)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean drainEnergy(boolean simulate, @NotNull ItemStack stack, long amount) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (electricItem == null) {
            return false;
        }
        return electricItem.discharge(amount, Integer.MAX_VALUE, true, false, simulate) >= amount;
    }

    @Override
    public void appendHoverText(ItemStack itemStack, @Nullable Level level, List<Component> lines, TooltipFlag isAdvanced) {
        lines.add((Component)Component.m_237115_((String)(ItemMagnetBehavior.isActive(itemStack) ? "behavior.item_magnet.enabled" : "behavior.item_magnet.disabled")));
    }

    public static enum Filter implements EnumSelectorWidget.SelectableEnum
    {
        SIMPLE(GTItems.ITEM_FILTER, "item_filter"),
        TAG(GTItems.TAG_FILTER, "item_tag_filter");

        public final ItemEntry<ComponentItem> item;
        public final String texture;

        private Filter(ItemEntry<ComponentItem> item, String texture) {
            this.item = item;
            this.texture = texture;
        }

        public ItemStack getFilter(ItemStack magnet) {
            CompoundTag tag = magnet.m_41784_();
            ItemStack mockStack = new ItemStack(this.item);
            mockStack.m_41751_(tag.m_128469_(ItemMagnetBehavior.FILTER_TAG));
            return mockStack;
        }

        public ItemFilter loadFilter(ItemStack magnet) {
            ItemStack stack = this.getFilter(magnet);
            return ItemFilter.loadFilter(stack);
        }

        public static Filter get(int ordinal) {
            return Filter.values()[ordinal];
        }

        @Override
        @NotNull
        public String getTooltip() {
            return this.item.m_5456_().m_5524_();
        }

        @Override
        @NotNull
        public IGuiTexture getIcon() {
            return new ResourceTexture("gtceu:textures/item/" + this.texture + ".png");
        }
    }

    private static class CuriosUtils {
        private CuriosUtils() {
        }

        public static boolean hasMagnetCurios(Player player) {
            return CuriosApi.getCuriosInventory((LivingEntity)player).map(curios -> curios.findFirstCurio(i -> ItemMagnetBehavior.isMagnet(i) && ItemMagnetBehavior.isActive(i)).isPresent()).orElse(false);
        }
    }
}

