/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.common.network.packets.CPacketImageRequest;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ClientImageCache {
    private static final Map<String, byte[][]> imageParts = new HashMap<String, byte[][]>();
    private static boolean downloading = false;
    private static final AbstractTexture LOADING_TEXTURE_MARKER = new SimpleTexture(GTCEu.id("textures/block/void.png"));
    private static final LoadingCache<String, AbstractTexture> CACHE = CacheBuilder.newBuilder().refreshAfterWrite(120L, TimeUnit.SECONDS).expireAfterAccess(300L, TimeUnit.SECONDS).build(CacheLoader.from(url -> {
        if (!downloading) {
            downloading = true;
            GTCEu.LOGGER.debug("Requesting image {}", url);
            GTNetwork.sendToServer(new CPacketImageRequest((String)url));
        }
        return LOADING_TEXTURE_MARKER;
    }));

    @NotNull
    private static ResourceLocation getUrlTextureId(String url) {
        return GTCEu.id("textures/central_monitor/image_" + url.hashCode());
    }

    @Nullable
    public static ResourceLocation getOrLoadTexture(String url) {
        AbstractTexture texture = null;
        try {
            texture = (AbstractTexture)CACHE.get((Object)url);
        }
        catch (ExecutionException e) {
            Throwable t = e;
            if (t.getCause() != null) {
                t = t.getCause();
            }
            GTCEu.LOGGER.error("Could not load image {}", (Object)url, (Object)t);
        }
        if (texture == null || texture == LOADING_TEXTURE_MARKER) {
            return null;
        }
        return ClientImageCache.getUrlTextureId(url);
    }

    @ApiStatus.Internal
    public static void receiveImagePart(String url, byte[] imagePart, int index, int totalParts) throws IOException {
        byte[][] parts = imageParts.computeIfAbsent(url, $ -> new byte[totalParts][]);
        parts[index] = imagePart;
        if (index == totalParts - 1) {
            byte[] imageBytes = new byte[imagePart.length];
            int currentIndex = 0;
            for (byte[] part : parts) {
                imageBytes = ArrayUtils.insert((int)currentIndex, (byte[])imageBytes, (byte[])part);
                currentIndex += part.length;
            }
            ClientImageCache.saveTexture(url, imageBytes);
            imageParts.remove(url);
            downloading = false;
        }
    }

    private static void saveTexture(String url, byte[] imageBytes) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(imageBytes.length);
        buffer.put(imageBytes).flip();
        DynamicTexture texture = new DynamicTexture(NativeImage.m_85062_((ByteBuffer)buffer));
        Minecraft.m_91087_().m_91097_().m_118495_(ClientImageCache.getUrlTextureId(url), (AbstractTexture)texture);
        CACHE.put((Object)url, (Object)texture);
    }
}

