/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine.impl;

import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRenderType;
import com.gregtechceu.gtceu.client.util.RenderUtil;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.mixins.GrowingPlantBlockAccessor;
import com.gregtechceu.gtceu.core.mixins.IntegerPropertyAccessor;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gregtechceu.gtceu.utils.memoization.GTMemoizer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GrowingPlantRender
extends DynamicRender<IRecipeLogicMachine, GrowingPlantRender> {
    public static final Codec<GrowingPlantRender> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_252432_.listOf().fieldOf("offsets").forGetter(GrowingPlantRender::getOffsets), (App)BuiltInRegistries.f_256975_.m_194605_().optionalFieldOf("growing_block").forGetter(GrowingPlantRender::getGrowingBlock), (App)GrowthMode.CODEC.optionalFieldOf("growth_mode").forGetter(GrowingPlantRender::getGrowthMode)).apply((Applicative)instance, GrowingPlantRender::new));
    public static final DynamicRenderType<IRecipeLogicMachine, GrowingPlantRender> TYPE = new DynamicRenderType(CODEC);
    private static final float EPSILON = 1.0E-25f;
    private final List<Vector3f> offsets;
    private final Optional<Block> growingBlock;
    private final Optional<GrowthMode> growthMode;
    private static final Function<GTRecipe, Optional<Block>> RECIPE_BLOCK_CACHE = GTMemoizer.memoizeFunctionWeakIdent(recipe -> {
        ArrayList<Content> allItemContents = new ArrayList<Content>();
        allItemContents.addAll(recipe.getInputContents(ItemRecipeCapability.CAP));
        allItemContents.addAll(recipe.getTickInputContents(ItemRecipeCapability.CAP));
        allItemContents.addAll(recipe.getOutputContents(ItemRecipeCapability.CAP));
        allItemContents.addAll(recipe.getTickOutputContents(ItemRecipeCapability.CAP));
        return allItemContents.stream().map(Content::getContent).map(ItemRecipeCapability.CAP::of).map(Ingredient::m_43908_).flatMap(Arrays::stream).map(ItemStack::m_41720_).filter(BlockItem.class::isInstance).findFirst().map(BlockItem.class::cast).map(BlockItem::m_40614_);
    });

    public GrowingPlantRender(List<Vector3f> offsets) {
        this(offsets, Optional.empty(), Optional.empty());
    }

    public GrowingPlantRender(List<Vector3f> offsets, Optional<Block> growingBlock, Optional<GrowthMode> growthMode) {
        this.offsets = offsets;
        this.growingBlock = growingBlock;
        this.growthMode = growthMode;
    }

    @Override
    public DynamicRenderType<IRecipeLogicMachine, GrowingPlantRender> getType() {
        return TYPE;
    }

    @Override
    public int getViewDistance() {
        return 32;
    }

    @Override
    public AABB getRenderBoundingBox(IRecipeLogicMachine machine) {
        BlockPos pos = machine.self().getPos();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        Collections.addAll(positions, pos.m_7918_(-1, 0, -1), pos.m_7918_(2, 2, 2));
        for (Vector3f offset : this.offsets) {
            positions.add(BlockPos.m_274561_((double)offset.x(), (double)offset.y(), (double)offset.z()));
        }
        return BoundingBox.m_162378_(positions).map(AABB::m_82321_).orElseGet(() -> super.getRenderBoundingBox(machine));
    }

    @Override
    public void render(IRecipeLogicMachine rlm, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!ConfigHolder.INSTANCE.client.renderer.renderGrowingPlants) {
            return;
        }
        if (!rlm.isActive()) {
            return;
        }
        RecipeLogic recipeLogic = rlm.getRecipeLogic();
        Optional<Block> currentBlock = this.growingBlock.or(() -> Optional.ofNullable(recipeLogic.getLastRecipe()).flatMap(this::findGrowing));
        if (currentBlock.isEmpty()) {
            return;
        }
        Block growing = currentBlock.get();
        BlockState state = growing.m_49966_();
        double progress = recipeLogic.getProgressPercent();
        GrowthMode mode = this.growthMode.orElseGet(() -> this.getGrowthModeForBlock(growing));
        if (this.growthMode.isPresent() && !mode.predicate().test(growing)) {
            if (mode == GrowthMode.GROWING_PLANT && GrowthMode.DOUBLE_TRANSLATE.predicate.test(growing)) {
                mode = GrowthMode.DOUBLE_TRANSLATE;
            }
            mode = mode == GrowthMode.AGE_4 && GrowthMode.PICKLES.predicate().test(growing) ? GrowthMode.PICKLES : GrowthMode.SCALE;
        }
        MetaMachine machine = rlm.self();
        Level level = machine.getLevel();
        assert (level != null);
        BlockPos machinePos = machine.getPos();
        Collection<StateWithOffset> statesToDraw = mode.renderFunction().configureState((BlockAndTintGetter)level, state, progress);
        for (Vector3fc vector3fc : this.getOffsets()) {
            poseStack.m_85836_();
            Vector3f rotated = new Vector3f(vector3fc);
            rotated.rotateX(-1.5707964f);
            machine.getFrontFacing().m_253075_().transform(rotated);
            poseStack.m_252880_(rotated.x(), rotated.y() + 1.0E-25f, rotated.z());
            BlockPos pos = machinePos.m_121955_((Vec3i)BlockPos.m_274561_((double)rotated.x(), (double)rotated.y(), (double)rotated.z()));
            for (StateWithOffset toDraw : statesToDraw) {
                poseStack.m_85836_();
                Vector3fc translation = toDraw.offset;
                poseStack.m_252880_(translation.x(), translation.y(), translation.z());
                mode.renderFunction().renderGrowingBlock((BlockAndTintGetter)level, pos, rotated, toDraw.state, progress, bufferSource, poseStack);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }

    public void drawBlocks(BlockAndTintGetter level, BlockPos machinePos, Direction frontFacing, double progress, GrowthMode mode, BlockState state, PoseStack poseStack, MultiBufferSource bufferSource) {
        for (Vector3fc vector3fc : this.getOffsets()) {
            Block block;
            poseStack.m_85836_();
            Vector3f rotated = new Vector3f(vector3fc);
            rotated.rotateX(-1.5707964f);
            frontFacing.m_253075_().transform(rotated);
            poseStack.m_252880_(rotated.x(), rotated.y(), rotated.z());
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
            poseStack.m_85837_(0.0, progress * 2.0 % 1.0 - 1.0, 0.0);
            if (mode == GrowthMode.GROWING_PLANT && (block = state.m_60734_()) instanceof GrowingPlantBlock) {
                GrowingPlantBlock gp = (GrowingPlantBlock)block;
                poseStack.m_85850_().m_252922_().rotateAround((Quaternionfc)((GrowingPlantBlockAccessor)gp).gtceu$getGrowthDirection().m_253075_(), 0.5f, 0.5f, 0.5f);
            }
            RenderUtil.drawBlock(level, machinePos, state, bufferSource, poseStack);
            poseStack.m_85849_();
        }
    }

    protected Optional<Block> findGrowing(GTRecipe recipe) {
        return RECIPE_BLOCK_CACHE.apply(recipe);
    }

    protected GrowthMode getGrowthModeForBlock(Block block) {
        GrowthMode mode;
        if (block instanceof GrowingPlantBlock) {
            return GrowthMode.GROWING_PLANT;
        }
        BlockState state = block.m_49966_();
        if (state.m_61138_((Property)BlockStateProperties.f_61401_) || state.m_61138_((Property)BlockStateProperties.f_61402_) || state.m_204336_(CustomTags.TALL_PLANTS)) {
            return GrowthMode.DOUBLE_TRANSLATE;
        }
        if (state.m_204336_(BlockTags.f_13041_)) {
            return GrowthMode.TRANSLATE;
        }
        IntegerProperty ageProp = GrowingPlantRender.findAgeProperty(state.m_61147_());
        if (ageProp != null && (mode = GrowthMode.MODE_BY_PROPERTY.get(ageProp)) != null) {
            return mode;
        }
        return GrowthMode.SCALE;
    }

    @Nullable
    public static IntegerProperty findAgeProperty(Collection<Property<?>> properties) {
        for (Property<?> prop : properties) {
            if (!prop.m_61708_().equals("age") && !prop.m_61708_().equals("pickles") || !(prop instanceof IntegerProperty)) continue;
            IntegerProperty intProp = (IntegerProperty)prop;
            return intProp;
        }
        return null;
    }

    @Generated
    public List<Vector3f> getOffsets() {
        return this.offsets;
    }

    @Generated
    public Optional<Block> getGrowingBlock() {
        return this.growingBlock;
    }

    @Generated
    public Optional<GrowthMode> getGrowthMode() {
        return this.growthMode;
    }

    public record GrowthMode(String name, Predicate<Block> predicate, RenderFunction renderFunction) {
        public static final Map<String, GrowthMode> VALUES = new HashMap<String, GrowthMode>();
        public static final Map<IntegerProperty, GrowthMode> MODE_BY_PROPERTY = new HashMap<IntegerProperty, GrowthMode>();
        public static final GrowthMode NONE = new GrowthMode("none", RenderFunction.NO_OP);
        public static final GrowthMode SCALE = new GrowthMode("scale", RenderFunction.SCALE);
        public static final GrowthMode TRANSLATE = new GrowthMode("translate", RenderFunction.TRANSLATE);
        public static final GrowthMode DOUBLE_TRANSLATE = new GrowthMode("double_translate", RenderFunction.DOUBLE_BLOCK);
        public static final GrowthMode GROWING_PLANT = new GrowthMode("growing_plant", block -> block instanceof GrowingPlantBlock, RenderFunction.GROWING_PLANT);
        public static final GrowthMode AGE_1 = GrowthMode.ofIntegerProperty("age_1", BlockStateProperties.f_61405_);
        public static final GrowthMode AGE_2 = GrowthMode.ofIntegerProperty("age_2", BlockStateProperties.f_61406_);
        public static final GrowthMode AGE_3 = GrowthMode.ofIntegerProperty("age_3", BlockStateProperties.f_61407_);
        public static final GrowthMode AGE_4 = GrowthMode.ofIntegerProperty("age_4", BlockStateProperties.f_222999_);
        public static final GrowthMode AGE_5 = GrowthMode.ofIntegerProperty("age_5", BlockStateProperties.f_61408_);
        public static final GrowthMode AGE_7 = GrowthMode.ofIntegerProperty("age_7", BlockStateProperties.f_61409_);
        public static final GrowthMode AGE_15 = GrowthMode.ofIntegerProperty("age_15", BlockStateProperties.f_61410_);
        public static final GrowthMode AGE_25 = GrowthMode.ofIntegerProperty("age_25", BlockStateProperties.f_61411_);
        public static final GrowthMode PICKLES = GrowthMode.ofIntegerProperty("pickles", BlockStateProperties.f_61425_, 0, 4);
        private static final Codec<GrowthMode> CODEC = Codec.STRING.comapFlatMap(name -> {
            GrowthMode mode = VALUES.get(name);
            if (mode != null) {
                return DataResult.success((Object)mode);
            }
            return DataResult.error(() -> "Could not find growth mode named " + name, (Object)SCALE);
        }, GrowthMode::name);

        public GrowthMode(String name, Predicate<Block> predicate, RenderFunction renderFunction) {
            VALUES.put(name, this);
            this.name = name;
            this.predicate = predicate;
            this.renderFunction = renderFunction;
        }

        public GrowthMode(String name, RenderFunction renderFunction) {
            this(name, block -> true, renderFunction);
        }

        public static GrowthMode ofIntegerProperty(String name, IntegerProperty property) {
            IntegerPropertyAccessor accessor = (IntegerPropertyAccessor)property;
            int min = accessor.gtceu$getMin();
            int max = accessor.gtceu$getMax();
            return GrowthMode.ofIntegerProperty(name, property, min, max);
        }

        public static GrowthMode ofIntegerProperty(String name, IntegerProperty property, int min, int max) {
            GrowthMode mode = new GrowthMode(name, block -> block.m_49965_().m_61092_().contains(property), RenderFunction.byIntegerProperty(property, min, max));
            MODE_BY_PROPERTY.put(property, mode);
            return mode;
        }
    }

    @FunctionalInterface
    public static interface RenderFunction {
        public static final RenderFunction NO_OP = (level, pos, offset, state, progress, bufferSource, poseStack) -> {};
        public static final RenderFunction SCALE = (level, pos, offset, state, progress, bufferSource, poseStack) -> {
            poseStack.m_85850_().m_252922_().scaleAround((float)progress, 0.5f, 0.0f, 0.5f);
            poseStack.m_85850_().m_252943_().scale((float)progress);
            RenderUtil.drawBlock(level, pos, state, bufferSource, poseStack);
        };
        public static final ConfigureOnly TRANSLATE = (level, state, progress) -> {
            Vector3f translation = new Vector3f(0.0f, (float)(progress - 1.0), 0.0f);
            return Collections.singleton(new StateWithOffset(state, (Vector3fc)translation));
        };
        public static final ConfigureOnly DOUBLE_BLOCK = (level, state, progress) -> {
            Vector3f translation = new Vector3f(0.0f, (float)(progress * 2.0 - 1.0), 0.0f);
            if (progress > 0.5) {
                Vector3f bottomTranslation = new Vector3f(translation.x(), translation.y() - 1.0f, translation.z());
                BlockState topState = state;
                if (state.m_61138_((Property)BlockStateProperties.f_61401_)) {
                    topState = (BlockState)topState.m_263224_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER);
                } else if (state.m_61138_((Property)BlockStateProperties.f_61402_)) {
                    topState = (BlockState)topState.m_263224_((Property)BlockStateProperties.f_61402_, (Comparable)Half.TOP);
                }
                return Arrays.asList(new StateWithOffset(state, (Vector3fc)bottomTranslation), new StateWithOffset(topState, (Vector3fc)translation));
            }
            if (state.m_61138_((Property)BlockStateProperties.f_61401_)) {
                state = (BlockState)state.m_263224_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER);
            } else if (state.m_61138_((Property)BlockStateProperties.f_61402_)) {
                state = (BlockState)state.m_263224_((Property)BlockStateProperties.f_61402_, (Comparable)Half.TOP);
            }
            return Collections.singleton(new StateWithOffset(state, (Vector3fc)translation));
        };
        public static final RenderFunction GROWING_PLANT = new RenderFunction(){

            @Override
            public void renderGrowingBlock(BlockAndTintGetter level, BlockPos pos, Vector3f offset, BlockState state, double progress, MultiBufferSource bufferSource, PoseStack poseStack) {
                GrowingPlantBlockAccessor accessor = (GrowingPlantBlockAccessor)state.m_60734_();
                poseStack.m_272245_(accessor.gtceu$getGrowthDirection().m_253075_(), 0.5f, 0.5f, 0.5f);
                RenderUtil.drawBlock(level, pos, state, bufferSource, poseStack);
            }

            @Override
            public Collection<StateWithOffset> configureState(BlockAndTintGetter level, BlockState state, double progress) {
                GrowingPlantBlockAccessor accessor = (GrowingPlantBlockAccessor)state.m_60734_();
                Vector3f translation = new Vector3f(0.0f, (float)(progress * 2.0 - 1.0), 0.0f);
                if (progress < 0.5) {
                    BlockState headState = accessor.gtceu$getHeadBlock().m_49966_();
                    IntegerProperty ageProp = GrowingPlantRender.findAgeProperty(headState.m_61147_());
                    if (ageProp != null) {
                        IntegerPropertyAccessor prop = (IntegerPropertyAccessor)ageProp;
                        int minValue = prop.gtceu$getMin();
                        int maxValue = prop.gtceu$getMax();
                        int stage = GTMath.lerpInt(progress, minValue, maxValue + 1);
                        headState = (BlockState)headState.m_263224_((Property)ageProp, (Comparable)Integer.valueOf(Math.min(stage, maxValue)));
                    }
                    if (progress >= 0.25 && headState.m_61138_((Property)BlockStateProperties.f_155977_)) {
                        headState = (BlockState)headState.m_263224_((Property)CaveVines.f_152949_, (Comparable)Boolean.valueOf(true));
                    }
                    return Collections.singleton(new StateWithOffset(headState, (Vector3fc)translation));
                }
                BlockState headState = accessor.gtceu$getHeadBlock().m_49966_();
                IntegerProperty ageProp = GrowingPlantRender.findAgeProperty(headState.m_61147_());
                if (ageProp != null) {
                    headState = (BlockState)headState.m_263224_((Property)ageProp, (Comparable)Integer.valueOf(((IntegerPropertyAccessor)ageProp).gtceu$getMax()));
                }
                if (headState.m_61138_((Property)BlockStateProperties.f_155977_)) {
                    headState = (BlockState)headState.m_263224_((Property)CaveVines.f_152949_, (Comparable)Boolean.valueOf(true));
                }
                BlockState bodyState = accessor.gtceu$getBodyBlock().m_49966_();
                if (progress >= 0.75 && bodyState.m_61138_((Property)BlockStateProperties.f_155977_)) {
                    bodyState = (BlockState)bodyState.m_263224_((Property)CaveVines.f_152949_, (Comparable)Boolean.valueOf(true));
                }
                Vector3f bodyTranslation = new Vector3f(translation.x(), translation.y() - 1.0f, translation.z());
                return Arrays.asList(new StateWithOffset(bodyState, (Vector3fc)bodyTranslation), new StateWithOffset(headState, (Vector3fc)translation));
            }
        };
        public static final TriFunction<IntegerProperty, Integer, Integer, ConfigureOnly> PROPERTY_FUNCTION_CACHE = GTMemoizer.memoize((property, min, max) -> {
            IntegerPropertyAccessor accessor = (IntegerPropertyAccessor)property;
            int minValue = accessor.gtceu$getMin();
            int maxValue = accessor.gtceu$getMax();
            return (level, state, progress) -> {
                int growthStage = GTMath.lerpInt(progress, min, max + 1);
                if (growthStage < minValue) {
                    return Collections.emptySet();
                }
                state = (BlockState)state.m_263224_((Property)property, (Comparable)Integer.valueOf(Math.min(growthStage, maxValue)));
                return List.of(new StateWithOffset(state));
            };
        });

        public void renderGrowingBlock(BlockAndTintGetter var1, BlockPos var2, Vector3f var3, BlockState var4, double var5, MultiBufferSource var7, PoseStack var8);

        default public Collection<StateWithOffset> configureState(BlockAndTintGetter level, BlockState state, double progress) {
            return Collections.singleton(new StateWithOffset(state));
        }

        public static ConfigureOnly byIntegerProperty(IntegerProperty property, int min, int max) {
            return (ConfigureOnly)PROPERTY_FUNCTION_CACHE.apply((Object)property, (Object)min, (Object)max);
        }

        @FunctionalInterface
        public static interface ConfigureOnly
        extends RenderFunction {
            @Override
            default public void renderGrowingBlock(BlockAndTintGetter level, BlockPos pos, Vector3f offset, BlockState state, double progress, MultiBufferSource bufferSource, PoseStack poseStack) {
                RenderUtil.drawBlock(level, pos, state, bufferSource, poseStack);
            }

            @Override
            public Collection<StateWithOffset> configureState(BlockAndTintGetter var1, BlockState var2, double var3);
        }
    }

    public record StateWithOffset(BlockState state, Vector3fc offset) {
        private static final Vector3fc ZERO_VECTOR = new Vector3f();

        public StateWithOffset(BlockState state) {
            this(state, ZERO_VECTOR);
        }
    }
}

