/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine.impl;

import com.gregtechceu.gtceu.api.block.property.GTBlockStateProperties;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.client.model.machine.IControllerModelRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRenderType;
import com.gregtechceu.gtceu.client.util.ModelUtils;
import com.gregtechceu.gtceu.common.block.BoilerFireboxType;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoilerMultiPartRender
extends DynamicRender<MultiblockControllerMachine, BoilerMultiPartRender>
implements IControllerModelRenderer {
    public static final Codec<BoilerMultiPartRender> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("firebox_idle").forGetter(BoilerMultiPartRender::getFireboxIdle), (App)BlockState.f_61039_.fieldOf("firebox_active").forGetter(BoilerMultiPartRender::getFireboxActive), (App)BlockState.f_61039_.fieldOf("casing_block").forGetter(BoilerMultiPartRender::getCasing)).apply((Applicative)instance, BoilerMultiPartRender::new));
    public static final DynamicRenderType<MultiblockControllerMachine, BoilerMultiPartRender> TYPE = new DynamicRenderType(CODEC);
    private final BlockState fireboxIdle;
    private final BlockState fireboxActive;
    private final BlockState casing;
    private BakedModel fireboxIdleModel;
    private BakedModel fireboxActiveModel;
    private BakedModel casingModel;

    public BoilerMultiPartRender(BoilerFireboxType fireboxType, Supplier<? extends Block> casingBlock) {
        this(GTBlocks.ALL_FIREBOXES.get(fireboxType).getDefaultState(), (BlockState)GTBlocks.ALL_FIREBOXES.get(fireboxType).getDefaultState().m_61124_((Property)GTBlockStateProperties.ACTIVE, (Comparable)Boolean.valueOf(true)), casingBlock.get().m_49966_());
    }

    public BoilerMultiPartRender(BlockState fireboxIdle, BlockState fireboxActive, BlockState casing) {
        this.fireboxIdle = fireboxIdle;
        this.fireboxActive = fireboxActive;
        this.casing = casing;
    }

    @Override
    public DynamicRenderType<MultiblockControllerMachine, BoilerMultiPartRender> getType() {
        return TYPE;
    }

    @Override
    public void render(MultiblockControllerMachine machine, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
    }

    @Override
    public boolean shouldRender(MultiblockControllerMachine machine, Vec3 cameraPos) {
        return false;
    }

    @Override
    public boolean isBlockEntityRenderer() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderPartModel(List<BakedQuad> quads, IMultiController controller, IMultiPart part, Direction frontFacing, @Nullable Direction side, RandomSource rand, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        int partY;
        boolean flipped;
        Direction multiUpward;
        Direction multiFront;
        Direction relativeDown;
        if (this.fireboxIdleModel == null) {
            this.fireboxIdleModel = ModelUtils.getModelForState(this.fireboxIdle);
        }
        if (this.fireboxActiveModel == null) {
            this.fireboxActiveModel = ModelUtils.getModelForState(this.fireboxActive);
        }
        if (this.casingModel == null) {
            this.casingModel = ModelUtils.getModelForState(this.casing);
        }
        BlockPos partPos = part.self().getPos();
        MultiblockControllerMachine machine = controller.self();
        BlockPos controllerPos = machine.getPos();
        int belowControllerY = controllerPos.m_121945_(relativeDown = RelativeDirection.DOWN.getRelative(multiFront = machine.getFrontFacing(), multiUpward = machine.getUpwardsFacing(), flipped = machine.isFlipped())).m_123304_(relativeDown.m_122434_());
        if (belowControllerY == (partY = partPos.m_123304_(relativeDown.m_122434_()))) {
            IRecipeLogicMachine rlm;
            if (controller instanceof IRecipeLogicMachine && (rlm = (IRecipeLogicMachine)((Object)controller)).getRecipeLogic().isWorking()) {
                BoilerMultiPartRender.emitQuads(quads, this.fireboxActiveModel, (BlockAndTintGetter)machine.getLevel(), partPos, this.fireboxActive, side, rand, modelData, renderType);
            } else {
                BoilerMultiPartRender.emitQuads(quads, this.fireboxIdleModel, (BlockAndTintGetter)machine.getLevel(), partPos, this.fireboxIdle, side, rand, modelData, renderType);
            }
        } else {
            BoilerMultiPartRender.emitQuads(quads, this.casingModel, (BlockAndTintGetter)machine.getLevel(), partPos, this.casing, side, rand, modelData, renderType);
        }
    }

    private static void emitQuads(List<BakedQuad> quads, @Nullable BakedModel model, BlockAndTintGetter level, BlockPos pos, BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        if (model == null) {
            return;
        }
        modelData = model.getModelData(level, pos, state, modelData);
        quads.addAll(model.getQuads(state, side, rand, modelData, renderType));
    }

    @Generated
    public BlockState getFireboxIdle() {
        return this.fireboxIdle;
    }

    @Generated
    public BlockState getFireboxActive() {
        return this.fireboxActive;
    }

    @Generated
    public BlockState getCasing() {
        return this.casing;
    }
}

