/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model.machine;

import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.client.model.machine.MachineModel;
import com.gregtechceu.gtceu.client.model.machine.MachineModelLoader;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.client.model.machine.multipart.MultiPartBakedModel;
import com.gregtechceu.gtceu.client.model.machine.multipart.MultiPartUnbakedModel;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;

public class UnbakedMachineModel
implements IUnbakedGeometry<UnbakedMachineModel> {
    private final MachineDefinition definition;
    private final Map<MachineRenderState, UnbakedModel> models;
    @Nullable
    private final MultiPartUnbakedModel multiPart;
    private final List<DynamicRender<?, ?>> dynamicRenders;
    private final Set<String> replaceableTextures;
    private final Map<String, ResourceLocation> textureOverrides;

    public UnbakedMachineModel(MachineDefinition definition, Map<MachineRenderState, UnbakedModel> models, @Nullable MultiPartUnbakedModel multiPart, List<DynamicRender<?, ?>> dynamicRenders, Set<String> replaceableTextures, Map<String, ResourceLocation> textureOverrides) {
        this.definition = definition;
        this.models = models;
        this.multiPart = multiPart;
        this.dynamicRenders = dynamicRenders;
        this.replaceableTextures = replaceableTextures;
        this.textureOverrides = textureOverrides;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        HashMap<String, TextureAtlasSprite> textureOverrides = new HashMap<String, TextureAtlasSprite>();
        for (Map.Entry<String, ResourceLocation> entry : this.textureOverrides.entrySet()) {
            Material material = new Material(TextureAtlas.f_118259_, entry.getValue());
            textureOverrides.put(entry.getKey(), spriteGetter.apply(material));
        }
        IdentityHashMap<MachineRenderState, BakedModel> baseModels = new IdentityHashMap<MachineRenderState, BakedModel>();
        this.models.forEach((machineState, unbaked) -> baseModels.put((MachineRenderState)((Object)machineState), unbaked.m_7611_(baker, spriteGetter, modelState, modelLocation)));
        MultiPartBakedModel multiPart = this.multiPart == null ? null : this.multiPart.bake(baker, spriteGetter, modelState, modelLocation);
        MachineModel model = new MachineModel(this.getDefinition(), baseModels, multiPart, this.dynamicRenders, context.getTransforms(), context.getRootTransform(), modelState, context.isGui3d(), context.useBlockLight(), context.useAmbientOcclusion());
        if (context.hasMaterial("particle")) {
            model.setParticleIcon(spriteGetter.apply(context.getMaterial("particle")));
        }
        model.setReplaceableTextures(this.replaceableTextures);
        model.setTextureOverrides(textureOverrides);
        return model;
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> resolver, IGeometryBakingContext context) {
        MachineModelLoader.resolveStateModels(this, resolver);
    }

    @Generated
    public MachineDefinition getDefinition() {
        return this.definition;
    }

    @Generated
    public Map<MachineRenderState, UnbakedModel> getModels() {
        return this.models;
    }

    @Nullable
    @Generated
    public MultiPartUnbakedModel getMultiPart() {
        return this.multiPart;
    }

    @Generated
    public List<DynamicRender<?, ?>> getDynamicRenders() {
        return this.dynamicRenders;
    }
}

