/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.client.model.BaseBakedModel;
import com.gregtechceu.gtceu.client.model.IBlockEntityRendererBakedModel;
import com.gregtechceu.gtceu.client.model.TextureOverrideModel;
import com.gregtechceu.gtceu.client.model.machine.IControllerModelRenderer;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.client.model.machine.multipart.MultiPartBakedModel;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverableRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import com.gregtechceu.gtceu.common.data.models.GTModels;
import com.lowdragmc.lowdraglib.client.model.custommodel.CustomBakedModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MachineModel
extends BaseBakedModel
implements ICoverableRenderer,
IBlockEntityRendererBakedModel<BlockEntity> {
    public static final ResourceLocation PIPE_OVERLAY = GTCEu.id("block/overlay/machine/overlay_pipe");
    public static final ResourceLocation FLUID_OUTPUT_OVERLAY = GTCEu.id("block/overlay/machine/overlay_fluid_output");
    public static final ResourceLocation ITEM_OUTPUT_OVERLAY = GTCEu.id("block/overlay/machine/overlay_item_output");
    @Nullable
    private static TextureAtlasSprite pipeOverlaySprite;
    @Nullable
    private static TextureAtlasSprite fluidOutputOverlaySprite;
    @Nullable
    private static TextureAtlasSprite itemOutputOverlaySprite;
    @Nullable
    private static TextureAtlasSprite blankSprite;
    public static final Map<String, List<String>> TEXTURE_REMAPS;
    private final MachineDefinition definition;
    private final Map<MachineRenderState, BakedModel> modelsByState;
    @Nullable
    private final MultiPartBakedModel multiPart;
    private final List<DynamicRender<?, ?>> dynamicRenders;
    private final ItemTransforms transforms;
    private final Transformation rootTransform;
    private final ModelState modelState;
    private final boolean isGui3d;
    private final boolean usesBlockLight;
    private final boolean useAmbientOcclusion;
    private TextureAtlasSprite particleIcon = null;
    private Set<String> replaceableTextures;
    private Map<String, TextureAtlasSprite> textureOverrides;

    public MachineModel(MachineDefinition definition, Map<MachineRenderState, BakedModel> modelsByState, @Nullable MultiPartBakedModel multiPart, List<DynamicRender<?, ?>> dynamicRenders, ItemTransforms transforms, Transformation rootTransform, ModelState modelState, boolean isGui3d, boolean usesBlockLight, boolean useAmbientOcclusion) {
        this.definition = definition;
        this.modelsByState = modelsByState;
        this.multiPart = multiPart;
        this.dynamicRenders = dynamicRenders;
        this.transforms = transforms;
        this.rootTransform = rootTransform;
        this.modelState = modelState;
        this.isGui3d = isGui3d;
        this.usesBlockLight = usesBlockLight;
        this.useAmbientOcclusion = useAmbientOcclusion;
        for (DynamicRender<?, ?> render : this.dynamicRenders) {
            render.setParent(this);
        }
    }

    public static void initSprites(TextureAtlas atlas) {
        pipeOverlaySprite = atlas.m_118316_(PIPE_OVERLAY);
        fluidOutputOverlaySprite = atlas.m_118316_(FLUID_OUTPUT_OVERLAY);
        itemOutputOverlaySprite = atlas.m_118316_(ITEM_OUTPUT_OVERLAY);
        blankSprite = atlas.m_118316_(GTModels.BLANK_TEXTURE);
    }

    @Override
    @NotNull
    public TextureAtlasSprite m_6160_() {
        if (this.particleIcon != null) {
            return this.particleIcon;
        }
        if (this.multiPart != null) {
            return this.multiPart.m_6160_();
        }
        if (!this.modelsByState.isEmpty()) {
            return this.modelsByState.get((Object)this.getDefinition().defaultRenderState()).m_6160_();
        }
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(MissingTextureAtlasSprite.m_118071_());
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData modelData) {
        MachineRenderState renderState;
        BlockAndTintGetter level = (BlockAndTintGetter)modelData.get(IMachineBlockEntity.MODEL_DATA_LEVEL);
        BlockPos pos = (BlockPos)modelData.get(IMachineBlockEntity.MODEL_DATA_POS);
        MetaMachine machine = level == null || pos == null ? null : MetaMachine.getMachine((BlockGetter)level, pos);
        MachineRenderState machineRenderState = renderState = machine != null ? machine.getRenderState() : this.getDefinition().defaultRenderState();
        if (this.multiPart != null) {
            return this.multiPart.getParticleIcon(renderState, modelData);
        }
        if (this.modelsByState.containsKey((Object)renderState)) {
            return this.modelsByState.get((Object)renderState).getParticleIcon(modelData);
        }
        return super.getParticleIcon(modelData);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        MachineRenderState renderState;
        ModelData.Builder builder = modelData.derive().with(IMachineBlockEntity.MODEL_DATA_LEVEL, (Object)level).with(IMachineBlockEntity.MODEL_DATA_POS, (Object)pos);
        MetaMachine machine = MetaMachine.getMachine((BlockGetter)level, pos);
        MachineRenderState machineRenderState = renderState = machine == null ? this.definition.defaultRenderState() : machine.getRenderState();
        if (this.multiPart != null) {
            this.multiPart.addMachineModelData(renderState, level, pos, state, modelData, builder);
        }
        if (this.modelsByState.containsKey((Object)renderState)) {
            ModelData data = this.modelsByState.get((Object)renderState).getModelData(level, pos, state, modelData);
            for (ModelProperty key : data.getProperties()) {
                builder.with(key, data.get(key));
            }
        }
        return builder.build();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        IQuadTransformer postTransform = QuadTransformers.empty();
        if (!this.rootTransform.isIdentity()) {
            postTransform = UnbakedGeometryHelper.applyRootTransform((ModelState)this.modelState, (Transformation)this.rootTransform);
        }
        List<BakedQuad> quads = modelData.has(IMachineBlockEntity.MODEL_DATA_LEVEL) && modelData.has(IMachineBlockEntity.MODEL_DATA_POS) ? this.getMachineQuads(state, side, rand, modelData, renderType) : this.renderMachine(null, null, null, state, side, rand, modelData, renderType);
        postTransform.processInPlace(quads);
        return quads;
    }

    public List<BakedQuad> getMachineQuads(@Nullable BlockState blockState, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        IAutoOutputFluid autoOutputFluid;
        Direction fluidFace;
        IAutoOutputItem autoOutputItem;
        Direction itemFace;
        BlockAndTintGetter level = (BlockAndTintGetter)modelData.get(IMachineBlockEntity.MODEL_DATA_LEVEL);
        BlockPos pos = (BlockPos)modelData.get(IMachineBlockEntity.MODEL_DATA_POS);
        MetaMachine machine = level == null || pos == null ? null : MetaMachine.getMachine((BlockGetter)level, pos);
        List<BakedQuad> quads = this.renderMachine(machine, level, pos, blockState, side, rand, modelData, renderType);
        if (machine == null) {
            return quads;
        }
        if (machine instanceof IAutoOutputItem && (itemFace = (autoOutputItem = (IAutoOutputItem)((Object)machine)).getOutputFacingItems()) != null && side == itemFace) {
            quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.OUTPUT_OVERLAY, side, pipeOverlaySprite));
            if (autoOutputItem.isAutoOutputItems()) {
                quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.AUTO_OUTPUT_OVERLAY, side, itemOutputOverlaySprite));
            }
        }
        if (machine instanceof IAutoOutputFluid && (fluidFace = (autoOutputFluid = (IAutoOutputFluid)((Object)machine)).getOutputFacingFluids()) != null && side == fluidFace) {
            quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.OUTPUT_OVERLAY, side, pipeOverlaySprite));
            if (autoOutputFluid.isAutoOutputFluids()) {
                quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.AUTO_OUTPUT_OVERLAY, side, fluidOutputOverlaySprite));
            }
        }
        ICoverableRenderer.super.renderCovers(quads, machine.getCoverContainer(), pos, level, side, rand, modelData, renderType);
        return quads;
    }

    public List<BakedQuad> renderMachine(@Nullable MetaMachine machine, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @Nullable BlockState blockState, @Nullable Direction side, RandomSource rand, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        IMultiPart part;
        List<BakedQuad> quads = new LinkedList<BakedQuad>();
        MachineRenderState renderState = machine != null ? machine.getRenderState() : this.definition.defaultRenderState();
        this.renderBaseModel(quads, renderState, blockState, side, rand, modelData, renderType);
        for (DynamicRender<?, ?> render : this.dynamicRenders) {
            quads.addAll(render.getRenderQuads(machine, level, pos, blockState, side, rand, modelData, renderType));
        }
        if (machine instanceof IMultiPart && (part = (IMultiPart)((Object)machine)).replacePartModelWhenFormed()) {
            quads = this.replacePartBaseModel(quads, part, machine.getFrontFacing(), side, rand, modelData, renderType);
        }
        if (level != null && pos != null && blockState != null) {
            return CustomBakedModel.reBakeCustomQuads(quads, (BlockAndTintGetter)level, (BlockPos)pos, (BlockState)blockState, (Direction)side, (float)0.0f);
        }
        return quads;
    }

    public void renderBaseModel(List<BakedQuad> quads, @NotNull MachineRenderState renderState, @Nullable BlockState blockState, @Nullable Direction side, RandomSource rand, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        if (this.multiPart != null) {
            quads.addAll(this.multiPart.getMachineQuads(this.definition, renderState, blockState, side, rand, modelData, renderType));
        }
        if (this.modelsByState.containsKey((Object)renderState)) {
            quads.addAll(this.modelsByState.get((Object)renderState).getQuads(blockState, side, rand, modelData, renderType));
        }
    }

    public List<BakedQuad> replacePartBaseModel(List<BakedQuad> originalQuads, IMultiPart part, Direction frontFacing, @Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        SortedSet<IMultiController> controllers = part.getControllers();
        for (IMultiController controller : controllers) {
            BlockState state = controller.self().getBlockState();
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
            List<BakedQuad> newQuads = null;
            if (model instanceof IControllerModelRenderer) {
                IControllerModelRenderer controllerRenderer = (IControllerModelRenderer)model;
                controllerRenderer.renderPartModel(originalQuads, controller, part, frontFacing, side, rand, modelData, renderType);
            } else if (model instanceof MachineModel) {
                MachineModel controllerModel = (MachineModel)model;
                newQuads = this.renderPartOverrides(controllerModel, controller, originalQuads, part, frontFacing, side, rand, modelData, renderType);
            }
            if (newQuads == null) continue;
            return newQuads;
        }
        return originalQuads;
    }

    public List<String> remapReplaceableTextures(String key) {
        if (this.replaceableTextures.contains(key)) {
            return Collections.singletonList(key);
        }
        List<String> remapped = TEXTURE_REMAPS.get(key);
        if (remapped != null) {
            return remapped;
        }
        return Collections.emptyList();
    }

    private List<BakedQuad> renderPartOverrides(MachineModel controllerModel, IMultiController controller, List<BakedQuad> quads, IMultiPart part, Direction frontFacing, @Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        Map<String, TextureAtlasSprite> overrides = controllerModel.textureOverrides;
        LinkedList<BakedQuad> renderQuads = new LinkedList<BakedQuad>();
        for (DynamicRender<?, ?> render : controllerModel.getDynamicRenders()) {
            if (!(render instanceof IControllerModelRenderer)) continue;
            IControllerModelRenderer controllerRenderer = (IControllerModelRenderer)((Object)render);
            controllerRenderer.renderPartModel(renderQuads, controller, part, frontFacing, side, rand, modelData, renderType);
            if (renderQuads.isEmpty()) continue;
            overrides = new HashMap<String, TextureAtlasSprite>();
            for (String key2 : this.replaceableTextures) {
                overrides.put(key2, blankSprite);
            }
        }
        if (overrides.isEmpty()) {
            quads.addAll(renderQuads);
            return quads;
        }
        IdentityHashMap remaps = new IdentityHashMap();
        TextureAtlasSprite missingno = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
        Map<String, TextureAtlasSprite> finalOverrides = overrides;
        overrides = finalOverrides.keySet().stream().flatMap(key -> {
            List<String> remapped = this.remapReplaceableTextures((String)key);
            for (String r : remapped) {
                remaps.put(r, key);
            }
            return remapped.stream();
        }).collect(Collectors.toMap(Function.identity(), key -> finalOverrides.getOrDefault(remaps.get(key), missingno), (o1, o2) -> o1));
        quads = TextureOverrideModel.retextureQuads(quads, overrides);
        quads.addAll(renderQuads);
        return quads;
    }

    @Override
    public boolean m_7521_() {
        return true;
    }

    @Override
    public void m_6922_(@NotNull BlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (!(blockEntity instanceof IMachineBlockEntity)) {
            return;
        }
        IMachineBlockEntity machineBE = (IMachineBlockEntity)blockEntity;
        if (machineBE.getDefinition() != this.getDefinition()) {
            return;
        }
        ICoverableRenderer.super.renderDynamicCovers(machineBE.getMetaMachine(), partialTick, poseStack, buffer, packedLight, packedOverlay);
        if (this.dynamicRenders.isEmpty()) {
            return;
        }
        MetaMachine machine = machineBE.getMetaMachine();
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        for (DynamicRender<?, ?> model : this.dynamicRenders) {
            if (!model.shouldRender(machine, cameraPos)) continue;
            model.render(machine, partialTick, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    @Override
    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (this.dynamicRenders.isEmpty()) {
            return;
        }
        for (DynamicRender<?, ?> model : this.dynamicRenders) {
            model.renderByItem(stack, displayContext, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    @Override
    public AABB getRenderBoundingBox(BlockEntity blockEntity) {
        AABB bounds = IBlockEntityRendererBakedModel.super.getRenderBoundingBox(blockEntity);
        if (!(blockEntity instanceof IMachineBlockEntity)) {
            return bounds;
        }
        IMachineBlockEntity machineBE = (IMachineBlockEntity)blockEntity;
        if (machineBE.getDefinition() != this.getDefinition()) {
            return bounds;
        }
        if (this.dynamicRenders.isEmpty()) {
            return bounds;
        }
        MetaMachine machine = machineBE.getMetaMachine();
        for (DynamicRender<?, ?> model : this.dynamicRenders) {
            bounds = bounds.m_82367_(model.getRenderBoundingBox(machine));
        }
        return bounds;
    }

    public boolean m_5932_(BlockEntity blockEntity) {
        if (!(blockEntity instanceof IMachineBlockEntity)) {
            return false;
        }
        IMachineBlockEntity machineBE = (IMachineBlockEntity)blockEntity;
        if (machineBE.getDefinition() != this.getDefinition()) {
            return false;
        }
        if (this.dynamicRenders.isEmpty()) {
            return false;
        }
        MetaMachine machine = machineBE.getMetaMachine();
        for (DynamicRender<?, ?> render : this.dynamicRenders) {
            if (!render.shouldRenderOffScreen(machine)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean m_142756_(BlockEntity blockEntity, @NotNull Vec3 cameraPos) {
        if (!(blockEntity instanceof IMachineBlockEntity)) {
            return false;
        }
        IMachineBlockEntity machineBE = (IMachineBlockEntity)blockEntity;
        if (machineBE.getDefinition() != this.getDefinition()) {
            return false;
        }
        if (machineBE.getMetaMachine().getCoverContainer().hasDynamicCovers()) {
            return true;
        }
        if (this.dynamicRenders.isEmpty()) {
            return false;
        }
        MetaMachine machine = machineBE.getMetaMachine();
        for (DynamicRender<?, ?> model : this.dynamicRenders) {
            if (!model.shouldRender(machine, Minecraft.m_91087_().f_91063_.m_109153_().m_90583_())) continue;
            return true;
        }
        return false;
    }

    public int m_142163_() {
        int distance = 0;
        for (DynamicRender<?, ?> model : this.dynamicRenders) {
            distance = Math.max(distance, model.getViewDistance());
        }
        return distance;
    }

    @Override
    public BlockEntityType<? extends BlockEntity> getBlockEntityType() {
        return this.getDefinition().getBlockEntityType();
    }

    @Generated
    public MachineDefinition getDefinition() {
        return this.definition;
    }

    @Generated
    public List<DynamicRender<?, ?>> getDynamicRenders() {
        return this.dynamicRenders;
    }

    @Generated
    public ItemTransforms m_7442_() {
        return this.transforms;
    }

    @Override
    @Generated
    public boolean m_7539_() {
        return this.isGui3d;
    }

    @Override
    @Generated
    public boolean m_7547_() {
        return this.usesBlockLight;
    }

    @Override
    @Generated
    public boolean m_7541_() {
        return this.useAmbientOcclusion;
    }

    @Generated
    public void setParticleIcon(TextureAtlasSprite particleIcon) {
        this.particleIcon = particleIcon;
    }

    @Generated
    public void setReplaceableTextures(Set<String> replaceableTextures) {
        this.replaceableTextures = replaceableTextures;
    }

    @Generated
    public void setTextureOverrides(Map<String, TextureAtlasSprite> textureOverrides) {
        this.textureOverrides = textureOverrides;
    }

    static {
        TEXTURE_REMAPS = (Map)Util.m_137469_(new HashMap(), map -> {
            List<String> all = List.of("all");
            map.put("side", all);
            map.put("top", all);
            map.put("bottom", all);
            map.put("all", List.of("side", "top", "bottom"));
        });
    }
}

