/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.modifier;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class RecipeModifierList
implements RecipeModifier {
    private final RecipeModifier[] modifiers;

    public RecipeModifierList(RecipeModifier ... modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public ModifierFunction getModifier(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        ModifierFunction result = ModifierFunction.IDENTITY;
        GTRecipe runningRecipe = recipe;
        for (RecipeModifier modifier : this.modifiers) {
            ModifierFunction func = modifier.getModifier(machine, runningRecipe);
            if ((runningRecipe = func.apply(runningRecipe)) == null) {
                return ModifierFunction.NULL;
            }
            result = func.compose(result);
        }
        return result;
    }

    @Generated
    public RecipeModifier[] getModifiers() {
        return this.modifiers;
    }
}

