/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.lookup;

import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.AbstractMapIngredient;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class RecipeIterator
implements Iterator<GTRecipe> {
    int index;
    List<List<AbstractMapIngredient>> ingredients;
    @NotNull
    GTRecipeType recipeMap;
    @NotNull
    Predicate<GTRecipe> canHandle;

    RecipeIterator(@NotNull GTRecipeType recipeMap, List<List<AbstractMapIngredient>> ingredients, @NotNull Predicate<GTRecipe> canHandle) {
        this.ingredients = ingredients;
        this.recipeMap = recipeMap;
        this.canHandle = canHandle;
    }

    @Override
    public boolean hasNext() {
        return this.ingredients != null && this.index < this.ingredients.size();
    }

    @Override
    public GTRecipe next() {
        if (this.ingredients == null) {
            return null;
        }
        GTRecipe r = null;
        while (this.index < this.ingredients.size()) {
            BitSet skipSet = new BitSet();
            skipSet.set(this.index);
            r = this.recipeMap.getLookup().recurseIngredientTreeFindRecipe(this.ingredients, this.recipeMap.getLookup().getLookup(), this.canHandle, this.index, 0, skipSet);
            ++this.index;
            if (r == null) continue;
            break;
        }
        return r;
    }

    public void reset() {
        this.index = 0;
    }
}

