/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class IntProviderFluidIngredient
extends FluidIngredient {
    public static final Codec<IntProviderFluidIngredient> CODEC = ExtraCodecs.f_252400_.xmap(IntProviderFluidIngredient::fromJson, IntProviderFluidIngredient::toJson);
    private final IntProvider countProvider;
    protected int sampledCount = -1;
    private final FluidIngredient inner;
    protected FluidStack[] fluidStacks = null;

    protected IntProviderFluidIngredient(FluidIngredient inner, IntProvider provider) {
        super(inner.values, provider.m_142737_(), null);
        this.inner = inner;
        this.countProvider = provider;
    }

    @Override
    public IntProviderFluidIngredient copy() {
        IntProviderFluidIngredient ipfi = new IntProviderFluidIngredient(this.inner, this.countProvider);
        ipfi.setSampledCount(this.sampledCount);
        return ipfi;
    }

    @Override
    @Deprecated
    public int getAmount() {
        if (ConfigHolder.INSTANCE.dev.debug) {
            throw new IllegalCallerException("An IPFI should never have getAmount() called on it!");
        }
        return -1;
    }

    @Override
    public FluidStack[] getStacks() {
        if (this.fluidStacks == null) {
            int cachedAmount = this.getSampledCount(GTValues.RNG);
            if (cachedAmount == 0) {
                return EMPTY_STACK_ARRAY;
            }
            FluidStack[] innerStacks = this.inner.getStacks();
            this.fluidStacks = new FluidStack[innerStacks.length];
            for (int i = 0; i < this.fluidStacks.length; ++i) {
                this.fluidStacks[i] = innerStacks[i].copy();
                this.fluidStacks[i].setAmount(cachedAmount);
            }
        }
        return this.fluidStacks;
    }

    @NotNull
    public FluidStack getMaxSizeStack() {
        FluidStack[] in = this.inner.getStacks();
        if (in.length == 0) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(in[0], this.countProvider.m_142737_());
    }

    public int getSampledCount() {
        return this.getSampledCount(GTValues.RNG);
    }

    public int getSampledCount(@NotNull RandomSource random) {
        if (this.sampledCount == -1) {
            this.sampledCount = this.countProvider.m_214085_(random);
        }
        return this.sampledCount;
    }

    public double getMidRoll() {
        return (double)(this.countProvider.m_142737_() + this.countProvider.m_142739_()) / 2.0;
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    public static IntProviderFluidIngredient of(FluidIngredient inner, IntProvider provider) {
        return new IntProviderFluidIngredient(inner, provider);
    }

    public static IntProviderFluidIngredient of(FluidStack inner, int min, int max) {
        return IntProviderFluidIngredient.of(FluidIngredient.of(inner), (IntProvider)UniformInt.m_146622_((int)min, (int)max));
    }

    @Override
    @NotNull
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.add("count_provider", (JsonElement)IntProvider.f_146531_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.countProvider).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0)));
        json.add("inner", this.inner.toJson());
        return json;
    }

    public static IntProviderFluidIngredient fromJson(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Fluid ingredient cannot be null");
        }
        JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)json, (String)"ingredient");
        IntProvider amount = (IntProvider)IntProvider.f_146531_.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("count_provider")).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
        FluidIngredient inner = FluidIngredient.fromJson(jsonObject.get("inner"));
        return new IntProviderFluidIngredient(inner, amount);
    }

    public CompoundTag toNBT() {
        return (CompoundTag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, this.toJson());
    }

    public static IntProviderFluidIngredient fromNBT(CompoundTag nbt) {
        return IntProviderFluidIngredient.fromJson((JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)nbt));
    }

    @Generated
    public IntProvider getCountProvider() {
        return this.countProvider;
    }

    @Generated
    public void setSampledCount(int sampledCount) {
        this.sampledCount = sampledCount;
    }

    @Generated
    public FluidIngredient getInner() {
        return this.inner;
    }

    @Generated
    public void setFluidStacks(FluidStack[] fluidStacks) {
        this.fluidStacks = fluidStacks;
    }
}

