/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.recipe.ActionResult;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.sound.AutoReleasedSound;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.common.cover.MachineControllerCover;
import com.gregtechceu.gtceu.utils.GTMath;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.UpdateListener;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class RecipeLogic
extends MachineTrait
implements IEnhancedManaged,
IWorkable,
IFancyTooltip {
    public static final EnumProperty<Status> STATUS_PROPERTY = GTMachineModelProperties.RECIPE_LOGIC_STATUS;
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(RecipeLogic.class);
    public final IRecipeLogicMachine machine;
    public List<GTRecipe> lastFailedMatches;
    @Persisted
    @DescSynced
    @UpdateListener(methodName="onStatusSynced")
    private Status status = Status.IDLE;
    @Persisted
    @DescSynced
    @UpdateListener(methodName="onActiveSynced")
    protected boolean isActive;
    @Persisted
    @DescSynced
    @Nullable
    private Component waitingReason = null;
    @Persisted
    @DescSynced
    @Nullable
    protected GTRecipe lastRecipe;
    @Persisted
    @DescSynced
    protected int consecutiveRecipes = 0;
    @Persisted
    @Nullable
    protected GTRecipe lastOriginRecipe;
    @Persisted
    @DescSynced
    protected int progress;
    @Persisted
    @DescSynced
    protected int duration;
    protected boolean recipeDirty;
    @Persisted
    protected long totalContinuousRunningTime;
    protected int runAttempt = 0;
    protected int runDelay = 0;
    @Persisted
    protected boolean suspendAfterFinish = false;
    protected final Map<RecipeCapability<?>, Object2IntMap<?>> chanceCaches = this.makeChanceCaches();
    protected TickableSubscription subscription;
    protected Object workingSound;

    public RecipeLogic(IRecipeLogicMachine machine) {
        super(machine.self());
        this.machine = machine;
    }

    protected void onStatusSynced(Status newValue, Status oldValue) {
        this.scheduleRenderUpdate();
        this.updateSound();
    }

    protected void onActiveSynced(boolean newActive, boolean oldActive) {
        this.scheduleRenderUpdate();
    }

    public void resetRecipeLogic() {
        this.recipeDirty = false;
        this.lastRecipe = null;
        this.lastOriginRecipe = null;
        this.consecutiveRecipes = 0;
        this.progress = 0;
        this.duration = 0;
        this.isActive = false;
        this.lastFailedMatches = null;
        if (this.status != Status.SUSPEND) {
            this.setStatus(Status.IDLE);
        }
        this.updateTickSubscription();
    }

    @Override
    public void onMachineLoad() {
        super.onMachineLoad();
        this.updateTickSubscription();
    }

    public void updateTickSubscription() {
        if (this.isSuspend() || !this.machine.isRecipeLogicAvailable()) {
            if (this.subscription != null) {
                this.subscription.unsubscribe();
                this.subscription = null;
            }
        } else {
            this.subscription = this.getMachine().subscribeServerTick(this.subscription, this::serverTick);
        }
    }

    public double getProgressPercent() {
        return this.duration == 0 ? 0.0 : (double)this.progress / ((double)this.duration * 1.0);
    }

    public RecipeManager getRecipeManager() {
        return GTCEu.getMinecraftServer().m_129894_();
    }

    public void serverTick() {
        if (!this.isSuspend()) {
            if (!this.isIdle() && this.lastRecipe != null) {
                if (this.progress < this.duration) {
                    if (this.runDelay > 0) {
                        --this.runDelay;
                    } else {
                        this.handleRecipeWorking();
                    }
                }
                if (this.progress >= this.duration) {
                    this.onRecipeFinish();
                }
            } else if (this.lastRecipe != null) {
                this.findAndHandleRecipe();
            } else if (!this.machine.keepSubscribing() || this.getMachine().getOffsetTimer() % 5L == 0L) {
                this.findAndHandleRecipe();
                if (this.lastFailedMatches != null) {
                    for (GTRecipe match : this.lastFailedMatches) {
                        if (this.checkMatchedRecipeAvailable(match)) break;
                    }
                }
            }
        }
        boolean unsubscribe = false;
        if (this.isSuspend()) {
            unsubscribe = true;
        } else if (this.lastRecipe == null && this.isIdle() && !this.machine.keepSubscribing() && !this.recipeDirty && this.lastFailedMatches == null) {
            unsubscribe = true;
        }
        if (unsubscribe && this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }

    protected ActionResult matchRecipe(GTRecipe recipe) {
        return RecipeHelper.matchContents(this.machine, recipe);
    }

    protected ActionResult checkRecipe(GTRecipe recipe) {
        ActionResult conditionResult = RecipeHelper.checkConditions(recipe, this);
        if (!conditionResult.isSuccess()) {
            return conditionResult;
        }
        return this.matchRecipe(recipe);
    }

    public boolean checkMatchedRecipeAvailable(GTRecipe match) {
        GTRecipe modified = this.machine.fullModifyRecipe(match);
        if (modified != null) {
            ActionResult recipeMatch = this.checkRecipe(modified);
            if (recipeMatch.isSuccess()) {
                this.setupRecipe(modified);
            }
            if (this.lastRecipe != null && this.getStatus() == Status.WORKING) {
                this.lastOriginRecipe = match;
                this.lastFailedMatches = null;
                return true;
            }
        }
        return false;
    }

    public void handleRecipeWorking() {
        assert (this.lastRecipe != null);
        ActionResult conditionResult = RecipeHelper.checkConditions(this.lastRecipe, this);
        if (conditionResult.isSuccess()) {
            ActionResult handleTick = this.handleTickRecipe(this.lastRecipe);
            if (handleTick.isSuccess()) {
                this.setStatus(Status.WORKING);
                if (!this.machine.onWorking()) {
                    this.interruptRecipe();
                    return;
                }
                ++this.progress;
                ++this.totalContinuousRunningTime;
            } else {
                this.setWaiting(handleTick.reason());
                if (handleTick.io() == IO.IN && handleTick.capability() == EURecipeCapability.CAP) {
                    ++this.runAttempt;
                    this.runAttempt = (int)GTMath.clamp(this.runAttempt, 0L, 5L);
                    if (this.runAttempt == 5) {
                        boolean preventPowerFail = false;
                        if (this.machine.self() instanceof IMultiController) {
                            List<CoverBehavior> covers = this.machine.self().getCoverContainer().getCovers();
                            for (CoverBehavior cover : covers) {
                                MachineControllerCover mcc;
                                if (!(cover instanceof MachineControllerCover) || !(mcc = (MachineControllerCover)cover).preventPowerFail()) continue;
                                preventPowerFail = true;
                                break;
                            }
                        }
                        if (this.machine.self() instanceof IMultiController && !preventPowerFail) {
                            this.runAttempt = 0;
                            this.setStatus(Status.SUSPEND);
                        }
                    }
                    this.runDelay = this.runAttempt * 60;
                }
            }
        } else {
            this.setWaiting(conditionResult.reason());
        }
        if (this.isWaiting()) {
            this.regressRecipe();
        }
    }

    protected void regressRecipe() {
        if (this.progress > 0 && this.machine.regressWhenWaiting()) {
            this.progress = 1;
        }
    }

    @NotNull
    public Iterator<GTRecipe> searchRecipe() {
        return this.machine.getRecipeType().searchRecipe(this.machine, r -> this.matchRecipe((GTRecipe)r).isSuccess());
    }

    public void findAndHandleRecipe() {
        this.lastFailedMatches = null;
        if (!this.recipeDirty && this.lastRecipe != null && this.checkRecipe(this.lastRecipe).isSuccess()) {
            GTRecipe recipe = this.lastRecipe;
            this.lastRecipe = null;
            this.lastOriginRecipe = null;
            this.setupRecipe(recipe);
        } else {
            this.lastRecipe = null;
            this.lastOriginRecipe = null;
            this.handleSearchingRecipes(this.searchRecipe());
        }
        this.recipeDirty = false;
    }

    protected void handleSearchingRecipes(@NotNull Iterator<GTRecipe> matches) {
        while (matches.hasNext()) {
            GTRecipe match = matches.next();
            if (match == null) continue;
            if (this.checkMatchedRecipeAvailable(match)) {
                return;
            }
            if (this.lastFailedMatches == null) {
                this.lastFailedMatches = new ArrayList<GTRecipe>();
            }
            this.lastFailedMatches.add(match);
        }
    }

    public ActionResult handleTickRecipe(GTRecipe recipe) {
        if (!recipe.hasTick()) {
            return ActionResult.SUCCESS;
        }
        ActionResult result = RecipeHelper.matchTickRecipe(this.machine, recipe);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handleTickRecipeIO(recipe, IO.IN);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handleTickRecipeIO(recipe, IO.OUT);
        return result;
    }

    public void setupRecipe(GTRecipe recipe) {
        if (!this.machine.beforeWorking(recipe)) {
            this.setStatus(Status.IDLE);
            this.consecutiveRecipes = 0;
            this.progress = 0;
            this.duration = 0;
            this.isActive = false;
            return;
        }
        ActionResult handledIO = this.handleRecipeIO(recipe, IO.IN);
        if (handledIO.isSuccess()) {
            if (this.lastRecipe != null && !recipe.equals(this.lastRecipe)) {
                this.chanceCaches.clear();
            }
            this.recipeDirty = false;
            this.lastRecipe = recipe;
            this.setStatus(Status.WORKING);
            this.progress = 0;
            this.duration = recipe.duration;
            this.isActive = true;
        }
    }

    public void setStatus(Status status) {
        if (this.status != status) {
            if (this.status == Status.WORKING) {
                this.totalContinuousRunningTime = 0L;
            }
            if (status == Status.SUSPEND && this.suspendAfterFinish) {
                this.suspendAfterFinish = false;
            }
            this.machine.notifyStatusChanged(this.status, status);
            this.status = status;
            this.setRenderState((MachineRenderState)((Object)this.getRenderState().m_61124_((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS, (Comparable)((Object)status))));
            this.updateTickSubscription();
            if (this.status != Status.WAITING) {
                this.waitingReason = null;
            }
        }
    }

    public void setWaiting(@Nullable Component reason) {
        this.setStatus(Status.WAITING);
        this.waitingReason = reason;
        this.machine.onWaiting();
    }

    public void markLastRecipeDirty() {
        this.recipeDirty = true;
    }

    public boolean isWorking() {
        return this.status == Status.WORKING;
    }

    public boolean isIdle() {
        return this.status == Status.IDLE;
    }

    public boolean isWaiting() {
        return this.status == Status.WAITING;
    }

    public boolean isSuspend() {
        return this.status == Status.SUSPEND;
    }

    @Override
    public boolean isWorkingEnabled() {
        return !this.isSuspend() && !this.isSuspendAfterFinish();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (!isWorkingAllowed && this.getStatus() == Status.IDLE) {
            this.setStatus(Status.SUSPEND);
        } else {
            this.setSuspendAfterFinish(!isWorkingAllowed);
            if (isWorkingAllowed) {
                if (this.lastRecipe != null && this.duration > 0) {
                    this.setStatus(Status.WORKING);
                } else {
                    this.setStatus(Status.IDLE);
                }
            }
        }
    }

    @Override
    public int getMaxProgress() {
        return this.duration;
    }

    @Override
    public boolean isActive() {
        return this.isWorking() || this.isWaiting() || this.isSuspend() && this.isActive;
    }

    public void onRecipeFinish() {
        this.machine.afterWorking();
        if (this.lastRecipe != null) {
            this.runAttempt = 0;
            this.runDelay = 0;
            ++this.consecutiveRecipes;
            this.handleRecipeIO(this.lastRecipe, IO.OUT);
            if (this.machine.alwaysTryModifyRecipe()) {
                if (this.lastOriginRecipe != null) {
                    GTRecipe modified = this.machine.fullModifyRecipe(this.lastOriginRecipe.copy());
                    if (modified == null) {
                        this.markLastRecipeDirty();
                    } else {
                        this.lastRecipe = modified;
                    }
                } else {
                    this.markLastRecipeDirty();
                }
            }
            ActionResult recipeCheck = this.checkRecipe(this.lastRecipe);
            if (!this.recipeDirty && !this.suspendAfterFinish && recipeCheck.isSuccess()) {
                this.setupRecipe(this.lastRecipe);
            } else {
                if (this.suspendAfterFinish) {
                    this.setStatus(Status.SUSPEND);
                } else {
                    this.setStatus(Status.IDLE);
                    if (recipeCheck.io() != IO.IN || recipeCheck.capability() == EURecipeCapability.CAP) {
                        this.waitingReason = recipeCheck.reason();
                    }
                }
                this.consecutiveRecipes = 0;
                this.progress = 0;
                this.duration = 0;
                this.isActive = false;
            }
        }
    }

    protected ActionResult handleRecipeIO(GTRecipe recipe, IO io) {
        return RecipeHelper.handleRecipeIO(this.machine, recipe, io, this.chanceCaches);
    }

    protected ActionResult handleTickRecipeIO(GTRecipe recipe, IO io) {
        return RecipeHelper.handleTickRecipeIO(this.machine, recipe, io, this.chanceCaches);
    }

    public void interruptRecipe() {
        this.machine.afterWorking();
        if (this.lastRecipe != null) {
            this.setStatus(Status.IDLE);
            this.progress = 0;
            this.duration = 0;
        }
    }

    public void inValid() {
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateSound() {
        if (this.isWorking() && this.machine.shouldWorkingPlaySound()) {
            SoundEntry sound = this.machine.getRecipeType().getSound();
            Object object = this.workingSound;
            if (object instanceof AutoReleasedSound) {
                AutoReleasedSound soundEntry = (AutoReleasedSound)((Object)object);
                if (soundEntry.soundEntry == sound && !soundEntry.m_7801_()) {
                    return;
                }
                soundEntry.release();
                this.workingSound = null;
            }
            if (sound != null) {
                this.workingSound = sound.playAutoReleasedSound(() -> this.machine.shouldWorkingPlaySound() && this.isWorking() && !this.getMachine().isInValid() && this.getMachine().getLevel().m_46749_(this.getMachine().getPos()) && MetaMachine.getMachine((BlockGetter)this.getMachine().getLevel(), this.getMachine().getPos()) == this.getMachine(), this.getMachine().getPos(), true, 0, 1.0f, 1.0f);
            }
        } else {
            Object object = this.workingSound;
            if (object instanceof AutoReleasedSound) {
                AutoReleasedSound soundEntry = (AutoReleasedSound)((Object)object);
                soundEntry.release();
                this.workingSound = null;
            }
        }
    }

    @Override
    public IGuiTexture getFancyTooltipIcon() {
        if (this.waitingReason != null) {
            return GuiTextures.INSUFFICIENT_INPUT;
        }
        return IGuiTexture.EMPTY;
    }

    @Override
    public List<Component> getFancyTooltip() {
        if (this.waitingReason != null) {
            return List.of(this.waitingReason);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean showFancyTooltip() {
        return this.waitingReason != null;
    }

    protected Map<RecipeCapability<?>, Object2IntMap<?>> makeChanceCaches() {
        IdentityHashMap map = new IdentityHashMap();
        for (RecipeCapability cap : GTRegistries.RECIPE_CAPABILITIES.values()) {
            map.put(cap, cap.makeChanceCache());
        }
        return map;
    }

    @Override
    public void saveCustomPersistedData(@NotNull CompoundTag tag, boolean forDrop) {
        super.saveCustomPersistedData(tag, forDrop);
        CompoundTag chanceCache = new CompoundTag();
        this.chanceCaches.forEach((cap, cache) -> {
            ListTag cacheTag = new ListTag();
            for (Object2IntMap.Entry entry : cache.object2IntEntrySet()) {
                CompoundTag compoundTag = new CompoundTag();
                Tag obj = cap.contentToNbt(entry.getKey());
                compoundTag.m_128365_("entry", obj);
                compoundTag.m_128405_("cached_chance", entry.getIntValue());
                cacheTag.add((Object)compoundTag);
            }
            chanceCache.m_128365_(cap.name, (Tag)cacheTag);
        });
        tag.m_128365_("chance_cache", (Tag)chanceCache);
    }

    @Override
    public void loadCustomPersistedData(@NotNull CompoundTag tag) {
        super.loadCustomPersistedData(tag);
        CompoundTag chanceCache = tag.m_128469_("chance_cache");
        for (String key : chanceCache.m_128431_()) {
            RecipeCapability cap2 = (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(key);
            if (cap2 == null) continue;
            Object2IntMap map = this.chanceCaches.computeIfAbsent(cap2, RecipeCapability::makeChanceCache);
            ListTag chanceTag = chanceCache.m_128437_(key, 10);
            for (int i = 0; i < chanceTag.size(); ++i) {
                CompoundTag chanceKey = chanceTag.m_128728_(i);
                Object entry = cap2.serializer.fromNbt(chanceKey.m_128423_("entry"));
                int value = chanceKey.m_128451_("cached_chance");
                map.put(entry, value);
            }
        }
        this.chanceCaches.forEach((cap, cache) -> {
            ListTag cacheTag = new ListTag();
            for (Object2IntMap.Entry entry : cache.object2IntEntrySet()) {
                CompoundTag compoundTag = new CompoundTag();
                Tag obj = cap.contentToNbt(entry.getKey());
                compoundTag.m_128365_("entry", obj);
                compoundTag.m_128405_("cached_chance", entry.getIntValue());
                cacheTag.add((Object)compoundTag);
            }
            chanceCache.m_128365_(cap.name, (Tag)cacheTag);
        });
        tag.m_128365_("chance_cache", (Tag)chanceCache);
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Nullable
    @Generated
    public GTRecipe getLastRecipe() {
        return this.lastRecipe;
    }

    @Generated
    public int getConsecutiveRecipes() {
        return this.consecutiveRecipes;
    }

    @Nullable
    @Generated
    public GTRecipe getLastOriginRecipe() {
        return this.lastOriginRecipe;
    }

    @Override
    @Generated
    public int getProgress() {
        return this.progress;
    }

    @Generated
    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Generated
    public int getDuration() {
        return this.duration;
    }

    @VisibleForTesting
    @Generated
    public boolean isRecipeDirty() {
        return this.recipeDirty;
    }

    @Generated
    public long getTotalContinuousRunningTime() {
        return this.totalContinuousRunningTime;
    }

    @Override
    @Generated
    public void setSuspendAfterFinish(boolean suspendAfterFinish) {
        this.suspendAfterFinish = suspendAfterFinish;
    }

    @Override
    @Generated
    public boolean isSuspendAfterFinish() {
        return this.suspendAfterFinish;
    }

    @Generated
    public Map<RecipeCapability<?>, Object2IntMap<?>> getChanceCaches() {
        return this.chanceCaches;
    }

    public static enum Status implements StringRepresentable
    {
        IDLE("idle"),
        WORKING("working"),
        WAITING("waiting"),
        SUSPEND("suspend");

        private final String serializedName;

        private Status(String name) {
            this.serializedName = name;
        }

        @Generated
        public String m_7912_() {
            return this.serializedName;
        }
    }
}

