/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.WorkableTieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IEnvironmentalHazardEmitter;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.api.recipe.ui.GTRecipeTypeUI;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.function.BiFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SimpleGeneratorMachine
extends WorkableTieredMachine
implements IFancyUIMachine,
IEnvironmentalHazardEmitter {
    private final float hazardStrengthPerOperation;
    public static BiFunction<ResourceLocation, GTRecipeType, EditableMachineUI> EDITABLE_UI_CREATOR = Util.m_143821_((path, recipeType) -> new EditableMachineUI("generator", (ResourceLocation)path, () -> {
        WidgetGroup template = recipeType.getRecipeUI().createEditableUITemplate(false, false).createDefault();
        WidgetGroup group = new WidgetGroup(0, 0, template.getSize().width + 4 + 8, template.getSize().height + 8);
        Size size = group.getSize();
        template.setSelfPosition(new Position((size.width - 4 - template.getSize().width) / 2 + 4, (size.height - template.getSize().height) / 2));
        group.addWidget((Widget)template);
        return group;
    }, (template, machine) -> {
        if (machine instanceof SimpleGeneratorMachine) {
            SimpleGeneratorMachine generatorMachine = (SimpleGeneratorMachine)machine;
            Table storages = Tables.newCustomTable(new EnumMap(IO.class), LinkedHashMap::new);
            storages.put((Object)IO.IN, (Object)ItemRecipeCapability.CAP, (Object)generatorMachine.importItems.storage);
            storages.put((Object)IO.OUT, (Object)ItemRecipeCapability.CAP, (Object)generatorMachine.exportItems.storage);
            storages.put((Object)IO.IN, (Object)FluidRecipeCapability.CAP, (Object)generatorMachine.importFluids);
            storages.put((Object)IO.OUT, (Object)FluidRecipeCapability.CAP, (Object)generatorMachine.exportFluids);
            generatorMachine.getRecipeType().getRecipeUI().createEditableUITemplate(false, false).setupUI((WidgetGroup)template, new GTRecipeTypeUI.RecipeHolder(generatorMachine.recipeLogic::getProgressPercent, storages, new CompoundTag(), Collections.emptyList(), false, false));
            SimpleGeneratorMachine.createEnergyBar().setupUI((WidgetGroup)template, generatorMachine);
        }
    }));

    public SimpleGeneratorMachine(IMachineBlockEntity holder, int tier, float hazardStrengthPerOperation, Int2IntFunction tankScalingFunction, Object ... args) {
        super(holder, tier, tankScalingFunction, args);
        this.hazardStrengthPerOperation = hazardStrengthPerOperation;
    }

    public SimpleGeneratorMachine(IMachineBlockEntity holder, int tier, Int2IntFunction tankScalingFunction, Object ... args) {
        this(holder, tier, 0.25f, tankScalingFunction, args);
    }

    @Override
    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        NotifiableEnergyContainer energyContainer = super.createEnergyContainer(args);
        energyContainer.setSideOutputCondition(side -> !this.hasFrontFacing() || side == this.getFrontFacing());
        return energyContainer;
    }

    @Override
    protected boolean isEnergyEmitter() {
        return true;
    }

    @Override
    public int tintColor(int index) {
        if (index == 2) {
            return GTValues.VC[this.getTier()];
        }
        return super.tintColor(index);
    }

    public static ModifierFunction recipeModifier(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        if (!(machine instanceof SimpleGeneratorMachine)) {
            return RecipeModifier.nullWrongType(SimpleGeneratorMachine.class, machine);
        }
        SimpleGeneratorMachine generator = (SimpleGeneratorMachine)machine;
        long EUt = recipe.getOutputEUt().getTotalEU();
        if (EUt <= 0L) {
            return ModifierFunction.NULL;
        }
        int maxParallel = (int)(generator.getOverclockVoltage() / EUt);
        int parallels = ParallelLogic.getParallelAmountFast(generator, recipe, maxParallel);
        return ModifierFunction.builder().inputModifier(ContentModifier.multiplier(parallels)).outputModifier(ContentModifier.multiplier(parallels)).eutMultiplier(parallels).parallels(parallels).build();
    }

    @Override
    public boolean regressWhenWaiting() {
        return false;
    }

    @Override
    public boolean canVoidRecipeOutputs(RecipeCapability<?> capability) {
        return capability != EURecipeCapability.CAP;
    }

    @Override
    public void afterWorking() {
        super.afterWorking();
        this.spreadEnvironmentalHazard();
    }

    @Override
    @Generated
    public float getHazardStrengthPerOperation() {
        return this.hazardStrengthPerOperation;
    }
}

