/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.block.property.GTBlockStateProperties;
import com.gregtechceu.gtceu.api.blockentity.IPaintable;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IToolable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IToolGridHighlight;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineCoverContainer;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IMufflableMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRedstoneSignalMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.misc.IOFilteredInvWrapper;
import com.gregtechceu.gtceu.api.misc.IOFluidHandlerList;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.client.util.ModelUtils;
import com.gregtechceu.gtceu.common.cover.FluidFilterCover;
import com.gregtechceu.gtceu.common.cover.ItemFilterCover;
import com.gregtechceu.gtceu.common.item.tool.behavior.ToolModeSwitchBehavior;
import com.gregtechceu.gtceu.common.machine.owner.MachineOwner;
import com.gregtechceu.gtceu.common.machine.owner.PlayerOwner;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.DummyWorld;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MetaMachine
implements IEnhancedManaged,
IToolable,
ITickSubscription,
IToolGridHighlight,
IFancyTooltip,
IPaintable,
IRedstoneSignalMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MetaMachine.class);
    private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);
    @Persisted
    @DescSynced
    @Nullable
    private UUID ownerUUID;
    public final IMachineBlockEntity holder;
    @DescSynced
    @Persisted(key="cover")
    protected final MachineCoverContainer coverContainer;
    @Persisted
    @DescSynced
    @RequireRerender
    private int paintingColor = -1;
    protected final List<MachineTrait> traits;
    private final List<TickableSubscription> serverTicks;
    private final List<TickableSubscription> waitingToAdd;
    public boolean isFirstDummyWorldTick = true;

    public MetaMachine(IMachineBlockEntity holder) {
        this.holder = holder;
        this.coverContainer = new MachineCoverContainer(this);
        this.traits = new ArrayList<MachineTrait>();
        this.serverTicks = new ArrayList<TickableSubscription>();
        this.waitingToAdd = new ArrayList<TickableSubscription>();
        if (holder.getRootStorage() != null) {
            this.holder.getRootStorage().attach((IManagedStorage)this.getSyncStorage());
        }
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        Level level = this.getLevel();
        if (level != null && !level.f_46443_ && level.m_7654_() != null) {
            level.m_7654_().execute(this::markDirty);
        }
    }

    @Nullable
    public Level getLevel() {
        return this.holder.level();
    }

    public BlockPos getPos() {
        return this.holder.pos();
    }

    public BlockState getBlockState() {
        return this.holder.getSelf().m_58900_();
    }

    public boolean isRemote() {
        return this.getLevel() == null ? GTCEu.isClientThread() : this.getLevel().f_46443_;
    }

    public void notifyBlockUpdate() {
        this.holder.notifyBlockUpdate();
    }

    public void scheduleRenderUpdate() {
        this.holder.scheduleRenderUpdate();
    }

    public void scheduleNeighborShapeUpdate() {
        Level level = this.getLevel();
        BlockPos pos = this.getPos();
        if (level == null || pos == null) {
            return;
        }
        level.m_8055_(pos).m_60701_((LevelAccessor)level, pos, 3);
    }

    @Override
    public void setPaintingColor(int color) {
        if (color == this.paintingColor) {
            return;
        }
        this.paintingColor = color;
        this.onPaintingColorChanged(color);
        MachineRenderState renderState = this.getRenderState();
        if (renderState.m_61138_((Property)GTMachineModelProperties.IS_PAINTED)) {
            this.setRenderState((MachineRenderState)((Object)renderState.m_61124_((Property)GTMachineModelProperties.IS_PAINTED, Boolean.valueOf(this.isPainted()))));
        }
    }

    public void onPaintingColorChanged(int color) {
    }

    public long getOffsetTimer() {
        return this.holder.getOffsetTimer();
    }

    public void markDirty() {
        this.holder.getSelf().m_6596_();
    }

    public boolean isInValid() {
        return this.holder.getSelf().m_58901_();
    }

    public void onUnload() {
        this.traits.forEach(MachineTrait::onMachineUnLoad);
        this.coverContainer.onUnload();
        for (TickableSubscription serverTick : this.serverTicks) {
            serverTick.unsubscribe();
        }
        this.serverTicks.clear();
    }

    public void onLoad() {
        this.traits.forEach(MachineTrait::onMachineLoad);
        this.coverContainer.onLoad();
        MachineRenderState renderState = this.getRenderState();
        if (renderState.m_61138_((Property)GTMachineModelProperties.IS_PAINTED) && this.isPainted() != ((Boolean)renderState.m_61143_((Property)GTMachineModelProperties.IS_PAINTED)).booleanValue()) {
            this.setRenderState((MachineRenderState)((Object)renderState.m_61124_((Property)GTMachineModelProperties.IS_PAINTED, Boolean.valueOf(this.isPainted()))));
        }
    }

    public void saveCustomPersistedData(@NotNull CompoundTag tag, boolean forDrop) {
        for (MachineTrait trait : this.getTraits()) {
            trait.saveCustomPersistedData(tag, forDrop);
        }
    }

    public void loadCustomPersistedData(@NotNull CompoundTag tag) {
        for (MachineTrait trait : this.getTraits()) {
            trait.loadCustomPersistedData(tag);
        }
    }

    @Override
    @Nullable
    public TickableSubscription subscribeServerTick(Runnable runnable) {
        if (!this.isRemote()) {
            TickableSubscription subscription = new TickableSubscription(runnable);
            this.waitingToAdd.add(subscription);
            return subscription;
        }
        if (this.getLevel() instanceof DummyWorld) {
            TickableSubscription subscription = new TickableSubscription(runnable);
            this.waitingToAdd.add(subscription);
            return subscription;
        }
        return null;
    }

    @Override
    public void unsubscribe(@Nullable TickableSubscription current) {
        if (current != null) {
            current.unsubscribe();
        }
    }

    public final void serverTick() {
        this.executeTick();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        if (this.getLevel() instanceof DummyWorld) {
            if (this.isFirstDummyWorldTick) {
                this.isFirstDummyWorldTick = false;
                this.onLoad();
            }
            this.executeTick();
        }
    }

    private void executeTick() {
        if (!this.waitingToAdd.isEmpty()) {
            this.serverTicks.addAll(this.waitingToAdd);
            this.waitingToAdd.clear();
        }
        Iterator<TickableSubscription> iter = this.serverTicks.iterator();
        while (iter.hasNext()) {
            TickableSubscription tickable = iter.next();
            if (tickable.isStillSubscribed()) {
                tickable.run();
            }
            if (this.isInValid()) break;
            if (tickable.isStillSubscribed()) continue;
            iter.remove();
        }
    }

    @Override
    public final Pair<GTToolType, InteractionResult> onToolClick(Set<@NotNull GTToolType> toolType, ItemStack itemStack, UseOnContext context) {
        CoverBehavior coverBehavior;
        Player playerIn = context.m_43723_();
        if (playerIn == null) {
            return Pair.of(null, (Object)InteractionResult.PASS);
        }
        InteractionHand hand = context.m_43724_();
        BlockHitResult hitResult = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), false);
        Direction gridSide = ICoverable.determineGridSideHit(hitResult);
        CoverBehavior coverBehavior2 = coverBehavior = gridSide == null ? null : this.coverContainer.getCoverAtSide(gridSide);
        if (gridSide == null) {
            gridSide = hitResult.m_82434_();
        }
        if (toolType.isEmpty() && playerIn.m_6144_() && coverBehavior != null) {
            return Pair.of(null, (Object)coverBehavior.onScrewdriverClick(playerIn, hand, hitResult));
        }
        if (toolType.contains(GTToolType.SCREWDRIVER)) {
            if (coverBehavior != null) {
                return Pair.of((Object)GTToolType.SCREWDRIVER, (Object)coverBehavior.onScrewdriverClick(playerIn, hand, hitResult));
            }
            return Pair.of((Object)GTToolType.SCREWDRIVER, (Object)this.onScrewdriverClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.SOFT_MALLET)) {
            if (coverBehavior != null) {
                return Pair.of((Object)GTToolType.SOFT_MALLET, (Object)coverBehavior.onSoftMalletClick(playerIn, hand, hitResult));
            }
            return Pair.of((Object)GTToolType.SOFT_MALLET, (Object)this.onSoftMalletClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.WRENCH)) {
            return Pair.of((Object)GTToolType.WRENCH, (Object)this.onWrenchClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.CROWBAR)) {
            if (coverBehavior != null) {
                if (!this.isRemote()) {
                    this.getCoverContainer().removeCover(gridSide, playerIn);
                }
                return Pair.of((Object)GTToolType.CROWBAR, (Object)InteractionResult.CONSUME);
            }
            return Pair.of((Object)GTToolType.CROWBAR, (Object)this.onCrowbarClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.HARD_HAMMER)) {
            return Pair.of((Object)GTToolType.HARD_HAMMER, (Object)this.onHardHammerClick(playerIn, hand, gridSide, hitResult));
        }
        return Pair.of(null, (Object)InteractionResult.PASS);
    }

    protected InteractionResult onHardHammerClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        MetaMachine metaMachine = this;
        if (metaMachine instanceof IMufflableMachine) {
            IMufflableMachine mufflableMachine = (IMufflableMachine)((Object)metaMachine);
            if (!this.isRemote()) {
                mufflableMachine.setMuffled(!mufflableMachine.isMuffled());
                playerIn.m_213846_((Component)Component.m_237115_((String)(mufflableMachine.isMuffled() ? "gtceu.machine.muffle.on" : "gtceu.machine.muffle.off")));
            }
            return InteractionResult.m_19078_((boolean)playerIn.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult onCrowbarClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (gridSide == this.getFrontFacing() && this.allowExtendedFacing()) {
            this.setUpwardsFacing(playerIn.m_6144_() ? this.getUpwardsFacing().m_122428_() : this.getUpwardsFacing().m_122427_());
            return InteractionResult.m_19078_((boolean)this.isRemote());
        }
        if (playerIn.m_6144_()) {
            if (gridSide == this.getFrontFacing() || !this.isFacingValid(gridSide)) {
                return InteractionResult.FAIL;
            }
            this.setFrontFacing(gridSide);
        } else {
            MetaMachine metaMachine;
            ItemStack itemStack = playerIn.m_21120_(hand);
            CompoundTag tagCompound = ToolHelper.getBehaviorsTag(itemStack);
            ToolModeSwitchBehavior.WrenchModeType type = ToolModeSwitchBehavior.WrenchModeType.values()[tagCompound.m_128445_("Mode")];
            if (type.isItem() && (metaMachine = this) instanceof IAutoOutputItem) {
                IAutoOutputItem autoOutputItem = (IAutoOutputItem)((Object)metaMachine);
                if (!this.hasFrontFacing() || gridSide != this.getFrontFacing()) {
                    autoOutputItem.setOutputFacingItems(gridSide);
                }
            }
            if (type.isFluid() && (metaMachine = this) instanceof IAutoOutputFluid) {
                IAutoOutputFluid autoOutputFluid = (IAutoOutputFluid)((Object)metaMachine);
                if (!this.hasFrontFacing() || gridSide != this.getFrontFacing()) {
                    autoOutputFluid.setOutputFacingFluids(gridSide);
                }
            }
        }
        return InteractionResult.m_19078_((boolean)this.isRemote());
    }

    protected InteractionResult onSoftMalletClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        IControllable controllable = GTCapabilityHelper.getControllable(this.getLevel(), this.getPos(), gridSide);
        if (controllable == null) {
            return InteractionResult.PASS;
        }
        if (!this.isRemote()) {
            controllable.setWorkingEnabled(!controllable.isWorkingEnabled());
            playerIn.m_213846_((Component)Component.m_237115_((String)(controllable.isWorkingEnabled() ? "behaviour.soft_hammer.enabled" : "behaviour.soft_hammer.disabled_cycle")));
        }
        return InteractionResult.m_19078_((boolean)playerIn.m_9236_().f_46443_);
    }

    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (this.isRemote()) {
            return InteractionResult.SUCCESS;
        }
        if (playerIn.m_6144_()) {
            IAutoOutputFluid autoOutputFluid;
            IAutoOutputItem autoOutputItem;
            boolean changed = false;
            MetaMachine metaMachine = this;
            if (metaMachine instanceof IAutoOutputItem && (autoOutputItem = (IAutoOutputItem)((Object)metaMachine)).getOutputFacingItems() == gridSide) {
                autoOutputItem.setAllowInputFromOutputSideItems(!autoOutputItem.isAllowInputFromOutputSideItems());
                playerIn.m_5661_((Component)Component.m_237115_((String)("gtceu.machine.basic.input_from_output_side." + (autoOutputItem.isAllowInputFromOutputSideItems() ? "allow" : "disallow"))).m_7220_((Component)Component.m_237115_((String)"gtceu.creative.chest.item")), true);
                changed = true;
            }
            if ((metaMachine = this) instanceof IAutoOutputFluid && (autoOutputFluid = (IAutoOutputFluid)((Object)metaMachine)).getOutputFacingFluids() == gridSide) {
                autoOutputFluid.setAllowInputFromOutputSideFluids(!autoOutputFluid.isAllowInputFromOutputSideFluids());
                playerIn.m_5661_((Component)Component.m_237115_((String)("gtceu.machine.basic.input_from_output_side." + (autoOutputFluid.isAllowInputFromOutputSideFluids() ? "allow" : "disallow"))).m_7220_((Component)Component.m_237115_((String)"gtceu.creative.tank.fluid")), true);
                changed = true;
            }
            if (changed) {
                return InteractionResult.m_19078_((boolean)playerIn.m_9236_().f_46443_);
            }
        } else {
            IAutoOutputFluid autoOutputFluid;
            IAutoOutputItem autoOutputItem;
            boolean changed = false;
            MetaMachine metaMachine = this;
            if (metaMachine instanceof IAutoOutputItem && (autoOutputItem = (IAutoOutputItem)((Object)metaMachine)).getOutputFacingItems() == gridSide) {
                autoOutputItem.setAutoOutputItems(!autoOutputItem.isAutoOutputItems());
                changed = true;
            }
            if ((metaMachine = this) instanceof IAutoOutputFluid && (autoOutputFluid = (IAutoOutputFluid)((Object)metaMachine)).getOutputFacingFluids() == gridSide) {
                autoOutputFluid.setAutoOutputFluids(!autoOutputFluid.isAutoOutputFluids());
                changed = true;
            }
            if (changed) {
                return InteractionResult.m_19078_((boolean)playerIn.m_9236_().f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public static MetaMachine getMachine(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMachineBlockEntity) {
            IMachineBlockEntity machineBlockEntity = (IMachineBlockEntity)blockEntity;
            return machineBlockEntity.getMetaMachine();
        }
        return null;
    }

    public void attachTraits(MachineTrait trait) {
        this.traits.add(trait);
    }

    public void clearInventory(IItemHandlerModifiable inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stackInSlot = inventory.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            inventory.setStackInSlot(i, ItemStack.f_41583_);
            Block.m_49840_((Level)this.getLevel(), (BlockPos)this.getPos(), (ItemStack)stackInSlot);
        }
    }

    @Override
    public boolean shouldRenderGrid(Player player, BlockPos pos, BlockState state, ItemStack held, Set<GTToolType> toolTypes) {
        if (toolTypes.contains(GTToolType.WRENCH)) {
            return true;
        }
        if (toolTypes.contains(GTToolType.SCREWDRIVER) && (this instanceof IAutoOutputItem || this instanceof IAutoOutputFluid)) {
            return true;
        }
        for (CoverBehavior cover : this.coverContainer.getCovers()) {
            if (!cover.shouldRenderGrid(player, pos, state, held, toolTypes)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        MetaMachine metaMachine;
        ResourceTexture tips;
        CoverBehavior cover = this.coverContainer.getCoverAtSide(side);
        if (cover != null && (tips = cover.sideTips(player, pos, state, toolTypes, side)) != null) {
            return tips;
        }
        if (toolTypes.contains(GTToolType.WRENCH)) {
            if (player.m_6144_() && this.isFacingValid(side)) {
                return GuiTextures.TOOL_FRONT_FACING_ROTATION;
            }
        } else if (toolTypes.contains(GTToolType.SOFT_MALLET)) {
            MetaMachine metaMachine2 = this;
            if (metaMachine2 instanceof IControllable) {
                IControllable controllable = (IControllable)((Object)metaMachine2);
                return controllable.isWorkingEnabled() ? GuiTextures.TOOL_START : GuiTextures.TOOL_PAUSE;
            }
        } else if (toolTypes.contains(GTToolType.HARD_HAMMER) && (metaMachine = this) instanceof IMufflableMachine) {
            IMufflableMachine mufflableMachine = (IMufflableMachine)((Object)metaMachine);
            return mufflableMachine.isMuffled() ? GuiTextures.TOOL_SOUND : GuiTextures.TOOL_MUTE;
        }
        return null;
    }

    public void addDebugOverlayText(Consumer<String> lines) {
        lines.accept(String.valueOf(ChatFormatting.UNDERLINE) + "Targeted Machine: ");
        lines.accept(this.getDefinition().getId().toString());
        MachineRenderState renderState = this.getRenderState();
        for (Map.Entry property : renderState.m_61148_().entrySet()) {
            lines.accept(ModelUtils.getPropertyValueString(property));
        }
    }

    public MachineDefinition getDefinition() {
        return this.holder.getDefinition();
    }

    public RotationState getRotationState() {
        return this.getDefinition().getRotationState();
    }

    public void addCollisionBoundingBox(List<VoxelShape> collisionList) {
        collisionList.add(Shapes.m_83144_());
    }

    public boolean canSetIoOnSide(@Nullable Direction direction) {
        return !this.hasFrontFacing() || this.getFrontFacing() != direction;
    }

    @NotNull
    public static Direction getFrontFacing(@Nullable MetaMachine machine) {
        return machine == null ? Direction.NORTH : machine.getFrontFacing();
    }

    public Direction getFrontFacing() {
        return this.getRotationState() == RotationState.NONE ? Direction.NORTH : (Direction)this.getBlockState().m_61143_((Property)this.getRotationState().property);
    }

    public final boolean hasFrontFacing() {
        return this.getRotationState() != RotationState.NONE;
    }

    public boolean isFacingValid(Direction facing) {
        CoverDefinition coverDefinition;
        CoverBehavior behaviour;
        if (this.hasFrontFacing() && facing == this.getFrontFacing()) {
            return false;
        }
        MachineCoverContainer coverContainer = this.getCoverContainer();
        if (coverContainer.hasCover(facing) && !(behaviour = (coverDefinition = coverContainer.getCoverAtSide((Direction)facing).coverDefinition).createCoverBehavior(coverContainer, this.getFrontFacing())).canAttach()) {
            return false;
        }
        return this.getRotationState().test(facing);
    }

    public void setFrontFacing(Direction facing) {
        Direction oldFacing = this.getFrontFacing();
        if (this.allowExtendedFacing()) {
            Direction newUpwardsFacing = RelativeDirection.simulateAxisRotation(facing, oldFacing, this.getUpwardsFacing());
            this.setUpwardsFacing(newUpwardsFacing);
        }
        BlockState blockState = this.getBlockState();
        if (this.isFacingValid(facing)) {
            this.getLevel().m_46597_(this.getPos(), (BlockState)blockState.m_61124_((Property)this.getRotationState().property, (Comparable)facing));
        }
        if (this.getLevel() != null && !this.getLevel().f_46443_) {
            this.notifyBlockUpdate();
            this.markDirty();
        }
    }

    @NotNull
    public static Direction getUpwardFacing(@Nullable MetaMachine machine) {
        return machine == null || !machine.allowExtendedFacing() ? Direction.NORTH : (Direction)machine.getBlockState().m_61143_((Property)GTBlockStateProperties.UPWARDS_FACING);
    }

    public Direction getUpwardsFacing() {
        return this.allowExtendedFacing() ? (Direction)this.getBlockState().m_61143_((Property)GTBlockStateProperties.UPWARDS_FACING) : Direction.NORTH;
    }

    public void setUpwardsFacing(@NotNull Direction upwardsFacing) {
        if (!this.getDefinition().isAllowExtendedFacing()) {
            return;
        }
        if (upwardsFacing.m_122434_() == Direction.Axis.Y) {
            GTCEu.LOGGER.error("Tried to set upwards facing to invalid facing {}! Skipping", (Object)upwardsFacing);
            return;
        }
        BlockState blockState = this.getBlockState();
        if (blockState.m_60734_() instanceof MetaMachineBlock && blockState.m_61143_((Property)GTBlockStateProperties.UPWARDS_FACING) != upwardsFacing) {
            this.getLevel().m_46597_(this.getPos(), (BlockState)blockState.m_61124_((Property)GTBlockStateProperties.UPWARDS_FACING, (Comparable)upwardsFacing));
            if (this.getLevel() != null && !this.getLevel().f_46443_) {
                this.notifyBlockUpdate();
                this.markDirty();
            }
        }
    }

    public void onRotated(Direction oldFacing, Direction newFacing) {
    }

    public boolean allowExtendedFacing() {
        return this.getDefinition().isAllowExtendedFacing();
    }

    public int tintColor(int index) {
        if (index == 1 || index == -111) {
            return this.getRealColor();
        }
        return -1;
    }

    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        this.coverContainer.onNeighborChanged(block, fromPos, isMoving);
    }

    public void animateTick(RandomSource random) {
    }

    @NotNull
    public BlockState getBlockAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState sourceState, BlockPos sourcePos) {
        IMultiPart part;
        BlockState appearance = this.getCoverContainer().getBlockAppearance(state, level, pos, side, sourceState, sourcePos);
        if (appearance != null) {
            return appearance;
        }
        MetaMachine metaMachine = this;
        if (metaMachine instanceof IMultiPart && (part = (IMultiPart)((Object)metaMachine)).isFormed() && (appearance = part.getFormedAppearance(sourceState, sourcePos, side)) != null) {
            return appearance;
        }
        return this.getDefinition().getAppearance().get();
    }

    @MustBeInvokedByOverriders
    public void updateModelData(ModelData.Builder builder) {
        for (MachineTrait trait : this.getTraits()) {
            trait.updateModelData(builder);
        }
    }

    public MachineRenderState getRenderState() {
        return this.getHolder().getRenderState();
    }

    public void setRenderState(MachineRenderState state) {
        this.getHolder().setRenderState(state);
    }

    @Override
    public int getOutputSignal(@Nullable Direction side) {
        if (side == null) {
            return 0;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side.m_122424_());
        if (cover == null) {
            return 0;
        }
        return cover.getRedstoneSignalOutput();
    }

    @Override
    public boolean canConnectRedstone(Direction side) {
        if (side == null) {
            return false;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        if (cover == null) {
            return false;
        }
        return cover.canConnectRedstone();
    }

    @Nullable
    public MachineOwner getOwner() {
        return MachineOwner.getOwner(this.ownerUUID);
    }

    @Nullable
    public PlayerOwner getPlayerOwner() {
        return MachineOwner.getPlayerOwner(this.ownerUUID);
    }

    public Predicate<ItemStack> getItemCapFilter(@Nullable Direction side, IO io) {
        ItemFilterCover filterCover;
        CoverBehavior cover;
        if (side != null && (cover = this.getCoverContainer().getCoverAtSide(side)) instanceof ItemFilterCover && (filterCover = (ItemFilterCover)cover).getFilterMode().filters(io)) {
            return filterCover.getItemFilter();
        }
        return item -> true;
    }

    public Predicate<FluidStack> getFluidCapFilter(@Nullable Direction side, IO io) {
        FluidFilterCover filterCover;
        CoverBehavior cover;
        if (side != null && (cover = this.getCoverContainer().getCoverAtSide(side)) instanceof FluidFilterCover && (filterCover = (FluidFilterCover)cover).getFilterMode().filters(io)) {
            return filterCover.getFluidFilter();
        }
        return fluid -> true;
    }

    @Nullable
    public IItemHandlerModifiable getItemHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        IAutoOutputItem autoOutput;
        MetaMachine metaMachine;
        List<IItemHandlerModifiable> list = this.getTraits().stream().filter(IItemHandlerModifiable.class::isInstance).filter(t -> t.hasCapability(side)).map(IItemHandlerModifiable.class::cast).toList();
        if (list.isEmpty()) {
            return null;
        }
        IO io = IO.BOTH;
        if (side != null && (metaMachine = this) instanceof IAutoOutputItem && (autoOutput = (IAutoOutputItem)((Object)metaMachine)).getOutputFacingItems() == side && !autoOutput.isAllowInputFromOutputSideItems()) {
            io = IO.OUT;
        }
        IOFilteredInvWrapper handlerList = new IOFilteredInvWrapper(list, io, this.getItemCapFilter(side, IO.IN), this.getItemCapFilter(side, IO.OUT));
        if (!useCoverCapability || side == null) {
            return handlerList;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        return cover != null ? cover.getItemHandlerCap((IItemHandlerModifiable)handlerList) : handlerList;
    }

    @Nullable
    public IFluidHandlerModifiable getFluidHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        IAutoOutputFluid autoOutput;
        MetaMachine metaMachine;
        List<IFluidHandler> list = this.getTraits().stream().filter(IFluidHandler.class::isInstance).filter(t -> t.hasCapability(side)).map(IFluidHandler.class::cast).toList();
        if (list.isEmpty()) {
            return null;
        }
        IO io = IO.BOTH;
        if (side != null && (metaMachine = this) instanceof IAutoOutputFluid && (autoOutput = (IAutoOutputFluid)((Object)metaMachine)).getOutputFacingFluids() == side && !autoOutput.isAllowInputFromOutputSideFluids()) {
            io = IO.OUT;
        }
        IOFluidHandlerList handlerList = new IOFluidHandlerList(list, io, this.getFluidCapFilter(side, IO.IN), this.getFluidCapFilter(side, IO.OUT));
        if (!useCoverCapability || side == null) {
            return handlerList;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        return cover != null ? cover.getFluidHandlerCap(handlerList) : handlerList;
    }

    @Override
    public IGuiTexture getFancyTooltipIcon() {
        return GuiTextures.INFO_ICON;
    }

    @Override
    public final List<Component> getFancyTooltip() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        this.onAddFancyInformationTooltip(tooltips);
        return tooltips;
    }

    @Override
    public boolean showFancyTooltip() {
        return !this.getFancyTooltip().isEmpty();
    }

    public void onAddFancyInformationTooltip(List<Component> tooltips) {
        this.getDefinition().getTooltipBuilder().accept(this.getDefinition().asStack(), tooltips);
        String mainKey = String.format("%s.machine.%s.tooltip", this.getDefinition().getId().m_135827_(), this.getDefinition().getId().m_135815_());
        if (Language.m_128107_().m_6722_(mainKey)) {
            tooltips.add(0, (Component)Component.m_237115_((String)mainKey));
        }
    }

    @Override
    public int getDefaultPaintingColor() {
        return this.getDefinition().getDefaultPaintingColor();
    }

    @Generated
    public FieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }

    @Generated
    public void setOwnerUUID(@Nullable UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    @Nullable
    @Generated
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Generated
    public IMachineBlockEntity getHolder() {
        return this.holder;
    }

    @Generated
    public MachineCoverContainer getCoverContainer() {
        return this.coverContainer;
    }

    @Override
    @Generated
    public int getPaintingColor() {
        return this.paintingColor;
    }

    @Generated
    public List<MachineTrait> getTraits() {
        return this.traits;
    }
}

