/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.config.ConfigHolder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="gtceu")
public class TreeFellingHelper {
    private final ServerPlayer player;
    private final ItemStack tool;
    private final Deque<BlockPos> orderedBlocks;
    private int tick;
    public static final List<TreeFellingHelper> helpers = ObjectArrayList.of();

    private TreeFellingHelper(ServerPlayer player, ItemStack tool, Deque<BlockPos> orderedBlocks) {
        this.player = player;
        this.tool = tool;
        this.orderedBlocks = orderedBlocks;
        this.tick = 0;
        helpers.add(this);
    }

    public static void fellTree(ItemStack stack, Level level, BlockState origin, BlockPos originPos, LivingEntity miner) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        ArrayDeque<BlockPos> checking = new ArrayDeque<BlockPos>();
        ObjectOpenHashSet visited = new ObjectOpenHashSet();
        checking.add(originPos);
        while (!checking.isEmpty()) {
            BlockPos check = (BlockPos)checking.remove();
            if (check != originPos) {
                visited.add(check);
            }
            for (int y = 0; y <= 1; ++y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        mutablePos.m_122178_(check.m_123341_() + x, check.m_123342_() + y, check.m_123343_() + z);
                        if (visited.contains(mutablePos) || origin.m_60734_() != level.m_8055_((BlockPos)mutablePos).m_60734_() || checking.contains(mutablePos)) continue;
                        BlockPos immutablePos = mutablePos.m_7949_();
                        checking.add(immutablePos);
                    }
                }
            }
        }
        if (!visited.isEmpty() && miner instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)miner;
            Deque orderedBlocks = visited.stream().sorted(Comparator.comparingInt(pos -> pos.m_123342_() - originPos.m_123342_())).collect(Collectors.toCollection(LinkedList::new));
            new TreeFellingHelper(serverPlayer, stack, orderedBlocks);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER && !helpers.isEmpty()) {
            Iterator<TreeFellingHelper> iterator = helpers.iterator();
            while (iterator.hasNext()) {
                TreeFellingHelper helper = iterator.next();
                if (event.level != helper.player.m_9236_()) continue;
                if (helper.player.m_213877_() || helper.orderedBlocks.isEmpty() || helper.tool.m_41619_() || !ToolHelper.hasBehaviorsTag(helper.player.m_21205_()) || !ToolHelper.getBehaviorsTag(helper.player.m_21205_()).m_128471_("TreeFelling")) {
                    iterator.remove();
                    continue;
                }
                if (helper.tick % ConfigHolder.INSTANCE.tools.treeFellingDelay == 0) {
                    ToolHelper.breakBlockRoutine(helper.player, helper.tool, helper.orderedBlocks.removeLast(), true);
                }
                ++helper.tick;
            }
        }
    }
}

