/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.gregtechceu.gtceu.api.block.MaterialBlock;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.DustProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaterialBlockItem
extends BlockItem
implements IItemRendererProvider {
    public final TagPrefix tagPrefix;
    public final Material material;

    public MaterialBlockItem(Block block, Item.Properties properties, TagPrefix tagPrefix, Material material) {
        super(block, properties);
        this.tagPrefix = tagPrefix;
        this.material = material;
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return this.getItemBurnTime();
    }

    @NotNull
    public MaterialBlock getBlock() {
        return (MaterialBlock)super.m_40614_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor tintColor(Material material) {
        return (itemStack, index) -> material.getLayerARGB(index);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public IRenderer getRenderer(ItemStack stack) {
        MaterialBlock materialBlock = this.getBlock();
        if (materialBlock instanceof IBlockRendererProvider) {
            IBlockRendererProvider provider = (IBlockRendererProvider)materialBlock;
            return provider.getRenderer(this.getBlock().m_49966_());
        }
        return null;
    }

    public String m_5524_() {
        return this.getBlock().m_7705_();
    }

    public String m_5671_(ItemStack stack) {
        return this.m_5524_();
    }

    public Component m_41466_() {
        return this.getBlock().m_49954_();
    }

    public Component m_7626_(ItemStack stack) {
        return this.m_41466_();
    }

    public int getItemBurnTime() {
        DustProperty property;
        DustProperty dustProperty = property = this.material.isNull() ? null : this.material.getProperty(PropertyKey.DUST);
        if (property != null) {
            return (int)((long)property.getBurnTime() * this.tagPrefix.getMaterialAmount(this.material) / 3628800L);
        }
        return -1;
    }
}

