/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.fluids;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import com.gregtechceu.gtceu.api.fluids.attribute.FluidAttribute;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.api.registry.registrate.IGTFluidBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidBuilder {
    private static final int INFER_TEMPERATURE = -1;
    private static final int INFER_COLOR = -1;
    private static final int INFER_DENSITY = -1;
    private static final int INFER_LUMINOSITY = -1;
    private static final int INFER_VISCOSITY = -1;
    private String name = null;
    private String translation = null;
    private final Collection<FluidAttribute> attributes = new ArrayList<FluidAttribute>();
    private FluidState state = FluidState.LIQUID;
    private int temperature = -1;
    private int color = -1;
    private boolean isColorEnabled = true;
    private int density = -1;
    private int luminosity = -1;
    private int viscosity = -1;
    private int burnTime = -1;
    private ResourceLocation still = null;
    private ResourceLocation flowing = null;
    private boolean hasCustomStill = false;
    private boolean hasCustomFlowing = false;
    private boolean hasFluidBlock = false;
    private boolean hasBucket = true;

    @NotNull
    public FluidBuilder temperature(int temperature) {
        Preconditions.checkArgument((temperature >= 0 ? 1 : 0) != 0, (Object)"temperature must be >= 0");
        this.temperature = temperature;
        return this;
    }

    @NotNull
    public FluidBuilder color(int color) {
        this.color = GTUtil.convertRGBtoARGB(color);
        if (this.color == -1) {
            return this.disableColor();
        }
        return this;
    }

    @NotNull
    public FluidBuilder disableColor() {
        this.isColorEnabled = false;
        return this;
    }

    @NotNull
    public FluidBuilder density(double density) {
        return this.density(FluidBuilder.convertToMCDensity(density));
    }

    private static int convertToMCDensity(double density) {
        if (density > 0.001225) {
            return (int)(1000.0 * density);
        }
        if (density < 0.001225) {
            return (int)(-0.1 / density);
        }
        return 0;
    }

    @NotNull
    public FluidBuilder luminosity(int luminosity) {
        Preconditions.checkArgument((luminosity >= 0 && luminosity < 16 ? 1 : 0) != 0, (Object)"luminosity must be >= 0 and < 16");
        this.luminosity = luminosity;
        return this;
    }

    @NotNull
    public FluidBuilder viscosity(int mcViscosity) {
        Preconditions.checkArgument((mcViscosity >= 0 ? 1 : 0) != 0, (Object)"viscosity must be >= 0");
        this.viscosity = mcViscosity;
        return this;
    }

    @NotNull
    public FluidBuilder viscosity(double viscosity) {
        return this.viscosity(FluidBuilder.convertViscosity(viscosity));
    }

    private static int convertViscosity(double viscosity) {
        return (int)(viscosity * 10000.0);
    }

    @NotNull
    public FluidBuilder attribute(@NotNull FluidAttribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    @NotNull
    public FluidBuilder attributes(FluidAttribute ... attributes) {
        Collections.addAll(this.attributes, attributes);
        return this;
    }

    @NotNull
    public FluidBuilder customStill() {
        return this.textures(true);
    }

    @NotNull
    public FluidBuilder textures(boolean hasCustomStill) {
        this.hasCustomStill = hasCustomStill;
        this.isColorEnabled = false;
        return this;
    }

    @NotNull
    public FluidBuilder textures(boolean hasCustomStill, boolean hasCustomFlowing) {
        this.hasCustomStill = hasCustomStill;
        this.hasCustomFlowing = hasCustomFlowing;
        this.isColorEnabled = false;
        return this;
    }

    @NotNull
    public FluidBuilder block() {
        this.hasFluidBlock = true;
        return this;
    }

    @NotNull
    public FluidBuilder disableBucket() {
        this.hasBucket = false;
        return this;
    }

    @NotNull
    public Supplier<? extends Fluid> build(Material material, @NotNull FluidStorageKey key, GTRegistrate registrate) {
        this.determineName(material, key);
        this.determineTextures(material, key, material.getModid());
        if (this.name == null) {
            throw new IllegalStateException("Could not determine fluid name");
        }
        if (this.state == null) {
            this.state = key != null && key.getDefaultFluidState() != null ? key.getDefaultFluidState() : FluidState.LIQUID;
        }
        this.determineTemperature(material);
        this.determineColor(material);
        this.determineDensity();
        this.determineLuminosity(material);
        this.determineViscosity(material);
        IGTFluidBuilder builder = registrate.createFluid(this.name, this.translation != null ? this.translation : key.getTranslationKeyFor(material), material, this.still, this.flowing).temperature(this.temperature).density(this.density).luminance(this.luminosity).viscosity(this.viscosity).hasBlock(this.hasFluidBlock).hasBucket(this.hasBucket).burnTime(this.burnTime).state(this.state);
        if (this.isColorEnabled) {
            builder.color(this.color);
        }
        builder.onFluidRegister(fluid -> {
            if (fluid instanceof FlowingFluid) {
                Fluid patt9006$temp;
                FlowingFluid flowingFluid = (FlowingFluid)fluid;
                Fluid patt8887$temp = flowingFluid.m_5613_();
                if (patt8887$temp instanceof GTFluid) {
                    GTFluid gtSource = (GTFluid)patt8887$temp;
                    this.attributes.forEach(gtSource::addAttribute);
                }
                if ((patt9006$temp = flowingFluid.m_5615_()) instanceof GTFluid) {
                    GTFluid gtFlowing = (GTFluid)patt9006$temp;
                    this.attributes.forEach(gtFlowing::addAttribute);
                }
            }
        });
        return builder.registerFluid();
    }

    private void determineName(@NotNull Material material, @Nullable FluidStorageKey key) {
        if (this.name != null) {
            return;
        }
        if (material.isNull() || key == null) {
            throw new IllegalArgumentException("Fluid must have a name");
        }
        this.name = key.getRegistryNameFor(material);
    }

    private void determineTextures(@NotNull Material material, @Nullable FluidStorageKey key, @NotNull String modid) {
        this.still = !material.isNull() && key != null ? (this.hasCustomStill ? new ResourceLocation(modid, "block/fluids/fluid." + this.name) : key.getIconType().getBlockTexturePath(material.getMaterialIconSet(), true)) : new ResourceLocation(modid, "block/fluids/fluid." + this.name);
        this.flowing = this.hasCustomFlowing ? new ResourceLocation(modid, "block/fluids/fluid." + this.name + "_flow") : this.still;
    }

    private void determineTemperature(@NotNull Material material) {
        if (this.temperature != -1) {
            return;
        }
        if (material.isNull()) {
            this.temperature = 293;
        } else {
            BlastProperty property = material.getProperty(PropertyKey.BLAST);
            if (property == null) {
                this.temperature = switch (this.state) {
                    default -> throw new IncompatibleClassChangeError();
                    case FluidState.LIQUID -> {
                        if (material.hasProperty(PropertyKey.DUST)) {
                            yield 1200;
                        }
                        yield 293;
                    }
                    case FluidState.GAS -> 293;
                    case FluidState.PLASMA -> material.hasFluid() && material.getFluidBuilder() != null && material.getFluidBuilder() != material.getFluidBuilder(FluidStorageKeys.PLASMA) ? 10000 + material.getFluidBuilder().temperature : 10000;
                };
            } else {
                int n = property.getBlastTemperature();
                this.temperature = n + (switch (this.state) {
                    default -> throw new IncompatibleClassChangeError();
                    case FluidState.LIQUID -> 0;
                    case FluidState.GAS -> 100;
                    case FluidState.PLASMA -> 10000;
                });
            }
        }
    }

    private void determineColor(@NotNull Material material) {
        if (this.color != -1) {
            return;
        }
        if (this.isColorEnabled && !material.isNull()) {
            this.color = GTUtil.convertRGBtoARGB(material.getMaterialRGB());
        }
    }

    private void determineDensity() {
        if (this.density != -1) {
            return;
        }
        this.density = switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case FluidState.LIQUID -> 1000;
            case FluidState.GAS -> -100;
            case FluidState.PLASMA -> -100000;
        };
    }

    private void determineLuminosity(@NotNull Material material) {
        if (this.luminosity != -1) {
            return;
        }
        this.luminosity = this.state == FluidState.PLASMA ? 15 : (!material.isNull() ? (material.hasFlag(MaterialFlags.PHOSPHORESCENT) ? 15 : (this.state == FluidState.LIQUID && material.hasProperty(PropertyKey.DUST) ? 10 : 0)) : 0);
    }

    private void determineViscosity(@NotNull Material material) {
        if (this.viscosity != -1) {
            return;
        }
        this.viscosity = switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case FluidState.LIQUID -> {
                if (!material.isNull() && material.hasFlag(MaterialFlags.STICKY)) {
                    yield 2000;
                }
                yield 1000;
            }
            case FluidState.GAS -> 200;
            case FluidState.PLASMA -> 10;
        };
    }

    @NotNull
    @Generated
    public FluidBuilder name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Generated
    public FluidBuilder translation(String translation) {
        this.translation = translation;
        return this;
    }

    @NotNull
    @Generated
    public FluidBuilder state(FluidState state) {
        this.state = state;
        return this;
    }

    @NotNull
    @Generated
    public FluidBuilder density(int density) {
        this.density = density;
        return this;
    }

    @NotNull
    @Generated
    public FluidBuilder burnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    @Generated
    public ResourceLocation still() {
        return this.still;
    }

    @NotNull
    @ApiStatus.Internal
    @Generated
    public FluidBuilder still(ResourceLocation still) {
        this.still = still;
        return this;
    }

    @Generated
    public ResourceLocation flowing() {
        return this.flowing;
    }

    @NotNull
    @ApiStatus.Internal
    @Generated
    public FluidBuilder flowing(ResourceLocation flowing) {
        this.flowing = flowing;
        return this;
    }

    @Generated
    public boolean hasFluidBlock() {
        return this.hasFluidBlock;
    }
}

