/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.ores;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedIndicators;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVein;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.gregtechceu.gtceu.config.ConfigHolder;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.apache.commons.lang3.mutable.MutableInt;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OreGenCache {
    private final OreGenerator oreGenerator = new OreGenerator();
    private final int oreGenerationCacheSize;
    private final int oreIndicatorCacheSize;
    private final int veinMetadataCacheSize;
    private final Cache<ChunkPos, List<GeneratedVeinMetadata>> veinMetadataByOrigin;
    private final Cache<ChunkPos, List<GeneratedVein>> generatedVeinsByOrigin;
    private final Cache<ChunkPos, List<GeneratedIndicators>> indicatorsByOrigin;

    public OreGenCache() {
        this.oreGenerationCacheSize = ConfigHolder.INSTANCE != null ? ConfigHolder.INSTANCE.worldgen.oreVeins.oreGenerationChunkCacheSize : 512;
        this.oreIndicatorCacheSize = ConfigHolder.INSTANCE != null ? ConfigHolder.INSTANCE.worldgen.oreVeins.oreIndicatorChunkCacheSize : 512;
        this.veinMetadataCacheSize = Math.max(this.oreGenerationCacheSize, this.oreIndicatorCacheSize);
        this.veinMetadataByOrigin = CacheBuilder.newBuilder().maximumSize((long)this.veinMetadataCacheSize).expireAfterAccess(30L, TimeUnit.SECONDS).softValues().build();
        this.generatedVeinsByOrigin = CacheBuilder.newBuilder().maximumSize((long)this.oreGenerationCacheSize).expireAfterAccess(30L, TimeUnit.SECONDS).softValues().build();
        this.indicatorsByOrigin = CacheBuilder.newBuilder().maximumSize((long)this.oreIndicatorCacheSize).expireAfterAccess(30L, TimeUnit.SECONDS).softValues().build();
    }

    private List<GeneratedVeinMetadata> getOrCreateVeinMetadata(WorldGenLevel level, ChunkGenerator generator, ChunkPos chunkPos) {
        try {
            return (List)this.veinMetadataByOrigin.get((Object)chunkPos, () -> this.oreGenerator.generateMetadata(level, generator, chunkPos));
        }
        catch (ExecutionException e) {
            GTCEu.LOGGER.error("Cannot create vein position in chunk {}", (Object)chunkPos, (Object)e);
            return List.of();
        }
    }

    public List<GeneratedVein> consumeChunkVeins(WorldGenLevel level, ChunkGenerator generator, ChunkAccess chunk) {
        return this.getSurroundingChunks(chunk.m_7697_(), OreVeinUtil.getMaxVeinSearchDistance()).flatMap(chunkPos -> {
            try {
                return ((List)this.generatedVeinsByOrigin.get(chunkPos, () -> this.oreGenerator.generateOres(level, this.getOrCreateVeinMetadata(level, generator, (ChunkPos)chunkPos), (ChunkPos)chunkPos))).stream();
            }
            catch (ExecutionException e) {
                GTCEu.LOGGER.error("Cannot create vein in chunk {}", chunkPos, (Object)e);
                return Stream.empty();
            }
        }).filter(Objects::nonNull).toList();
    }

    public List<GeneratedIndicators> consumeChunkIndicators(WorldGenLevel level, ChunkGenerator generator, ChunkAccess chunk) {
        return this.getSurroundingChunks(chunk.m_7697_(), OreVeinUtil.getMaxIndicatorSearchDistance()).flatMap(chunkPos -> {
            try {
                return ((List)this.indicatorsByOrigin.get(chunkPos, () -> this.oreGenerator.generateIndicators(level, this.getOrCreateVeinMetadata(level, generator, (ChunkPos)chunkPos), (ChunkPos)chunkPos))).stream();
            }
            catch (ExecutionException e) {
                GTCEu.LOGGER.error("Cannot create vein in chunk {}", chunkPos, (Object)e);
                return Stream.empty();
            }
        }).filter(Objects::nonNull).toList();
    }

    private Stream<ChunkPos> getSurroundingChunks(ChunkPos center, int searchDistance) {
        int minX = center.f_45578_ - searchDistance;
        int minZ = center.f_45579_ - searchDistance;
        int maxX = center.f_45578_ + searchDistance;
        int maxZ = center.f_45579_ + searchDistance;
        MutableInt x = new MutableInt(minX - 1);
        MutableInt z = new MutableInt(minZ);
        return Stream.generate(() -> {
            if (x.incrementAndGet() <= maxX) {
                return new ChunkPos(x.intValue(), z.intValue());
            }
            if (z.incrementAndGet() <= maxZ) {
                x.setValue(minX);
                return new ChunkPos(x.intValue(), z.intValue());
            }
            return null;
        }).takeWhile(Objects::nonNull);
    }

    @Generated
    public OreGenerator getOreGenerator() {
        return this.oreGenerator;
    }
}

