/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.utils.memoization.GTMemoizer;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class ArmorProperty
implements IMaterialProperty {
    private @Range(from=0L, to=0x7FFFFFFFL) int durabilityMultiplier;
    private Map<ArmorItem.Type, Integer> protectionValues;
    private int enchantability;
    private Supplier<SoundEvent> sound;
    private float toughness;
    private float knockbackResistance;
    private @Nullable Supplier<@NotNull Ingredient> repairIngredient;
    private boolean noRepair;
    private String name = "gtceu:metal";
    private CustomTextureGetter customTextureGetter = (stack, entity, slot, overlay) -> null;
    private boolean dyeable;
    private final ArmorMaterial armorMaterial;
    private Material material;

    public ArmorProperty(int durabilityMultiplier, int[] protectionValues) {
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionValues = (Map)Util.m_137469_(new EnumMap(ArmorItem.Type.class), map -> {
            for (int i = 0; i < ArmorItem.Type.values().length; ++i) {
                map.put(ArmorItem.Type.values()[i], protectionValues[i]);
            }
        });
        this.sound = GTMemoizer.memoize(() -> SoundEvents.f_11677_);
        this.toughness = 0.0f;
        this.knockbackResistance = 0.0f;
        this.armorMaterial = new ArmorMaterial();
    }

    public void setSound(Supplier<SoundEvent> sound) {
        this.sound = GTMemoizer.memoize(sound);
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        if (this.material == null) {
            this.material = properties.getMaterial();
        }
        if (this.repairIngredient == null && !this.noRepair) {
            this.repairIngredient = GTMemoizer.memoize(() -> Ingredient.m_204132_(ChemicalHelper.getTag(TagPrefix.plate, this.material)));
        }
    }

    @Generated
    public void setDurabilityMultiplier(int durabilityMultiplier) {
        this.durabilityMultiplier = durabilityMultiplier;
    }

    @Generated
    public void setProtectionValues(Map<ArmorItem.Type, Integer> protectionValues) {
        this.protectionValues = protectionValues;
    }

    @Generated
    public void setEnchantability(int enchantability) {
        this.enchantability = enchantability;
    }

    @Generated
    public void setToughness(float toughness) {
        this.toughness = toughness;
    }

    @Generated
    public void setKnockbackResistance(float knockbackResistance) {
        this.knockbackResistance = knockbackResistance;
    }

    @Generated
    public void setRepairIngredient(@Nullable Supplier<@NotNull Ingredient> repairIngredient) {
        this.repairIngredient = repairIngredient;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public CustomTextureGetter getCustomTextureGetter() {
        return this.customTextureGetter;
    }

    @Generated
    public void setCustomTextureGetter(CustomTextureGetter customTextureGetter) {
        this.customTextureGetter = customTextureGetter;
    }

    @Generated
    public boolean isDyeable() {
        return this.dyeable;
    }

    @Generated
    public void setDyeable(boolean dyeable) {
        this.dyeable = dyeable;
    }

    @Generated
    public ArmorMaterial getArmorMaterial() {
        return this.armorMaterial;
    }

    @FunctionalInterface
    public static interface CustomTextureGetter {
        public ResourceLocation getCustomTexture(ItemStack var1, Entity var2, EquipmentSlot var3, boolean var4);
    }

    public class ArmorMaterial
    implements net.minecraft.world.item.ArmorMaterial {
        private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 13);
            map.put(ArmorItem.Type.LEGGINGS, 15);
            map.put(ArmorItem.Type.CHESTPLATE, 16);
            map.put(ArmorItem.Type.HELMET, 11);
        });

        public int m_266425_(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ArmorItem.Type type) {
            return HEALTH_FUNCTION_FOR_TYPE.get(type) * ArmorProperty.this.durabilityMultiplier;
        }

        public int m_7366_(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ArmorItem.Type type) {
            return ArmorProperty.this.protectionValues.get(type);
        }

        public int m_6646_() {
            return ArmorProperty.this.enchantability;
        }

        @NotNull
        public SoundEvent m_7344_() {
            return ArmorProperty.this.sound.get();
        }

        @NotNull
        public Ingredient m_6230_() {
            return ArmorProperty.this.repairIngredient != null ? ArmorProperty.this.repairIngredient.get() : Ingredient.f_43901_;
        }

        @NotNull
        public String m_6082_() {
            return ArmorProperty.this.name;
        }

        public float m_6651_() {
            return ArmorProperty.this.toughness;
        }

        public float m_6649_() {
            return ArmorProperty.this.knockbackResistance;
        }

        public ArmorProperty getArmorProperty() {
            return ArmorProperty.this;
        }
    }

    public static class Builder {
        private final ArmorProperty armorProperty;

        public static Builder of(int durabilityMultiplier, int[] protectionValues) {
            Preconditions.checkArgument((protectionValues != null && protectionValues.length == 4 ? 1 : 0) != 0, (Object)"protectionValues must have 4 entries!");
            return new Builder(durabilityMultiplier, protectionValues);
        }

        private Builder(int durabilityMultiplier, int[] protectionValues) {
            this.armorProperty = new ArmorProperty(durabilityMultiplier, protectionValues);
        }

        public Builder unbreakable() {
            this.armorProperty.durabilityMultiplier = 0;
            return this;
        }

        public Builder enchantability(int enchantability) {
            this.armorProperty.enchantability = enchantability;
            return this;
        }

        public Builder protectionValue(ArmorItem.Type type, int value) {
            this.armorProperty.protectionValues.put(type, value);
            return this;
        }

        public Builder protectionValues(Map<ArmorItem.Type, Integer> protectionValues) {
            Preconditions.checkArgument((protectionValues != null && protectionValues.size() == 4 ? 1 : 0) != 0, (Object)"protectionValues must have 4 entries!");
            this.armorProperty.protectionValues = protectionValues;
            return this;
        }

        public Builder repairIngredient(@Nullable Supplier<@NotNull Ingredient> repairIngredient) {
            if (repairIngredient == null) {
                this.armorProperty.repairIngredient = null;
                this.armorProperty.noRepair = true;
            } else {
                this.armorProperty.repairIngredient = GTMemoizer.memoize(repairIngredient);
            }
            return this;
        }

        public Builder toughness(float toughness) {
            this.armorProperty.toughness = toughness;
            return this;
        }

        public Builder knockbackResistance(float knockbackResistance) {
            this.armorProperty.knockbackResistance = knockbackResistance;
            return this;
        }

        public Builder dyeable(boolean dyeable) {
            this.armorProperty.dyeable = dyeable;
            return this;
        }

        public Builder customTexture(@NotNull CustomTextureGetter textureGetter) {
            this.armorProperty.customTextureGetter = textureGetter;
            return this;
        }

        public ArmorProperty build() {
            return this.armorProperty;
        }
    }
}

