/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.sound.SoundWrapper;
import net.povstalec.sgjourney.common.block_entities.ProtectedBlockEntity;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.tech.EnergyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AdvancedCrystalInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.tech_interface.BasicInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.tech_interface.CrystalInterfaceEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blocks.tech_interface.AbstractInterfaceBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.ShieldingState;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.config.CommonPermissionConfig;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.CommonTransmissionConfig;
import net.povstalec.sgjourney.common.config.CommonZPMConfig;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.DamageSourceInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.init.StatisticsInit;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundStargateParticleSpawnPacket;
import net.povstalec.sgjourney.common.packets.ClientboundStargateStateUpdatePacket;
import net.povstalec.sgjourney.common.packets.ClientboundStargateUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Dialing;
import net.povstalec.sgjourney.common.sgjourney.ITransmissionReceiver;
import net.povstalec.sgjourney.common.sgjourney.SolarSystem;
import net.povstalec.sgjourney.common.sgjourney.StargateBlockCover;
import net.povstalec.sgjourney.common.sgjourney.StargateConnection;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.info.AddressFilterInfo;
import net.povstalec.sgjourney.common.sgjourney.info.DHDInfo;
import net.povstalec.sgjourney.common.sgjourney.info.SymbolInfo;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStargateEntity
extends EnergyBlockEntity
implements ITransmissionReceiver,
StructureGenEntity,
SymbolInfo.Interface,
DHDInfo.Interface,
AddressFilterInfo.Interface,
ProtectedBlockEntity {
    public static final String EMPTY = StargateJourney.EMPTY;
    public static final String ID = "ID";
    public static final String ID_9_CHEVRON_ADDRESS = "9ChevronAddress";
    public static final String EVENT_STARGATE_ROTATION_STARTED = "stargate_rotation_started";
    public static final String EVENT_STARGATE_ROTATION_STOPPED = "stargate_rotation_stopped";
    public static final String EVENT_CHEVRON_ENGAGED = "stargate_chevron_engaged";
    public static final String EVENT_RESET = "stargate_reset";
    public static final String EVENT_MESSAGE_RECEIVED = "stargate_message_received";
    public static final String ADDRESS = "Address";
    public static final String ENERGY = "Energy";
    public static final String CONNECTION_STATE = "connection_state";
    public static final String CONNECTION_ID = "ConnectionID";
    public static final String NETWORK = "Network";
    public static final String RESTRICT_NETWORK = "RestrictNetwork";
    public static final String TIMES_OPENED = "TimesOpened";
    public static final String AUTOCLOSE = "Autoclose";
    public static final String UPGRADED = "Upgraded";
    public static final String DISPLAY_ID = "DisplayID";
    public static final String VARIANT = "Variant";
    public static final String LOCAL_POINT_OF_ORIGIN = "local_point_of_origin";
    public static final String PRIMARY = "primary";
    public static final String COVER_BLOCKS = "CoverBlocks";
    public static final boolean FORCE_LOAD_CHUNK = (Boolean)CommonStargateConfig.stargate_loads_chunk_when_connected.get();
    public static final int SEGMENTS = 3;
    public static final int MAX_SYMBOLS = 48;
    public static final float STANDARD_THICKNESS = 9.0f;
    public static final float VERTICAL_CENTER_STANDARD_HEIGHT = 0.5f;
    public static final float HORIZONTAL_CENTER_STANDARD_HEIGHT = 0.28125f;
    private static final ResourceLocation CAVUM_TENEBRAE = ResourceLocation.m_214293_((String)"sgjourney", (String)"cavum_tenebrae");
    protected StructureGenEntity.Step generationStep = StructureGenEntity.Step.GENERATED;
    protected Address id9ChevronAddress = new Address();
    protected final StargateInfo.Gen generation;
    protected int totalSymbols;
    protected int[] symbolMap;
    protected int network;
    protected boolean restrictNetwork = false;
    protected BlockPos centerPosition;
    protected Direction direction;
    protected Orientation orientation;
    protected StargateInfo.Feedback recentFeedback = StargateInfo.Feedback.NONE;
    protected int kawooshTick = 0;
    protected int animationTick = 0;
    protected int[] engagedChevrons = Dialing.DEFAULT_CHEVRON_CONFIGURATION;
    protected int timesOpened = 0;
    protected int openTime = 0;
    protected int timeSinceLastTraveler = 0;
    protected ResourceLocation variant = StargateJourney.EMPTY_LOCATION;
    private final ResourceLocation defaultVariant;
    protected Address address = new Address();
    @Nullable
    protected UUID connectionID = null;
    protected StargateConnection.State connectionState = StargateConnection.State.IDLE;
    protected int openSoundLead = 28;
    protected float verticalCenterHeight;
    protected float horizontalCenterHeight;
    @Nullable
    public SoundWrapper wormholeIdleSound = null;
    @Nullable
    public SoundWrapper wormholeOpenSound = null;
    @Nullable
    public SoundWrapper spinSound = null;
    protected boolean displayID = false;
    protected boolean upgraded = false;
    protected boolean localPointOfOrigin = false;
    protected boolean isPrimary = false;
    protected boolean isProtected = false;
    private boolean initialClientSync = false;
    public StargateBlockCover blockCover = new StargateBlockCover(StargatePart.DEFAULT_PARTS);
    protected SymbolInfo symbolInfo;
    protected DHDInfo dhdInfo;
    protected AddressFilterInfo addressFilterInfo;

    public AbstractStargateEntity(BlockEntityType<?> blockEntity, ResourceLocation defaultVariant, BlockPos pos, BlockState state, int totalSymbols, StargateInfo.Gen gen, int defaultNetwork, float verticalCenterHeight, float horizontalCenterHeight) {
        super(blockEntity, pos, state);
        this.defaultVariant = defaultVariant;
        this.totalSymbols = totalSymbols;
        this.symbolMap = this.newSymbolMap();
        this.generation = gen;
        this.network = defaultNetwork;
        this.verticalCenterHeight = verticalCenterHeight;
        this.horizontalCenterHeight = horizontalCenterHeight;
        this.symbolInfo = new SymbolInfo();
        this.dhdInfo = new DHDInfo(this);
        this.addressFilterInfo = new AddressFilterInfo();
    }

    public AbstractStargateEntity(BlockEntityType<?> blockEntity, ResourceLocation defaultVariant, BlockPos pos, BlockState state, int totalSymbols, StargateInfo.Gen gen, int defaultNetwork) {
        this(blockEntity, defaultVariant, pos, state, totalSymbols, gen, defaultNetwork, 0.5f, 0.28125f);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.generationStep == StructureGenEntity.Step.READY) {
            this.generate();
        }
        this.updateClientState();
        this.dhdInfo.loadDHD();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        if (tag.m_128425_("generation_step", 1)) {
            this.generationStep = StructureGenEntity.Step.fromByte(tag.m_128445_("generation_step"));
        } else if (tag.m_128441_("AddToNetwork")) {
            this.generationStep = StructureGenEntity.Step.SETUP;
        }
        this.connectionState = StargateConnection.State.fromByte(tag.m_128445_(CONNECTION_STATE));
        if (tag.m_128425_(CONNECTION_ID, 8)) {
            try {
                this.connectionID = UUID.fromString(tag.m_128461_(CONNECTION_ID));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.deserializeStargateInfo(tag, false);
    }

    public void deserializeStargateInfo(CompoundTag tag, boolean isUpgraded) {
        super.m_142466_(tag);
        this.timesOpened = tag.m_128451_(TIMES_OPENED);
        this.address.fromArray(tag.m_128465_(ADDRESS));
        this.network = tag.m_128451_(NETWORK);
        this.restrictNetwork = tag.m_128471_(RESTRICT_NETWORK);
        if (tag.m_128441_(ID)) {
            this.id9ChevronAddress.fromString(tag.m_128461_(ID));
        } else {
            this.id9ChevronAddress.fromArray(tag.m_128465_(ID_9_CHEVRON_ADDRESS));
        }
        if (tag.m_128441_(DISPLAY_ID)) {
            this.displayID = tag.m_128471_(DISPLAY_ID);
        }
        if (isUpgraded) {
            this.upgraded = true;
        } else if (tag.m_128441_(UPGRADED)) {
            this.upgraded = tag.m_128471_(UPGRADED);
        }
        if (tag.m_128441_(LOCAL_POINT_OF_ORIGIN)) {
            this.localPointOfOrigin = tag.m_128471_(LOCAL_POINT_OF_ORIGIN);
        }
        if (tag.m_128441_(PRIMARY)) {
            this.isPrimary = tag.m_128471_(PRIMARY);
        }
        if (tag.m_128441_("protected")) {
            this.isProtected = tag.m_128471_("protected");
        }
        this.variant = new ResourceLocation(tag.m_128461_(VARIANT));
        if (tag.m_128441_("DHDPos")) {
            int[] pos = tag.m_128465_("DHDPos");
            this.dhdInfo().setRelativePos(new Vec3i(pos[0], pos[1], pos[2]));
        }
        this.dhdInfo().setAutoclose(tag.m_128451_(AUTOCLOSE));
        this.addressFilterInfo().deserializeFilters(tag);
        this.blockCover.deserializeNBT(tag.m_128469_(COVER_BLOCKS));
        this.m_6596_();
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        if (this.generationStep != StructureGenEntity.Step.GENERATED) {
            tag.m_128344_("generation_step", this.generationStep.byteValue());
        }
        tag.m_128344_(CONNECTION_STATE, this.connectionState.byteValue());
        if (this.connectionID != null) {
            tag.m_128359_(CONNECTION_ID, this.connectionID.toString());
        }
        this.serializeStargateInfo(tag);
    }

    public CompoundTag serializeStargateInfo(CompoundTag tag) {
        tag.m_128405_(TIMES_OPENED, this.timesOpened);
        tag.m_128385_(ADDRESS, this.address.toArray());
        tag.m_128405_(NETWORK, this.network);
        tag.m_128379_(RESTRICT_NETWORK, this.restrictNetwork);
        tag.m_128385_(ID_9_CHEVRON_ADDRESS, this.id9ChevronAddress.toArray());
        tag.m_128356_(ENERGY, this.getEnergyStored());
        if (this.displayID) {
            tag.m_128379_(DISPLAY_ID, true);
        }
        if (this.upgraded) {
            tag.m_128379_(UPGRADED, true);
        }
        if (this.localPointOfOrigin) {
            tag.m_128379_(LOCAL_POINT_OF_ORIGIN, true);
        }
        if (this.isPrimary) {
            tag.m_128379_(PRIMARY, true);
        }
        if (this.isProtected) {
            tag.m_128379_("protected", true);
        }
        tag.m_128359_(VARIANT, this.variant.toString());
        if (this.dhdInfo().relativePos() != null) {
            Vec3i pos = this.dhdInfo().relativePos();
            tag.m_128385_("DHDPos", new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        }
        tag.m_128405_(AUTOCLOSE, this.dhdInfo().autoclose());
        this.addressFilterInfo().serializeFilters(tag);
        tag.m_128365_(COVER_BLOCKS, (Tag)this.blockCover.serializeNBT());
        super.m_183515_(tag);
        return tag;
    }

    public void addStargateToNetwork() {
        if (this.id9ChevronAddress.isEmpty() || BlockEntityList.get(this.f_58857_).containsStargate(this.id9ChevronAddress.immutable())) {
            this.set9ChevronAddress(this.generate9ChevronAddress());
        }
        StargateNetwork.get(this.f_58857_).addStargate(this);
        this.m_6596_();
    }

    public void removeStargateFromNetwork() {
        StargateNetwork.get(this.f_58857_).removeStargate(this.id9ChevronAddress.immutable());
    }

    public void set9ChevronAddress(Address address) {
        this.id9ChevronAddress = address;
        this.m_6596_();
        StargateJourney.LOGGER.info("Set 9-Chevron Address to " + this.id9ChevronAddress);
    }

    public Address get9ChevronAddress() {
        return this.id9ChevronAddress;
    }

    protected Address generate9ChevronAddress() {
        Address address;
        Random random = new Random();
        do {
            address = new Address().randomAddress(8, 36, random.nextLong());
        } while (BlockEntityList.get(this.f_58857_).containsStargate(address.immutable()));
        return address;
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)(this.getCenterPos().m_123341_() - 3), (double)(this.getCenterPos().m_123342_() - 3), (double)(this.getCenterPos().m_123343_() - 3), (double)(this.getCenterPos().m_123341_() + 4), (double)(this.getCenterPos().m_123342_() + 4), (double)(this.getCenterPos().m_123343_() + 4));
    }

    private int[] newSymbolMap() {
        int[] symbolMap = new int[this.totalSymbols];
        for (int i = 0; i < this.totalSymbols; ++i) {
            symbolMap[i] = i;
        }
        return symbolMap;
    }

    public boolean remapSymbol(int originalSymbol, int newSymbol) {
        if (this.isSymbolOutOfBounds(originalSymbol)) {
            return false;
        }
        if (newSymbol < 0 || newSymbol > 48) {
            return false;
        }
        this.symbolMap[originalSymbol] = newSymbol;
        return true;
    }

    public int getMappedSymbol(int symbol) {
        if (symbol < 0 || symbol >= this.symbolMap.length) {
            return -1;
        }
        return this.symbolMap[symbol];
    }

    public int totalSymbols() {
        return this.totalSymbols;
    }

    public int getSymbolBounds() {
        return this.totalSymbols - 1;
    }

    public boolean isSymbolOutOfBounds(int symbol) {
        if (symbol < 0) {
            return true;
        }
        return symbol > this.getSymbolBounds();
    }

    public static int getChevron(AbstractStargateEntity stargate, int chevronNumber) {
        if (--chevronNumber < 0 || chevronNumber >= 8) {
            return 0;
        }
        return stargate.getEngagedChevrons()[chevronNumber];
    }

    public StargateInfo.Feedback dhdEngageSymbol(int symbol) {
        return this.engageSymbol(symbol);
    }

    public StargateInfo.Feedback engageSymbol(int symbol) {
        if (this.f_58857_.m_5776_()) {
            return StargateInfo.Feedback.NONE;
        }
        if (this.isSymbolOutOfBounds(symbol)) {
            return this.setRecentFeedback(StargateInfo.Feedback.SYMBOL_OUT_OF_BOUNDS);
        }
        return this.encodeSymbol(this.getMappedSymbol(symbol));
    }

    public StargateInfo.Feedback encodeSymbol(int symbol) {
        if (this.isConnected()) {
            if (symbol == 0) {
                return this.disconnectStargate(StargateInfo.Feedback.CONNECTION_ENDED_BY_DISCONNECT, true);
            }
            return this.setRecentFeedback(StargateInfo.Feedback.ENCODE_WHEN_CONNECTED);
        }
        if (symbol == 0) {
            return this.setRecentFeedback(this.lockPrimaryChevron());
        }
        return this.setRecentFeedback(this.encodeChevron(symbol, false, false));
    }

    public StargateInfo.Feedback encodeChevron(int symbol, boolean incoming, boolean encodeSound) {
        if (this.address.containsSymbol(symbol)) {
            return this.setRecentFeedback(StargateInfo.Feedback.SYMBOL_IN_ADDRESS);
        }
        if (!this.address.canGrow()) {
            return this.resetStargate(StargateInfo.Feedback.INVALID_ADDRESS);
        }
        this.growAddress(symbol);
        this.chevronSound((short)this.getAddress().getLength(), incoming, false, encodeSound);
        if (!incoming) {
            this.updateBasicInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming, symbol);
            this.updateCrystalInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming, symbol);
        } else {
            this.updateBasicInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming);
            this.updateCrystalInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming);
        }
        this.updateAdvancedCrystalInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming, symbol);
        this.m_6596_();
        return this.setRecentFeedback(StargateInfo.Feedback.SYMBOL_ENCODED);
    }

    protected StargateInfo.Feedback lockPrimaryChevron() {
        if (this.f_58857_.m_5776_()) {
            return StargateInfo.Feedback.NONE;
        }
        if (!this.address.isComplete()) {
            this.chevronSound((short)0, false, false, false);
            return this.resetStargate(StargateInfo.Feedback.INCOMPLETE_ADDRESS);
        }
        if (!this.isConnected()) {
            if (!this.isObstructed()) {
                this.updateInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength() + 1, 0, false, 0);
                StargateInfo.Feedback feedback = this.setRecentFeedback(this.engageStargate(this.getAddress(), true));
                this.chevronSound((short)0, false, false, false);
                return feedback;
            }
            return this.resetStargate(StargateInfo.Feedback.SELF_OBSTRUCTED, false);
        }
        return this.disconnectStargate(StargateInfo.Feedback.CONNECTION_ENDED_BY_DISCONNECT, true);
    }

    public void chevronSound(short chevron, boolean incoming, boolean open, boolean encode) {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.Chevron(this.f_58858_, chevron, incoming, open, encode));
        }
    }

    public void openWormholeSound(boolean incoming) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.OpenWormhole(this.f_58858_, incoming));
    }

    public void idleWormholeSound(boolean incoming) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.IdleWormhole(this.f_58858_, incoming));
    }

    public void closeWormholeSound(boolean incoming) {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.CloseWormhole(this.f_58858_, incoming));
        }
    }

    public abstract void playRotationSound();

    public abstract void stopRotationSound();

    public void playWormholeIdleSound() {
        this.wormholeIdleSound.playSound();
    }

    public StargateInfo.Feedback engageStargate(Address address, boolean doKawoosh) {
        Stargate stargate;
        Address.Immutable immutableAddress = address.immutable();
        if (this.addressFilterInfo().getFilterType().shouldFilter()) {
            if (this.addressFilterInfo().getFilterType().isBlacklist() && this.addressFilterInfo().isAddressBlacklisted(immutableAddress)) {
                return this.resetStargate(StargateInfo.Feedback.TARGET_BLACKLISTED);
            }
            if (this.addressFilterInfo().getFilterType().isWhitelist() && !this.addressFilterInfo().isAddressWhitelisted(immutableAddress)) {
                return this.resetStargate(StargateInfo.Feedback.TARGET_NOT_WHITELISTED);
            }
        }
        if ((stargate = StargateNetwork.get(this.f_58857_).getStargate(this.get9ChevronAddress().immutable())) != null) {
            return Dialing.dialStargate(((ServerLevel)this.f_58857_).m_7654_(), stargate, immutableAddress, doKawoosh);
        }
        StargateJourney.LOGGER.error("Stargate " + this.get9ChevronAddress() + " can't be found in the Stargate Network");
        return this.resetStargate(StargateInfo.Feedback.UNKNOWN_ERROR);
    }

    public void connectStargate(UUID connectionID, StargateConnection.State connectionState) {
        this.connectionID = connectionID;
        this.setConnected(connectionState);
        ++this.timesOpened;
        this.animationTick = 0;
        this.m_6596_();
        this.updateStargate(false);
    }

    public static double kawooshFunction(int kawooshTime) {
        return 8.0 * Math.sin(Math.PI * (double)kawooshTime / 40.0);
    }

    public void doKawoosh() {
        int kawooshTime = this.getKawooshTickCount();
        if (kawooshTime > 40) {
            return;
        }
        Direction axisDirection = this.getDirection().m_122434_() == Direction.Axis.X ? Direction.SOUTH : Direction.EAST;
        Direction direction = Orientation.getForwardDirection(this.getDirection(), this.getOrientation());
        double frontMultiplier = AbstractStargateEntity.kawooshFunction(kawooshTime);
        if (((Boolean)CommonStargateConfig.kawoosh_destroys_blocks.get()).booleanValue()) {
            this.destroyBlocks(frontMultiplier, axisDirection, direction);
        }
        if (((Boolean)CommonStargateConfig.kawoosh_disintegrates_entities.get()).booleanValue()) {
            this.disintegrateEntities(frontMultiplier, axisDirection, direction);
        }
    }

    protected void destroyBlocks(double frontMultiplier, Direction axisDirection, Direction direction) {
        BlockPos centerPos = this.getCenterPos();
        for (int width = -1; width <= 1; ++width) {
            for (int height = -1; height <= 1; ++height) {
                BlockPos pos = centerPos.m_5484_(axisDirection, width).m_5484_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), height);
                BlockState state = this.f_58857_.m_8055_(pos);
                if (state.m_60734_() instanceof AbstractStargateBlock) continue;
                for (int i = 0; i < (int)Math.round(frontMultiplier); ++i) {
                    BlockState relativeState;
                    BlockPos relativePos = pos.m_5484_(direction, i);
                    if (this.f_58857_.m_8055_(relativePos).m_60713_(Blocks.f_50016_) || (relativeState = this.f_58857_.m_8055_(relativePos)).m_204336_(TagInit.Blocks.KAWOOSH_IMMUNE)) continue;
                    this.f_58857_.m_46961_(relativePos, false);
                }
            }
        }
    }

    protected void disintegrateEntities(double frontMultiplier, Direction axisDirection, Direction direction) {
        Vec3 centerVector = this.getCenter();
        Vec3 backVector = centerVector.m_231075_(axisDirection, -2.25).m_231075_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), -2.25);
        frontMultiplier = frontMultiplier > 7.0 ? 7.0 : frontMultiplier;
        Vec3 facingVector = Orientation.getForwardVector(direction, this.getOrientation());
        facingVector = facingVector.m_82542_(frontMultiplier, frontMultiplier, frontMultiplier);
        facingVector = facingVector.m_82549_(centerVector);
        facingVector = facingVector.m_231075_(axisDirection, 2.25).m_231075_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), 2.25);
        AABB kawooshHitbox = new AABB(backVector.m_7096_(), backVector.m_7098_(), backVector.m_7094_(), facingVector.m_7096_(), facingVector.m_7098_(), facingVector.m_7094_());
        this.f_58857_.m_45976_(Entity.class, kawooshHitbox).stream().forEach(entity -> {
            if (this.shouldDisintegrate((Entity)entity) && entity.m_6084_()) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_36220_((ResourceLocation)StatisticsInit.TIMES_KILLED_BY_KAWOOSH.get());
                }
                entity.m_6469_(DamageSourceInit.damageSource(this.f_58857_.m_7654_(), DamageSourceInit.KAWOOSH), Float.MAX_VALUE);
                entity.m_6074_();
            }
        });
    }

    public boolean shouldDisintegrate(Entity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return false;
        }
        if (!((Boolean)CommonStargateConfig.kawoosh_disintegrates_items.get()).booleanValue() && entity instanceof ItemEntity) {
            return false;
        }
        return !entity.m_6095_().m_204039_(TagInit.Entities.KAWOOSH_IMMUNE);
    }

    public StargateInfo.Feedback resetStargate(StargateInfo.Feedback feedback, boolean updateInterfaces) {
        if (this.f_58857_.m_5776_()) {
            return StargateInfo.Feedback.NONE;
        }
        if (this.isConnected()) {
            this.closeWormholeSound(!this.isDialingOut());
            this.setConnected(StargateConnection.State.IDLE);
        }
        this.resetAddress(updateInterfaces);
        this.connectionID = null;
        this.setKawooshTickCount(0);
        this.setOpenTime(0);
        this.setTimeSinceLastTraveler(0);
        this.setTickCount(0);
        if (feedback.playFailSound() && !this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.Fail(this.f_58858_));
        }
        if (updateInterfaces) {
            this.updateBasicInterfaceBlocks(EVENT_RESET, feedback.getCode());
            this.updateCrystalInterfaceBlocks(EVENT_RESET, feedback.getCode(), feedback.getMessage());
            this.updateAdvancedCrystalInterfaceBlocks(EVENT_RESET, feedback.getCode(), feedback.getMessage());
        }
        this.dhdInfo().revalidateDHD();
        this.m_6596_();
        if (feedback == StargateInfo.Feedback.UNKNOWN_ERROR) {
            StargateJourney.LOGGER.error("Reset Stargate at " + this.m_58899_().m_123341_() + " " + this.m_58899_().m_123342_() + " " + this.m_58899_().m_123343_() + " " + this.m_58904_().m_46472_().m_135782_().toString() + " " + feedback.getMessage());
        } else {
            StargateJourney.LOGGER.debug("Reset Stargate at " + this.m_58899_().m_123341_() + " " + this.m_58899_().m_123342_() + " " + this.m_58899_().m_123343_() + " " + this.m_58904_().m_46472_().m_135782_().toString() + " " + feedback.getMessage());
        }
        return this.setRecentFeedback(feedback);
    }

    public StargateInfo.Feedback resetStargate(StargateInfo.Feedback feedback) {
        return this.resetStargate(feedback, true);
    }

    public StargateInfo.Feedback disconnectStargate(StargateInfo.Feedback feedback, boolean updateInterfaces) {
        if (this.isConnected()) {
            if (!((Boolean)CommonStargateConfig.end_connection_from_both_ends.get()).booleanValue() && !this.isDialingOut()) {
                return this.setRecentFeedback(StargateInfo.Feedback.WRONG_DISCONNECT_SIDE);
            }
            if (this.getOpenTime() <= 0) {
                return this.setRecentFeedback(StargateInfo.Feedback.CONNECTION_FORMING);
            }
        }
        return this.bypassDisconnectStargate(feedback, updateInterfaces);
    }

    public StargateInfo.Feedback bypassDisconnectStargate(StargateInfo.Feedback feedback, boolean updateInterfaces) {
        if (this.connectionID != null) {
            StargateNetwork.get(this.f_58857_).terminateConnection(this.connectionID, feedback);
        }
        return this.resetStargate(feedback, updateInterfaces);
    }

    public void updateStargate(boolean updateInterfaces) {
        this.updateStargate(this.f_58857_, updateInterfaces);
    }

    public void updateStargate(Level level, boolean updateInterfaces) {
        if (level.m_5776_()) {
            return;
        }
        StargateNetwork.get(level).updateStargate((ServerLevel)level, this);
        this.setStargateState(updateInterfaces);
    }

    protected void growAddress(int symbol) {
        this.address.addSymbol(symbol);
        this.setStargateState(true);
    }

    protected void resetAddress(boolean updateInterfaces) {
        this.address.reset();
        this.engagedChevrons = Dialing.DEFAULT_CHEVRON_CONFIGURATION;
        this.symbolMap = this.newSymbolMap();
        this.setConnectionState(StargateConnection.State.IDLE);
        this.setStargateState(updateInterfaces);
    }

    @Override
    public SymbolInfo symbolInfo() {
        return this.symbolInfo;
    }

    @Override
    public DHDInfo dhdInfo() {
        return this.dhdInfo;
    }

    @Override
    public AddressFilterInfo addressFilterInfo() {
        return this.addressFilterInfo;
    }

    public StargateInfo.Feedback setRecentFeedback(StargateInfo.Feedback feedback) {
        if (feedback != StargateInfo.Feedback.NONE) {
            this.recentFeedback = feedback;
        }
        this.dhdInfo().sendDHDFeedback(feedback);
        this.dhdInfo().updateDHD();
        return feedback;
    }

    public StargateInfo.Feedback getRecentFeedback() {
        return this.recentFeedback;
    }

    public int getNetwork() {
        return this.network;
    }

    public void setNetwork(int network) {
        this.network = network;
        this.updateStargate(false);
    }

    public boolean getRestrictNetwork() {
        return this.restrictNetwork;
    }

    public void setRestrictNetwork(boolean restrictNetwork) {
        this.restrictNetwork = restrictNetwork;
    }

    public boolean isRestricted(int network) {
        if (this.getRestrictNetwork()) {
            return network != this.getNetwork();
        }
        return false;
    }

    public StargateInfo.Gen getGeneration() {
        return this.generation;
    }

    public void setKawooshTickCount(int kawooshTick) {
        this.kawooshTick = kawooshTick;
    }

    public int getKawooshTickCount() {
        return this.kawooshTick;
    }

    public void setTickCount(int animationTick) {
        this.animationTick = animationTick;
    }

    public int getTickCount() {
        return this.animationTick;
    }

    public int increaseTickCount() {
        ++this.animationTick;
        return this.animationTick;
    }

    public void setOpenTime(int openTime) {
        this.openTime = openTime < 0 ? 0 : openTime;
    }

    public int getOpenTime() {
        return this.openTime;
    }

    public boolean isWormholeOpen() {
        return this.getOpenTime() > 0;
    }

    public void setTimeSinceLastTraveler(int timeSinceLastTraveler) {
        this.timeSinceLastTraveler = timeSinceLastTraveler < 0 ? 0 : timeSinceLastTraveler;
    }

    public int getTimeSinceLastTraveler() {
        return this.timeSinceLastTraveler;
    }

    public int getTimesOpened() {
        return this.timesOpened;
    }

    public void setVariant(ResourceLocation variant) {
        this.variant = variant;
    }

    public ResourceLocation getVariant() {
        return this.variant;
    }

    public ResourceLocation defaultVariant() {
        return this.defaultVariant;
    }

    public void setAddress(Address address) {
        this.address = address;
        this.m_6596_();
    }

    public Address getAddress() {
        return this.address;
    }

    public int getChevronsEngaged() {
        int chevronsEngaged = this.address.getLength();
        return this.isConnected() ? chevronsEngaged + 1 : chevronsEngaged;
    }

    public void setEngagedChevrons(int[] engagedChevrons) {
        this.engagedChevrons = engagedChevrons;
    }

    public int[] getEngagedChevrons() {
        return this.engagedChevrons;
    }

    public int chevronsRendered() {
        return this.address.getLength();
    }

    public int getRedstoneSymbolOutput() {
        return 0;
    }

    public int getRedstoneSegmentOutput() {
        return 0;
    }

    public BlockPos getCenterPos() {
        if (this.centerPosition == null) {
            BlockPos mainBlockPos = this.m_58899_();
            Direction centerDirection = Orientation.getCenterDirection(this.getDirection(), this.getOrientation());
            this.centerPosition = mainBlockPos.m_5484_(centerDirection, 3);
        }
        return this.centerPosition;
    }

    public Vec3 getCenter() {
        BlockPos centerPos = this.getCenterPos();
        double y = this.getVerticalCenterHeight();
        Orientation orientation = this.getOrientation();
        if (orientation != null && orientation != Orientation.REGULAR) {
            y = this.getHorizontalCenterHeight();
        }
        return new Vec3((double)centerPos.m_123341_() + 0.5, (double)centerPos.m_123342_() + y, (double)centerPos.m_123343_() + 0.5);
    }

    public Vec3 getRelativeCenter() {
        BlockPos mainBlockPos = this.m_58899_();
        BlockPos centerPos = this.getCenterPos();
        double y = this.getVerticalCenterHeight();
        Orientation orientation = this.getOrientation();
        if (orientation != null && orientation != Orientation.REGULAR) {
            y = this.getHorizontalCenterHeight();
        }
        return new Vec3((double)(centerPos.m_123341_() - mainBlockPos.m_123341_()) + 0.5, (double)(centerPos.m_123342_() - mainBlockPos.m_123342_()) + y, (double)(centerPos.m_123343_() - mainBlockPos.m_123343_()) + 0.5);
    }

    protected BlockState getState() {
        BlockPos gatePos = this.m_58899_();
        return this.f_58857_.m_8055_(gatePos);
    }

    public Orientation getOrientation() {
        if (this.orientation == null) {
            BlockState gateState = this.getState();
            if (gateState.m_60734_() instanceof AbstractStargateBaseBlock) {
                this.orientation = (Orientation)((Object)gateState.m_61143_((Property)AbstractStargateBaseBlock.ORIENTATION));
            } else {
                StargateJourney.LOGGER.error("Couldn't find Stargate Orientation " + this.m_58899_().toString());
            }
        }
        return this.orientation;
    }

    public Direction getDirection() {
        if (this.direction == null) {
            BlockState gateState = this.getState();
            if (gateState.m_60734_() instanceof AbstractStargateBaseBlock) {
                this.direction = (Direction)gateState.m_61143_((Property)AbstractStargateBaseBlock.FACING);
            } else {
                StargateJourney.LOGGER.error("Couldn't find Stargate Direction " + this.m_58899_().toString());
            }
        }
        return this.direction;
    }

    public void setConnectionState(StargateConnection.State connectionState) {
        this.connectionState = connectionState;
    }

    public void setConnected(StargateConnection.State connectionState) {
        this.setConnectionState(connectionState);
        this.setStargateState(true);
        if (FORCE_LOAD_CHUNK) {
            if (connectionState != StargateConnection.State.IDLE) {
                ForgeChunkManager.forceChunk((ServerLevel)this.f_58857_.m_7654_().m_129880_(this.f_58857_.m_46472_()), (String)"sgjourney", (BlockPos)this.m_58899_(), (int)this.f_58857_.m_46865_((BlockPos)this.m_58899_()).m_7697_().f_45578_, (int)this.f_58857_.m_46865_((BlockPos)this.m_58899_()).m_7697_().f_45579_, (boolean)true, (boolean)true);
            } else {
                ForgeChunkManager.forceChunk((ServerLevel)this.f_58857_.m_7654_().m_129880_(this.f_58857_.m_46472_()), (String)"sgjourney", (BlockPos)this.m_58899_(), (int)this.f_58857_.m_46865_((BlockPos)this.m_58899_()).m_7697_().f_45578_, (int)this.f_58857_.m_46865_((BlockPos)this.m_58899_()).m_7697_().f_45579_, (boolean)false, (boolean)true);
            }
        }
    }

    public void setStargateState(boolean updateInterfaces) {
        this.setStargateState(updateInterfaces, false, ShieldingState.OPEN);
        this.updateClientState();
    }

    public void setStargateState(boolean updateInterfaces, boolean updateIris, ShieldingState shieldingState) {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.getState();
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargate = (AbstractStargateBaseBlock)block;
            stargate.updateStargate(this.f_58857_, gatePos, gateState, shieldingState);
            if (updateIris) {
                stargate.updateIris(this.f_58857_, gatePos, gateState, shieldingState);
            }
            if (updateInterfaces) {
                this.updateInterfaceBlocks(null, new Object[0]);
            }
        } else {
            StargateJourney.LOGGER.error("Couldn't find Stargate");
        }
        this.m_6596_();
    }

    public StargateConnection.State getConnectionState() {
        return this.connectionState;
    }

    public boolean isConnected() {
        return this.getConnectionState().isConnected();
    }

    public boolean isDialingOut() {
        return this.getConnectionState().isDialingOut();
    }

    protected int getMaxObstructiveBlocks() {
        return (Integer)CommonStargateConfig.max_obstructive_blocks.get();
    }

    public boolean isObstructed() {
        Direction direction = this.getDirection().m_122434_() == Direction.Axis.X ? Direction.SOUTH : Direction.EAST;
        BlockPos centerPos = this.getCenterPos();
        int obstructingBlocks = 0;
        for (int width = -2; width <= 2; ++width) {
            for (int height = -2; height <= 2; ++height) {
                BlockPos pos = centerPos.m_5484_(direction, width).m_5484_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), height);
                BlockState state = this.f_58857_.m_8055_(pos);
                if ((state.m_247087_() || state.m_60734_() instanceof AbstractStargateBlock || state.m_60734_() instanceof AbstractShieldingBlock) && !state.m_60819_().m_192917_((Fluid)Fluids.f_76195_)) continue;
                ++obstructingBlocks;
            }
        }
        return obstructingBlocks >= this.getMaxObstructiveBlocks();
    }

    public void m_187476_(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)this.m_58903_(), (CompoundTag)this.serializeStargateInfo(tag));
    }

    public void updateBasicInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.getState();
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            for (StargatePart part : stargateBlock.getParts()) {
                BlockPos ringPos = part.getRingPos(gatePos, (Direction)gateState.m_61143_((Property)AbstractStargateBlock.FACING), (Orientation)((Object)gateState.m_61143_(AbstractStargateBlock.ORIENTATION)));
                for (Direction direction : Direction.values()) {
                    BlockPos pos = ringPos.m_121945_(direction);
                    BlockState state = this.f_58857_.m_8055_(pos);
                    BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                    if (!(blockEntity instanceof BasicInterfaceEntity)) continue;
                    BasicInterfaceEntity interfaceEntity = (BasicInterfaceEntity)blockEntity;
                    if (direction.m_122424_() != state.m_61143_((Property)AbstractInterfaceBlock.FACING)) continue;
                    if (eventName != null) {
                        interfaceEntity.queueEvent(eventName, objects);
                    }
                    this.f_58857_.m_46672_(pos, this.f_58857_.m_8055_(pos).m_60734_());
                    interfaceEntity.m_6596_();
                }
            }
        }
    }

    public void updateCrystalInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.getState();
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            for (StargatePart part : stargateBlock.getParts()) {
                BlockPos ringPos = part.getRingPos(gatePos, (Direction)gateState.m_61143_((Property)AbstractStargateBlock.FACING), (Orientation)((Object)gateState.m_61143_(AbstractStargateBlock.ORIENTATION)));
                for (Direction direction : Direction.values()) {
                    BlockPos pos = ringPos.m_121945_(direction);
                    BlockState state = this.f_58857_.m_8055_(pos);
                    BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                    if (!(blockEntity instanceof CrystalInterfaceEntity)) continue;
                    CrystalInterfaceEntity interfaceEntity = (CrystalInterfaceEntity)blockEntity;
                    if (direction.m_122424_() != state.m_61143_((Property)AbstractInterfaceBlock.FACING)) continue;
                    if (eventName != null) {
                        interfaceEntity.queueEvent(eventName, objects);
                    }
                    this.f_58857_.m_46672_(pos, this.f_58857_.m_8055_(pos).m_60734_());
                    interfaceEntity.m_6596_();
                }
            }
        }
    }

    public void updateAdvancedCrystalInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.getState();
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            for (StargatePart part : stargateBlock.getParts()) {
                BlockPos ringPos = part.getRingPos(gatePos, (Direction)gateState.m_61143_((Property)AbstractStargateBlock.FACING), (Orientation)((Object)gateState.m_61143_(AbstractStargateBlock.ORIENTATION)));
                for (Direction direction : Direction.values()) {
                    BlockPos pos = ringPos.m_121945_(direction);
                    BlockState state = this.f_58857_.m_8055_(pos);
                    BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                    if (!(blockEntity instanceof AdvancedCrystalInterfaceEntity)) continue;
                    AdvancedCrystalInterfaceEntity interfaceEntity = (AdvancedCrystalInterfaceEntity)blockEntity;
                    if (direction.m_122424_() != state.m_61143_((Property)AbstractInterfaceBlock.FACING)) continue;
                    if (eventName != null) {
                        interfaceEntity.queueEvent(eventName, objects);
                    }
                    this.f_58857_.m_46672_(pos, this.f_58857_.m_8055_(pos).m_60734_());
                    interfaceEntity.m_6596_();
                }
            }
        }
    }

    public void updateInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        this.updateBasicInterfaceBlocks(eventName, objects);
        this.updateCrystalInterfaceBlocks(eventName, objects);
        this.updateAdvancedCrystalInterfaceBlocks(eventName, objects);
    }

    public void setOpenSoundLead(int openSoundLead) {
        this.openSoundLead = openSoundLead;
    }

    public int getOpenSoundLead() {
        return this.openSoundLead;
    }

    public abstract StargateInfo.ChevronLockSpeed getChevronLockSpeed(boolean var1);

    @Override
    public void getStatus(Player player) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.point_of_origin").m_7220_((Component)Component.m_237113_((String)(": " + this.symbolInfo().pointOfOrigin()))).m_130940_(ChatFormatting.DARK_PURPLE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.symbols").m_7220_((Component)Component.m_237113_((String)(": " + this.symbolInfo().symbols()))).m_130940_(ChatFormatting.LIGHT_PURPLE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.times_opened").m_7220_((Component)Component.m_237113_((String)(": " + this.timesOpened))).m_130940_(ChatFormatting.BLUE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.has_dhd").m_7220_((Component)Component.m_237113_((String)(": " + this.dhdInfo().hasDHD()))).m_130940_(ChatFormatting.GOLD));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.autoclose").m_7220_((Component)Component.m_237113_((String)(": " + this.dhdInfo().autoclose()))).m_130940_(ChatFormatting.RED));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.last_traveler_time").m_7220_((Component)Component.m_237113_((String)(": " + this.getTimeSinceLastTraveler()))).m_130940_(ChatFormatting.DARK_PURPLE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.encoded_address").m_7220_((Component)Component.m_237113_((String)": ").m_7220_(this.address.toComponent(true))).m_130940_(ChatFormatting.GREEN));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.recent_feedback").m_7220_((Component)Component.m_237113_((String)": ").m_7220_(this.getRecentFeedback().getFeedbackMessage())).m_130940_(ChatFormatting.WHITE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.9_chevron_address").m_130946_(": ").m_130940_(ChatFormatting.AQUA).m_7220_(this.id9ChevronAddress.toComponent(true)));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.add_to_network").m_7220_((Component)Component.m_237113_((String)(": " + (this.generationStep == StructureGenEntity.Step.GENERATED)))).m_130940_(ChatFormatting.YELLOW));
        if (this.isPrimary()) {
            player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.is_primary").m_130940_(ChatFormatting.DARK_GREEN));
        }
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.open_time").m_7220_((Component)Component.m_237113_((String)(": " + this.getOpenTime() + "/" + Stargate.getMaxGateOpenTime()))).m_130940_(ChatFormatting.DARK_AQUA));
        super.getStatus(player);
    }

    @Override
    protected boolean canReceiveZeroPointEnergy() {
        return (Boolean)CommonZPMConfig.stargates_use_zero_point_energy.get();
    }

    @Override
    public boolean isCorrectEnergySide(Direction side) {
        return false;
    }

    @Override
    public long capacity() {
        return (Long)CommonStargateConfig.stargate_energy_capacity.get();
    }

    @Override
    public long maxReceive() {
        return (Long)CommonStargateConfig.stargate_energy_max_receive.get();
    }

    @Override
    public long maxExtract() {
        return (Long)CommonStargateConfig.intergalactic_connection_energy_cost.get();
    }

    public boolean pushTraveler() {
        if (this.getOrientation() == Orientation.UPWARD) {
            return true;
        }
        return CAVUM_TENEBRAE.equals((Object)this.m_58904_().m_46472_().m_135782_());
    }

    public float getVerticalCenterHeight() {
        return this.verticalCenterHeight;
    }

    public float getHorizontalCenterHeight() {
        return this.horizontalCenterHeight;
    }

    public double getGateAddition() {
        return this.getOrientation() == Orientation.REGULAR ? (double)this.getVerticalCenterHeight() : (double)this.getHorizontalCenterHeight();
    }

    public abstract void registerInterfaceMethods(StargatePeripheralWrapper var1);

    public void doWhileConnecting(boolean incoming, boolean doKawoosh, int kawooshStartTicks, int connectionTime) {
        if (!doKawoosh) {
            return;
        }
        if (connectionTime == kawooshStartTicks - this.getOpenSoundLead()) {
            this.openWormholeSound(incoming);
        }
        if (connectionTime >= kawooshStartTicks) {
            this.doKawoosh();
        }
    }

    public void doWhileDialed(Address dialingAddress, int kawooshStartTicks, boolean doKawoosh, int connectionTime) {
        if (connectionTime > kawooshStartTicks) {
            return;
        }
        StargateInfo.ChevronLockSpeed chevronLockSpeed = this.getChevronLockSpeed(doKawoosh);
        if (connectionTime % chevronLockSpeed.getChevronWaitTicks() == 0) {
            int dialedAddressLength = this.getAddress().getLength();
            int dialingAddressLength = dialingAddress.getLength();
            if (dialedAddressLength < dialingAddress.getLength()) {
                if (connectionTime / chevronLockSpeed.getChevronWaitTicks() == 4 && dialingAddressLength < 7) {
                    return;
                }
                if (connectionTime / chevronLockSpeed.getChevronWaitTicks() == 5 && dialingAddressLength < 8) {
                    return;
                }
                this.encodeChevron(dialingAddress.getSymbol(dialedAddressLength), true, false);
            } else {
                this.chevronSound((short)0, true, false, false);
                this.updateInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.getAddress().getLength() + 1, AbstractStargateEntity.getChevron(this, this.getAddress().getLength() + 1), true, 0);
            }
        }
    }

    public void doWhileConnected(boolean incoming, int connectionTime) {
        this.idleWormholeSound(incoming);
    }

    public List<Entity> findWormholeCandidates() {
        Vec3 centerPos = this.getCenter();
        AABB localBox = new AABB(centerPos.f_82479_ - 2.5, centerPos.f_82480_ - 2.5, centerPos.f_82481_ - 2.5, centerPos.f_82479_ + 2.5, centerPos.f_82480_ + 2.5, centerPos.f_82481_ + 2.5);
        List wormholeCandidates = this.m_58904_().m_6443_(Entity.class, localBox, entity -> entity.m_6084_() && !entity.m_6095_().m_204039_(TagInit.Entities.WORMHOLE_IGNORES));
        return wormholeCandidates;
    }

    public boolean updateClient() {
        if (this.f_58857_.m_5776_()) {
            return false;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundStargateUpdatePacket(this.f_58858_, this.getEnergyStored(), this.openTime, this.timeSinceLastTraveler, this.address.toArray(), this.engagedChevrons, this.kawooshTick, this.animationTick, 0, this.symbolInfo().pointOfOrigin(), this.symbolInfo().symbols(), this.variant, ItemStack.f_41583_));
        return true;
    }

    public boolean updateClientState() {
        if (this.f_58857_.m_5776_()) {
            return false;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundStargateStateUpdatePacket(this.f_58858_, this.connectionState, this.blockCover.canSinkGate, this.blockCover.blockStates));
        return true;
    }

    public void spawnCoverParticles() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundStargateParticleSpawnPacket(this.f_58858_, this.blockCover.blockStates));
    }

    public UUID getConnectionID() {
        return this.connectionID;
    }

    public void checkStargate() {
        if (this.isConnected() && !StargateNetwork.get(this.m_58904_()).hasConnection(this.getConnectionID())) {
            this.resetStargate(StargateInfo.Feedback.CONNECTION_ENDED_BY_NETWORK);
        }
    }

    public boolean sendStargateMessage(String message) {
        return StargateNetwork.get(this.f_58857_).sendStargateMessage(this, this.connectionID, message);
    }

    public void receiveStargateMessage(String message) {
        this.updateInterfaceBlocks(EVENT_MESSAGE_RECEIVED, message);
    }

    public float transmissionRadius() {
        return ((Integer)CommonTransmissionConfig.max_stargate_transmission_distance.get()).intValue();
    }

    @Override
    public void receiveTransmission(int transmissionJumps, int frequency, String transmission) {
        if (transmissionJumps < (Integer)CommonTransmissionConfig.max_transmission_jumps.get()) {
            StargateNetwork.get(this.f_58857_).sendStargateTransmission(this, this.connectionID, transmissionJumps + 1, frequency, transmission);
        }
    }

    public void forwardTransmission(int transmissionJumps, int frequency, String transmission) {
        int roundedRadius = (int)Math.ceil(this.transmissionRadius() / 16.0f);
        for (int x = -roundedRadius; x <= roundedRadius; ++x) {
            for (int z = -roundedRadius; z <= roundedRadius; ++z) {
                ChunkAccess chunk = this.f_58857_.m_46865_(this.m_58899_().m_122030_(16 * x).m_122020_(16 * z));
                Set positions = chunk.m_5928_();
                positions.stream().forEach(pos -> {
                    BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                    if (blockEntity instanceof ITransmissionReceiver) {
                        ITransmissionReceiver receiver = (ITransmissionReceiver)blockEntity;
                        receiver.receiveTransmission(transmissionJumps, frequency, transmission);
                    }
                });
            }
        }
    }

    public float checkConnectionShieldingState() {
        return StargateNetwork.get(this.f_58857_).checkStargateShieldingState(this, this.connectionID);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractStargateEntity stargate) {
        if (stargate.isConnected()) {
            stargate.increaseTickCount();
        }
        if (level.m_5776_()) {
            return;
        }
        stargate.updateClient();
        if (!stargate.initialClientSync) {
            stargate.updateClientState();
        }
    }

    @Override
    public void generateInStructure(WorldGenLevel level, RandomSource randomSource) {
        if (this.generationStep == StructureGenEntity.Step.SETUP) {
            this.generationStep = StructureGenEntity.Step.READY;
        }
    }

    private void trySetPrimary() {
        SolarSystem.Serializable solarSystem = Universe.get(this.f_58857_).getSolarSystemFromDimension((ResourceKey<Level>)this.f_58857_.m_46472_());
        if (solarSystem == null || solarSystem.primaryAddress() != null) {
            return;
        }
        solarSystem.setPrimaryStargate(this.get9ChevronAddress().immutable());
    }

    public void generate() {
        this.addStargateToNetwork();
        this.generateAdditional(StructureGenEntity.Step.READY);
        if (this.isPrimary()) {
            this.trySetPrimary();
        }
        this.generationStep = StructureGenEntity.Step.GENERATED;
    }

    public void generateAdditional(StructureGenEntity.Step generationStep) {
    }

    public void displayID() {
        this.displayID = true;
    }

    public void upgraded() {
        this.upgraded = true;
    }

    public void localPointOfOrigin() {
        this.localPointOfOrigin = true;
    }

    public void setPrimary() {
        this.isPrimary = true;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public boolean hasPermissions(Player player, boolean sendMessage) {
        if (this.isProtected() && !player.m_20310_(CommonPermissionConfig.protected_stargate_permissions.get())) {
            if (sendMessage) {
                player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.protected_permissions").m_130940_(ChatFormatting.DARK_RED), true);
            }
            return false;
        }
        return true;
    }
}

