/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.resourcepack.stargate_variant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.resourcepack.ResourcepackModel;
import net.povstalec.sgjourney.client.resourcepack.ResourcepackSounds;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClientStargateVariant;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.RotatingStargateVariant;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.misc.ColorUtil;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;

public class UniverseStargateVariant
extends RotatingStargateVariant {
    public static final String DIAL_START_SOUND = "dial_start_sound";
    public static final String ONLY_FRONT_ROTATES = "only_front_rotates";
    public static final ResourceLocation STARGATE_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/universe/universe_stargate.png");
    public static final ResourceLocation STARGATE_ENGAGED_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/universe/universe_stargate_engaged.png");
    public static final ResourceLocation STARGATE_WORMHOLE_LOCATION = new ResourceLocation("sgjourney", "textures/entity/stargate/universe/universe_event_horizon.png");
    public static final ResourceLocation STARGATE_SHINY_WORMHOLE_LOCATION = new ResourceLocation("sgjourney", "textures/entity/stargate/universe/universe_event_horizon_shiny.png");
    public static final ResourceLocation STARGATE_CHEVRON_ENGAGE = new ResourceLocation("sgjourney", "universe_chevron_engage");
    public static final ResourceLocation STARGATE_DIAL_START = new ResourceLocation("sgjourney", "universe_dial_start");
    public static final ResourceLocation STARGATE_RING_SPIN_START = new ResourceLocation("sgjourney", "universe_ring_spin_start");
    public static final ResourceLocation STARGATE_RING_SPIN = new ResourceLocation("sgjourney", "universe_ring_spin");
    public static final ResourceLocation STARGATE_WORMHOLE_OPEN = new ResourceLocation("sgjourney", "universe_wormhole_open");
    public static final ResourceLocation STARGATE_WORMHOLE_IDLE = new ResourceLocation("sgjourney", "universe_wormhole_idle");
    public static final ResourceLocation STARGATE_WORMHOLE_CLOSE = new ResourceLocation("sgjourney", "universe_wormhole_close");
    public static final ResourceLocation STARGATE_FAIL = new ResourceLocation("sgjourney", "universe_dial_fail");
    public static final ResourcepackModel.Wormhole STARGATE_WORMHOLE_TEXTURE = new ResourcepackModel.Wormhole((Either<ResourcepackModel.FrontBack, ResourcepackModel.WormholeTexture>)Either.left((Object)new ResourcepackModel.FrontBack(new ResourcepackModel.WormholeTexture(STARGATE_WORMHOLE_LOCATION, 32, 1, 32, DEFAULT_OPAQUE_RGBA), new ResourcepackModel.WormholeTexture(STARGATE_WORMHOLE_LOCATION, 32, 1, 32, DEFAULT_TRANSLUCENT_RGBA))));
    public static final ResourcepackModel.Wormhole STARGATE_SHINY_WORMHOLE_TEXTURE = new ResourcepackModel.Wormhole((Either<ResourcepackModel.FrontBack, ResourcepackModel.WormholeTexture>)Either.left((Object)new ResourcepackModel.FrontBack(new ResourcepackModel.WormholeTexture(STARGATE_SHINY_WORMHOLE_LOCATION, 32, 1, 32, DEFAULT_OPAQUE_RGBA), new ResourcepackModel.WormholeTexture(STARGATE_SHINY_WORMHOLE_LOCATION, 32, 1, 32, DEFAULT_TRANSLUCENT_RGBA))));
    public static final ResourcepackModel.SymbolsModel STARGATE_SYMBOLS = new ResourcepackModel.SymbolsModel(new ColorUtil.RGBA(21, 9, 0, 255), Optional.of(new ColorUtil.RGBA(200, 220, 255, 255)), Optional.of(new ColorUtil.RGBA(200, 220, 255, 255)), false, true, true, true, false, Optional.empty(), Optional.empty());
    public static final ResourcepackSounds.Chevron STARGATE_CHEVRON_ENGAGED_SOUNDS = new ResourcepackSounds.Chevron(STARGATE_CHEVRON_ENGAGE);
    public static final ResourcepackSounds.Chevron STARGATE_CHEVRON_INCOMING_SOUNDS = new ResourcepackSounds.Chevron(StargateJourney.EMPTY_LOCATION);
    public static final ResourcepackSounds.Rotation STARGATE_ROTATION_SOUNDS = new ResourcepackSounds.Rotation(STARGATE_RING_SPIN_START, STARGATE_RING_SPIN, StargateJourney.EMPTY_LOCATION);
    public static final ResourcepackSounds.Wormhole STARGATE_WROMHOLE_SOUNDS = new ResourcepackSounds.Wormhole((Either<StargateInfo.IncomingOutgoing<ResourceLocation>, ResourceLocation>)Either.right((Object)STARGATE_WORMHOLE_OPEN), (Either<StargateInfo.IncomingOutgoing<ResourceLocation>, ResourceLocation>)Either.right((Object)STARGATE_WORMHOLE_IDLE), (Either<StargateInfo.IncomingOutgoing<ResourceLocation>, ResourceLocation>)Either.right((Object)STARGATE_WORMHOLE_CLOSE));
    public static final ResourcepackSounds.Fail STARGATE_FAIL_SOUNDS = new ResourcepackSounds.Fail(STARGATE_FAIL);
    public static final UniverseStargateVariant DEFAULT_VARIANT = new UniverseStargateVariant(STARGATE_TEXTURE, Optional.empty(), STARGATE_ENGAGED_TEXTURE, STARGATE_WORMHOLE_TEXTURE, Optional.of(STARGATE_SHINY_WORMHOLE_TEXTURE), STARGATE_SYMBOLS, STARGATE_CHEVRON_ENGAGED_SOUNDS, STARGATE_CHEVRON_INCOMING_SOUNDS, STARGATE_ROTATION_SOUNDS, STARGATE_WROMHOLE_SOUNDS, STARGATE_FAIL_SOUNDS, STARGATE_DIAL_START, Optional.empty());
    private ResourceLocation dialStartSound;
    @Nullable
    private Boolean onlyFrontRotates;
    public static final Codec<UniverseStargateVariant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("texture").forGetter(ClientStargateVariant::texture), (App)ResourceLocation.f_135803_.optionalFieldOf("encoded_texture").forGetter(variant -> Optional.ofNullable(variant.encodedTexture)), (App)ResourceLocation.f_135803_.fieldOf("engaged_texture").forGetter(ClientStargateVariant::engagedTexture), (App)ResourcepackModel.Wormhole.CODEC.fieldOf("wormhole").forGetter(ClientStargateVariant::wormhole), (App)ResourcepackModel.Wormhole.CODEC.optionalFieldOf("shiny_wormhole").forGetter(ClientStargateVariant::shinyWormhole), (App)ResourcepackModel.SymbolsModel.CODEC.fieldOf("symbols").forGetter(ClientStargateVariant::symbols), (App)ResourcepackSounds.Chevron.CODEC.fieldOf("chevron_engaged_sounds").forGetter(ClientStargateVariant::chevronEngagedSounds), (App)ResourcepackSounds.Chevron.CODEC.fieldOf("chevron_incoming_sounds").forGetter(ClientStargateVariant::chevronIncomingSounds), (App)ResourcepackSounds.Rotation.CODEC.fieldOf("rotation_sounds").forGetter(RotatingStargateVariant::rotationSounds), (App)ResourcepackSounds.Wormhole.CODEC.fieldOf("wormhole_sounds").forGetter(ClientStargateVariant::wormholeSounds), (App)ResourcepackSounds.Fail.CODEC.fieldOf("fail_sounds").forGetter(ClientStargateVariant::failSounds), (App)ResourceLocation.f_135803_.optionalFieldOf(DIAL_START_SOUND, (Object)STARGATE_DIAL_START).forGetter(UniverseStargateVariant::dialStartSound), (App)Codec.BOOL.optionalFieldOf(ONLY_FRONT_ROTATES).forGetter(variant -> Optional.ofNullable(variant.onlyFrontRotates))).apply((Applicative)instance, UniverseStargateVariant::new));

    public UniverseStargateVariant(ResourceLocation texture, Optional<ResourceLocation> encodedTexture, ResourceLocation engagedTexture, ResourcepackModel.Wormhole wormhole, Optional<ResourcepackModel.Wormhole> shinyWormhole, ResourcepackModel.SymbolsModel symbols, ResourcepackSounds.Chevron chevronEngagedSounds, ResourcepackSounds.Chevron chevronIncomingSounds, ResourcepackSounds.Rotation rotationSounds, ResourcepackSounds.Wormhole wormholeSounds, ResourcepackSounds.Fail failSounds, ResourceLocation dialStartSound, Optional<Boolean> onlyFrontRotates) {
        super(texture, encodedTexture, engagedTexture, wormhole, shinyWormhole, symbols, chevronEngagedSounds, chevronIncomingSounds, rotationSounds, wormholeSounds, failSounds);
        this.dialStartSound = dialStartSound;
        if (onlyFrontRotates.isPresent()) {
            this.onlyFrontRotates = onlyFrontRotates.get();
        }
    }

    public ResourceLocation dialStartSound() {
        return this.dialStartSound;
    }

    public boolean onlyFrontRotates() {
        if (this.onlyFrontRotates != null) {
            return this.onlyFrontRotates;
        }
        return ClientStargateConfig.universe_front_rotates.get();
    }
}

