/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClientStargateVariant;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.misc.ColorUtil;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public abstract class AbstractStargateModel<StargateEntity extends AbstractStargateEntity, Variant extends ClientStargateVariant> {
    protected static final float DEFAULT_RADIUS = 3.5f;
    protected static final int DEFAULT_SIDES = 36;
    protected static final float DEFAULT_RING_HEIGHT = 1.0f;
    protected static final float STARGATE_RING_SHRINK = 0.001f;
    protected static final float DEFAULT_ANGLE = 10.0f;
    protected static final float NUMBER_OF_CHEVRONS = 9.0f;
    protected static final float CHEVRON_ANGLE = 40.0f;
    protected static final int MAX_LIGHT = 0xF000F0;
    protected static final int DEFAULT_TEXTURE_SIZE = 64;
    public static final ResourceLocation ERROR_LOCATION = new ResourceLocation("sgjourney", "textures/symbols/error.png");
    public static final ResourceLocation EMPTY_LOCATION = new ResourceLocation("sgjourney", "textures/symbols/empty.png");
    public static final String EMPTY = StargateJourney.EMPTY;
    private static Minecraft minecraft = Minecraft.m_91087_();
    protected final short numberOfSymbols;

    public AbstractStargateModel(short numberOfSymbols) {
        this.numberOfSymbols = numberOfSymbols;
    }

    @Nullable
    protected PointOfOrigin getPointOfOrigin(AbstractStargateEntity stargate, Variant stargateVariant) {
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        RegistryAccess registries = clientPacketListener.m_105152_();
        Registry pointOfOriginRegistry = registries.m_175515_(PointOfOrigin.REGISTRY_KEY);
        if (((ClientStargateVariant)stargateVariant).symbols().permanentPointOfOrigin().isPresent()) {
            return (PointOfOrigin)pointOfOriginRegistry.m_6246_(((ClientStargateVariant)stargateVariant).symbols().permanentPointOfOrigin().get());
        }
        return (PointOfOrigin)pointOfOriginRegistry.m_7745_(stargate.symbolInfo().pointOfOrigin());
    }

    protected ResourceLocation getPointOfOriginTexture(@Nullable PointOfOrigin pointOfOrigin) {
        if (pointOfOrigin != null) {
            return pointOfOrigin.texture();
        }
        return EMPTY_LOCATION;
    }

    @Nullable
    protected Symbols getSymbols(AbstractStargateEntity stargate, Variant stargateVariant) {
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        RegistryAccess registries = clientPacketListener.m_105152_();
        Registry symbolRegistry = registries.m_175515_(Symbols.REGISTRY_KEY);
        if (((ClientStargateVariant)stargateVariant).symbols().permanentSymbols().isPresent()) {
            return (Symbols)symbolRegistry.m_6246_(((ClientStargateVariant)stargateVariant).symbols().permanentSymbols().get());
        }
        return (Symbols)symbolRegistry.m_7745_(stargate.symbolInfo().symbols());
    }

    protected ResourceLocation getSymbolTexture(@Nullable Symbols symbols) {
        if (symbols != null) {
            return symbols.getSymbolTexture();
        }
        return EMPTY_LOCATION;
    }

    public void renderStargate(StargateEntity stargate, Variant stargateVariant, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        VertexConsumer consumer = source.m_6299_(SGJourneyRenderTypes.stargate(((ClientStargateVariant)stargateVariant).texture()));
        this.renderRing(stargate, stargateVariant, partialTick, stack, consumer, source, combinedLight, combinedOverlay);
        this.renderChevrons(stargate, stargateVariant, stack, source, combinedLight, combinedOverlay);
    }

    public abstract void renderRing(StargateEntity var1, Variant var2, float var3, PoseStack var4, VertexConsumer var5, MultiBufferSource var6, int var7, int var8);

    protected boolean isPrimaryChevronRaised(StargateEntity stargate, Variant stargateVariant) {
        return false;
    }

    protected boolean isPrimaryChevronLowered(StargateEntity stargate, Variant stargateVariant) {
        return false;
    }

    protected boolean isPrimaryChevronEngaged(StargateEntity stargate, Variant stargateVariant) {
        if (((AbstractStargateEntity)stargate).isConnected()) {
            return ((AbstractStargateEntity)stargate).isDialingOut() || ((AbstractStargateEntity)stargate).getKawooshTickCount() > 0;
        }
        return false;
    }

    protected boolean isChevronRaised(StargateEntity stargate, Variant stargateVariant, int chevronNumber) {
        return false;
    }

    protected boolean isChevronLowered(StargateEntity stargate, Variant stargateVariant, int chevronNumber) {
        return false;
    }

    protected boolean isChevronEngaged(StargateEntity stargate, Variant stargateVariant, int chevronNumber) {
        return ((AbstractStargateEntity)stargate).chevronsRendered() >= chevronNumber;
    }

    protected abstract void renderPrimaryChevron(StargateEntity var1, Variant var2, PoseStack var3, VertexConsumer var4, MultiBufferSource var5, int var6, boolean var7);

    protected abstract void renderChevron(StargateEntity var1, Variant var2, PoseStack var3, VertexConsumer var4, MultiBufferSource var5, int var6, int var7, boolean var8);

    protected void renderChevrons(StargateEntity stargate, Variant stargateVariant, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        int chevronNumber;
        VertexConsumer consumer;
        if (StargateJourney.isOculusLoaded()) {
            consumer = source.m_6299_(SGJourneyRenderTypes.engagedChevron(((ClientStargateVariant)stargateVariant).engagedTexture()));
            if (this.isPrimaryChevronEngaged(stargate, stargateVariant)) {
                this.renderPrimaryChevron(stargate, stargateVariant, stack, consumer, source, combinedLight, true);
            }
            chevronNumber = 1;
            while ((float)chevronNumber < 9.0f) {
                if (this.isChevronEngaged(stargate, stargateVariant, chevronNumber)) {
                    this.renderChevron(stargate, stargateVariant, stack, consumer, source, combinedLight, chevronNumber, true);
                }
                ++chevronNumber;
            }
        }
        consumer = source.m_6299_(SGJourneyRenderTypes.chevron(((ClientStargateVariant)stargateVariant).texture()));
        this.renderPrimaryChevron(stargate, stargateVariant, stack, consumer, source, combinedLight, false);
        chevronNumber = 1;
        while ((float)chevronNumber < 9.0f) {
            this.renderChevron(stargate, stargateVariant, stack, consumer, source, combinedLight, chevronNumber, false);
            ++chevronNumber;
        }
        if (!StargateJourney.isOculusLoaded()) {
            consumer = source.m_6299_(SGJourneyRenderTypes.engagedChevron(((ClientStargateVariant)stargateVariant).engagedTexture()));
            if (this.isPrimaryChevronEngaged(stargate, stargateVariant)) {
                this.renderPrimaryChevron(stargate, stargateVariant, stack, consumer, source, combinedLight, true);
            }
            chevronNumber = 1;
            while ((float)chevronNumber < 9.0f) {
                if (this.isChevronEngaged(stargate, stargateVariant, chevronNumber)) {
                    this.renderChevron(stargate, stargateVariant, stack, consumer, source, combinedLight, chevronNumber, true);
                }
                ++chevronNumber;
            }
        }
    }

    protected boolean symbolsGlow(StargateEntity stargate, Variant stargateVariant, boolean isEngaged) {
        if (isEngaged) {
            return ((AbstractStargateEntity)stargate).isConnected() ? ((ClientStargateVariant)stargateVariant).symbols().engagedSymbolsGlow() : ((ClientStargateVariant)stargateVariant).symbols().encodedSymbolsGlow();
        }
        return ((ClientStargateVariant)stargateVariant).symbols().symbolsGlow();
    }

    protected ColorUtil.RGBA getSymbolColor(StargateEntity stargate, Variant stargateVariant, StargateInfo.ChevronSymbolState state, boolean incoming) {
        if (state == StargateInfo.ChevronSymbolState.OFF) {
            return ((ClientStargateVariant)stargateVariant).symbols().symbolColor();
        }
        if (state == StargateInfo.ChevronSymbolState.ENGAGED) {
            return ((ClientStargateVariant)stargateVariant).symbols().engagedSymbolColor();
        }
        return ((ClientStargateVariant)stargateVariant).symbols().encodedSymbolColor();
    }

    protected ColorUtil.RGBA getSymbolColor(StargateEntity stargate, Variant stargateVariant, boolean isEngaged) {
        if (isEngaged) {
            return ((AbstractStargateEntity)stargate).isConnected() ? ((ClientStargateVariant)stargateVariant).symbols().engagedSymbolColor() : ((ClientStargateVariant)stargateVariant).symbols().encodedSymbolColor();
        }
        return ((ClientStargateVariant)stargateVariant).symbols().symbolColor();
    }
}

