/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.tracker;

import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.tracker.IStorageTracker;
import com.refinedmods.refinedstorage.api.storage.tracker.IStorageTrackerManager;
import com.refinedmods.refinedstorage.apiimpl.storage.tracker.FluidStorageTracker;
import com.refinedmods.refinedstorage.apiimpl.storage.tracker.ItemStorageTracker;
import com.refinedmods.refinedstorage.apiimpl.util.RSSavedData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class StorageTrackerManager
extends RSSavedData
implements IStorageTrackerManager {
    public static final String NAME = "refinedstorage_tracker";
    private static final String NBT_TRACKERS = "Tracker";
    private static final String NBT_TRACKER_ID = "Id";
    private static final String NBT_TRACKER_DATA = "Data";
    private static final String NBT_TRACKER_TYPE = "Type";
    private final Map<UUID, IStorageTracker<?>> trackers = new HashMap();

    @Override
    public void markForSaving() {
        this.m_77762_();
    }

    @Override
    public IStorageTracker<?> getOrCreate(UUID uuid, StorageType type) {
        IStorageTracker<ItemStack> tracker = this.trackers.get(uuid);
        if (tracker == null) {
            if (type == StorageType.ITEM) {
                tracker = new ItemStorageTracker(this::markForSaving);
            } else if (type == StorageType.FLUID) {
                tracker = new FluidStorageTracker(this::markForSaving);
            }
            this.trackers.put(uuid, tracker);
        }
        return tracker;
    }

    @Override
    public void remove(UUID id) {
        this.trackers.remove(id);
    }

    @Override
    public void load(CompoundTag nbt) {
        if (nbt.m_128441_(NBT_TRACKERS)) {
            ListTag trackerTags = nbt.m_128437_(NBT_TRACKERS, 10);
            for (int i = 0; i < trackerTags.size(); ++i) {
                CompoundTag trackerTag = trackerTags.m_128728_(i);
                UUID id = trackerTag.m_128342_(NBT_TRACKER_ID);
                ListTag data = trackerTag.m_128437_(NBT_TRACKER_DATA, 10);
                StorageType type = StorageType.values()[trackerTag.m_128451_(NBT_TRACKER_TYPE)];
                IStorageTracker<?> tracker = this.getOrCreate(id, type);
                tracker.readFromNbt(data);
            }
        }
    }

    @Override
    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag trackerListTag = new ListTag();
        for (Map.Entry<UUID, IStorageTracker<?>> entry : this.trackers.entrySet()) {
            CompoundTag trackerTag = new CompoundTag();
            trackerTag.m_128362_(NBT_TRACKER_ID, entry.getKey());
            trackerTag.m_128365_(NBT_TRACKER_DATA, (Tag)entry.getValue().serializeNbt());
            trackerTag.m_128405_(NBT_TRACKER_TYPE, entry.getValue() instanceof ItemStorageTracker ? StorageType.ITEM.ordinal() : StorageType.FLUID.ordinal());
            trackerListTag.add((Object)trackerTag);
        }
        compound.m_128365_(NBT_TRACKERS, (Tag)trackerListTag);
        return compound;
    }
}

